/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.calculator;

import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.CustomFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ITableDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.RowCalculator;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterWithValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.util.DataTypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class GridExpressionUtils {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, GridExpressionUtils.class);
    private static final String FILTER_EVALUATION_ERROR_MSG = "Problem occured during applying the filter.<br><br>Check that all provided parameter values are correct. If everything seems fine contact filter registrator or instance admin about a possible bug in the filter definition.";
    private static final String EVALUATION_SERIOUS_ERROR_MSG = "Serious problem occured during ";
    private static final String FILTER_EVALUATION_SERIOUS_ERROR_MSG = "Serious problem occured during applying the filter: ";
    private static final String COLUMN_EVALUATION_ERROR_TEMPLATE_SHORT = "Error. Please contact '%s', who defined this column.";
    private static final String COLUMN_EVALUATION_ERROR_LONG = "Error: (%s).";

    public static List<Integer> applyCustomFilter(ITableDataProvider dataProvider, CustomFilterInfo<?> customFilterInfo) {
        ArrayList<Integer> filtered = new ArrayList<Integer>();
        String expression = StringEscapeUtils.unescapeHtml((String)customFilterInfo.getExpression());
        Set<ParameterWithValue> parameters = customFilterInfo.getParameters();
        try {
            RowCalculator calculator = new RowCalculator(dataProvider, expression, parameters);
            List<List<Comparable<?>>> rows = dataProvider.getRows();
            int i = 0;
            while (i < rows.size()) {
                List<? extends Comparable<?>> row = rows.get(i);
                calculator.setRowData(row);
                if (calculator.evalToBoolean()) {
                    filtered.add(i);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw GridExpressionUtils.createInvalidFilterException(ex);
        }
        return filtered;
    }

    private static UserFailureException createInvalidFilterException(Exception ex) {
        String msg;
        String details = null;
        if (ex instanceof EvaluatorException) {
            msg = FILTER_EVALUATION_ERROR_MSG;
            details = ex.getMessage();
        } else {
            msg = FILTER_EVALUATION_SERIOUS_ERROR_MSG + ex;
        }
        GridExpressionUtils.logColumnCalculationError(ex, msg, details);
        return new UserFailureException(msg, details);
    }

    public static List<PrimitiveValue> evalCustomColumn(ITableDataProvider dataProvider, GridCustomColumn customColumn, boolean errorMessagesAreLong) {
        RowCalculator calculator = GridExpressionUtils.createRowCalculator(dataProvider, customColumn, errorMessagesAreLong);
        ArrayList<PrimitiveValue> values = new ArrayList<PrimitiveValue>();
        List<List<Comparable<?>>> rows = dataProvider.getRows();
        for (List<? extends Comparable<?>> list : rows) {
            PrimitiveValue value = GridExpressionUtils.evalCustomColumn(list, customColumn, calculator, errorMessagesAreLong);
            if (value != PrimitiveValue.NULL) {
                customColumn.setDataType(DataTypeUtils.getCompatibleDataType(customColumn.getDataType(), value.getDataType()));
            }
            values.add(value);
        }
        return values;
    }

    private static RowCalculator createRowCalculator(ITableDataProvider dataProvider, GridCustomColumn customColumn, boolean errorMessagesAreLong) {
        String expression = StringEscapeUtils.unescapeHtml((String)customColumn.getExpression());
        try {
            return new RowCalculator(dataProvider, expression);
        }
        catch (Exception ex) {
            String msg = GridExpressionUtils.createCustomColumnErrorMessage(customColumn, errorMessagesAreLong, ex).replace("'", "\\'");
            return new RowCalculator(dataProvider, "'" + msg + "'");
        }
    }

    private static PrimitiveValue evalCustomColumn(List<? extends Comparable<?>> rowData, GridCustomColumn customColumn, RowCalculator calculator, boolean errorMessagesAreLong) {
        try {
            calculator.setRowData(rowData);
            return calculator.getTypedResult();
        }
        catch (Exception ex) {
            return new PrimitiveValue(GridExpressionUtils.createCustomColumnErrorMessage(customColumn, errorMessagesAreLong, ex));
        }
    }

    private static String createCustomColumnErrorMessage(GridCustomColumn customColumn, boolean errorMessagesAreLong, Exception ex) {
        Person registrator = customColumn.getRegistrator();
        String creator = registrator + " <" + registrator.getEmail() + ">";
        String msg = errorMessagesAreLong ? String.format(COLUMN_EVALUATION_ERROR_LONG, ex.getMessage()) : String.format(COLUMN_EVALUATION_ERROR_TEMPLATE_SHORT, creator);
        return msg;
    }

    private static void logColumnCalculationError(Exception ex, String msg, String details) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)(String.valueOf(msg) + " DETAILS: " + details), (Throwable)ex);
        }
    }
}

