/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationService;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationTransaction;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationException;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationTransaction;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataTransactionErrors;
import java.util.ArrayList;
import java.util.List;

public class MasterDataRegistrationService
implements IMasterDataRegistrationService {
    private final EncapsulatedCommonServer commonServer;
    private final List<MasterDataRegistrationTransaction> createdTransactions = new ArrayList<MasterDataRegistrationTransaction>();

    public MasterDataRegistrationService(EncapsulatedCommonServer commonServer) {
        this.commonServer = commonServer;
    }

    @Override
    public IMasterDataRegistrationTransaction transaction() {
        MasterDataRegistrationTransaction transaction = new MasterDataRegistrationTransaction(this.commonServer);
        this.createdTransactions.add(transaction);
        return transaction;
    }

    void commit() throws MasterDataRegistrationException {
        ArrayList<MasterDataTransactionErrors> transactionErrors = new ArrayList<MasterDataTransactionErrors>();
        for (MasterDataRegistrationTransaction transaction : this.createdTransactions) {
            transaction.commit();
            if (!transaction.hasErrors()) continue;
            transactionErrors.add(transaction.getTransactionErrors());
        }
        if (!transactionErrors.isEmpty()) {
            throw new MasterDataRegistrationException("Some of the executed transactions have failed to commit", transactionErrors);
        }
    }
}

