/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellFeatureVectorReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IHCSFeatureVectorLoader;
import java.util.Arrays;
import java.util.List;

public class FeatureVectorValuesLoader {
    public static FeatureVectorValues loadFeatureVectorValues(Session session, IScreeningBusinessObjectFactory businessObjectFactory, String datasetCode, String datastoreCode, WellLocation wellLocation) {
        IHCSFeatureVectorLoader loader = businessObjectFactory.createHCSFeatureVectorLoader(datastoreCode);
        List<WellFeatureVectorReference> wellReferences = Arrays.asList(new WellFeatureVectorReference(datasetCode, wellLocation));
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureVectors = loader.fetchWellFeatureValuesIfPossible(session, wellReferences);
        List<FeatureVectorValues> features = featureVectors.getFeatures();
        if (features.size() == 0) {
            return null;
        }
        return featureVectors.getFeatures().get(0);
    }
}

