/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.ByteArrayHandle;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.in.APNGReader;
import loci.formats.in.BMPReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;

public class CellSensReader
extends FormatReader {
    private static final int RAW = 0;
    private static final int JPEG = 2;
    private static final int JPEG_2000 = 3;
    private static final int PNG = 8;
    private static final int BMP = 9;
    private static final int CHAR = 1;
    private static final int UCHAR = 2;
    private static final int SHORT = 3;
    private static final int USHORT = 4;
    private static final int INT = 5;
    private static final int UINT = 6;
    private static final int LONG = 7;
    private static final int ULONG = 8;
    private static final int FLOAT = 9;
    private static final int DOUBLE = 10;
    private static final int COMPLEX = 11;
    private static final int BOOLEAN = 12;
    private static final int TCHAR = 13;
    private static final int DWORD = 14;
    private static final int TIMESTAMP = 17;
    private static final int DATE = 18;
    private static final int INT_2 = 256;
    private static final int INT_3 = 257;
    private static final int INT_4 = 258;
    private static final int INT_RECT = 259;
    private static final int DOUBLE_2 = 260;
    private static final int DOUBLE_3 = 261;
    private static final int DOUBLE_4 = 262;
    private static final int DOUBLE_RECT = 263;
    private static final int DOUBLE_2_2 = 264;
    private static final int DOUBLE_3_3 = 265;
    private static final int DOUBLE_4_4 = 266;
    private static final int INT_INTERVAL = 267;
    private static final int DOUBLE_INTERVAL = 268;
    private static final int RGB = 269;
    private static final int BGR = 270;
    private static final int FIELD_TYPE = 271;
    private static final int MEM_MODEL = 272;
    private static final int COLOR_SPACE = 273;
    private static final int INT_ARRAY_2 = 274;
    private static final int INT_ARRAY_3 = 275;
    private static final int INT_ARRAY_4 = 276;
    private static final int INT_ARRAY_5 = 277;
    private static final int DOUBLE_ARRAY_2 = 279;
    private static final int DOUBLE_ARRAY_3 = 280;
    private static final int UNICODE_TCHAR = 8192;
    private static final int DIM_INDEX_1 = 8195;
    private static final int DIM_INDEX_2 = 8199;
    private static final int VOLUME_INDEX = 8200;
    private static final int PIXEL_INFO_TYPE = 8470;
    private static final int NEW_VOLUME_HEADER = 0;
    private static final int PROPERTY_SET_VOLUME = 1;
    private static final int NEW_MDIM_VOLUME_HEADER = 2;
    private static final int TIFF_IFD = 10;
    private static final int VECTOR_DATA = 11;
    private String[] usedFiles;
    private TiffParser parser;
    private IFDList ifds;
    private Long[][] tileOffsets;
    private boolean jpeg = false;
    private int[] rows;
    private int[] cols;
    private int[] compressionType;
    private int[] tileX;
    private int[] tileY;
    private HashMap<TileCoordinate, Integer>[] tileMap;
    private int[] nDimensions;
    private boolean inDimensionProperties = false;
    private boolean foundChannelTag = false;
    private int dimensionTag;
    private HashMap<String, Integer> dimensionOrdering = new HashMap();

    public CellSensReader() {
        super("CellSens VSI", new String[]{"vsi", "ets"});
        this.domains = new String[]{"Histology"};
        this.suffixSufficient = true;
        this.datasetDescription = "One .vsi file and an optional directory with a similar name that contains at least one subdirectory with .ets files";
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.usedFiles;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCoreIndex() < this.core.length - this.ifds.size()) {
            return this.tileX[this.getCoreIndex()];
        }
        int ifdIndex = this.getCoreIndex() - (this.usedFiles.length - 1);
        try {
            return (int)((IFD)this.ifds.get(ifdIndex)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCoreIndex() < this.core.length - this.ifds.size()) {
            return this.tileY[this.getCoreIndex()];
        }
        int ifdIndex = this.getCoreIndex() - (this.usedFiles.length - 1);
        try {
            return (int)((IFD)this.ifds.get(ifdIndex)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentSeries = this.getSeries();
        int thumbSize = this.getThumbSizeX() * this.getThumbSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()) * this.getRGBChannelCount();
        if (this.getCoreIndex() >= this.usedFiles.length - 1 || this.usedFiles.length >= this.core.length) {
            return super.openThumbBytes(no);
        }
        this.setSeries(this.usedFiles.length);
        byte[] thumb = FormatTools.openThumbBytes(this, 0);
        this.setSeries(currentSeries);
        if (thumb.length == thumbSize) {
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.getCoreIndex() < this.core.length - this.ifds.size()) {
            int tileRows = this.rows[this.getCoreIndex()];
            int tileCols = this.cols[this.getCoreIndex()];
            Region image = new Region(x, y, w, h);
            int outputRow = 0;
            int outputCol = 0;
            Region intersection = null;
            byte[] tileBuf = null;
            int pixel = this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
            int outputRowLen = w * pixel;
            for (int row = 0; row < tileRows; ++row) {
                for (int col = 0; col < tileCols; ++col) {
                    int height;
                    int width = this.tileX[this.getCoreIndex()];
                    Region tile = new Region(col * width, row * (height = this.tileY[this.getCoreIndex()]), width, height);
                    if (!tile.intersects(image)) continue;
                    intersection = tile.intersection(image);
                    int intersectionX = 0;
                    if (tile.x < image.x) {
                        intersectionX = image.x - tile.x;
                    }
                    tileBuf = this.decodeTile(no, row, col);
                    int rowLen = pixel * Math.min(intersection.width, width);
                    int outputOffset = outputRow * outputRowLen + outputCol;
                    for (int trow = 0; trow < intersection.height; ++trow) {
                        int realRow = trow + intersection.y - tile.y;
                        int inputOffset = pixel * (realRow * width + intersectionX);
                        System.arraycopy(tileBuf, inputOffset, buf, outputOffset, rowLen);
                        outputOffset += outputRowLen;
                    }
                    outputCol += rowLen;
                }
                if (intersection == null) continue;
                outputRow += intersection.height;
                outputCol = 0;
            }
            return buf;
        }
        int ifdIndex = this.getCoreIndex() - (this.usedFiles.length - 1);
        return this.parser.getSamples((IFD)this.ifds.get(ifdIndex), buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.parser != null && this.parser.getStream() != null) {
                this.parser.getStream().close();
            }
            this.parser = null;
            this.ifds = null;
            this.usedFiles = null;
            this.tileOffsets = null;
            this.jpeg = false;
            this.rows = null;
            this.cols = null;
            this.compressionType = null;
            this.tileX = null;
            this.tileY = null;
            this.tileMap = null;
            this.nDimensions = null;
            this.inDimensionProperties = false;
            this.foundChannelTag = false;
            this.dimensionTag = 0;
            this.dimensionOrdering.clear();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int s;
        super.initFile(id);
        if (!CellSensReader.checkSuffix(id, "vsi")) {
            Location current = new Location(id).getAbsoluteFile();
            Location parent = current.getParentFile();
            parent = parent.getParentFile();
            Location grandparent = parent.getParentFile();
            String vsi = parent.getName();
            Location vsiFile = new Location(grandparent, vsi = vsi.substring(1, vsi.length() - 1) + ".vsi");
            if (!vsiFile.exists()) {
                throw new FormatException("Could not find .vsi file.");
            }
            id = vsiFile.getAbsolutePath();
        }
        this.parser = new TiffParser(id);
        this.ifds = this.parser.getIFDs();
        RandomAccessInputStream vsi = new RandomAccessInputStream(id);
        vsi.order(this.parser.getStream().isLittleEndian());
        vsi.seek(8L);
        this.readTags(vsi);
        vsi.seek(this.parser.getStream().getFilePointer());
        vsi.skipBytes(273);
        ArrayList<String> files = new ArrayList<String>();
        Location file2 = new Location(id).getAbsoluteFile();
        Location dir = file2.getParentFile();
        String name = file2.getName();
        name = name.substring(0, name.lastIndexOf("."));
        Location pixelsDir = new Location(dir, "_" + name + "_");
        String[] stackDirs = pixelsDir.list(true);
        if (stackDirs != null) {
            for (String f : stackDirs) {
                Location stackDir = new Location(pixelsDir, f);
                String[] pixelsFiles = stackDir.list(true);
                if (pixelsFiles == null) continue;
                for (String pixelsFile : pixelsFiles) {
                    if (!CellSensReader.checkSuffix(pixelsFile, "ets")) continue;
                    files.add(new Location(stackDir, pixelsFile).getAbsolutePath());
                }
            }
        }
        files.add(file2.getAbsolutePath());
        this.usedFiles = files.toArray(new String[files.size()]);
        this.core = new CoreMetadata[files.size() - 1 + this.ifds.size()];
        this.tileOffsets = new Long[files.size() - 1][];
        this.rows = new int[files.size() - 1];
        this.cols = new int[files.size() - 1];
        this.nDimensions = new int[this.core.length];
        IFDList exifs = this.parser.getExifIFDs();
        this.compressionType = new int[this.core.length];
        this.tileX = new int[this.core.length];
        this.tileY = new int[this.core.length];
        this.tileMap = new HashMap[this.core.length];
        for (s = 0; s < this.core.length; ++s) {
            this.core[s] = new CoreMetadata();
        }
        for (s = 0; s < this.core.length; ++s) {
            this.tileMap[s] = new HashMap();
            if (s == 0 && !this.hasFlattenedResolutions()) {
                this.core[s].resolutionCount = this.ifds.size() + (files.size() == 1 ? 0 : 1);
            }
            if (s < files.size() - 1) {
                this.setSeries(s);
                this.parseETSFile((String)files.get(s), s);
                this.core[s].littleEndian = this.compressionType[s] == 0;
                this.core[s].interleaved = this.core[s].rgb;
                if (s == 0 && exifs.size() > 0) {
                    IFD exif = (IFD)exifs.get(0);
                    int newX = exif.getIFDIntValue(40962);
                    int newY = exif.getIFDIntValue(40963);
                    if (this.getSizeX() > newX || this.getSizeY() > newY) {
                        this.core[s].sizeX = newX;
                        this.core[s].sizeY = newY;
                    }
                }
                this.setSeries(0);
            } else {
                IFD ifd = (IFD)this.ifds.get(s - files.size() + 1);
                PhotoInterp p = ifd.getPhotometricInterpretation();
                int samples = ifd.getSamplesPerPixel();
                this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
                this.core[s].sizeX = (int)ifd.getImageWidth();
                this.core[s].sizeY = (int)ifd.getImageLength();
                this.core[s].sizeZ = 1;
                this.core[s].sizeT = 1;
                this.core[s].sizeC = this.core[s].rgb ? samples : 1;
                this.core[s].littleEndian = ifd.isLittleEndian();
                this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                this.core[s].imageCount = 1;
                this.core[s].pixelType = ifd.getPixelType();
                this.core[s].interleaved = false;
                this.core[s].falseColor = false;
                this.core[s].thumbnail = s != 0;
            }
            this.core[s].metadataComplete = true;
            this.core[s].dimensionOrder = "XYCZT";
        }
        vsi.close();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private int getTileSize() {
        int channels = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        return bpp * channels * this.tileX[this.getCoreIndex()] * this.tileY[this.getCoreIndex()];
    }

    private byte[] decodeTile(int no, int row, int col) throws FormatException, IOException {
        if (this.tileMap[this.getCoreIndex()] == null) {
            return new byte[this.getTileSize()];
        }
        int[] zct = this.getZCTCoords(no);
        TileCoordinate t = new TileCoordinate(this.nDimensions[this.getCoreIndex()]);
        t.coordinate[0] = col;
        t.coordinate[1] = row;
        for (String dim : this.dimensionOrdering.keySet()) {
            int index = this.dimensionOrdering.get(dim) + 2;
            if (dim.equals("Z")) {
                t.coordinate[index] = zct[0];
                continue;
            }
            if (dim.equals("C")) {
                t.coordinate[index] = zct[1];
                continue;
            }
            if (!dim.equals("T")) continue;
            t.coordinate[index] = zct[2];
        }
        Integer index = this.tileMap[this.getCoreIndex()].get(t);
        if (index == null) {
            return new byte[this.getTileSize()];
        }
        Long offset = this.tileOffsets[this.getCoreIndex()][index];
        RandomAccessInputStream ets = new RandomAccessInputStream(this.usedFiles[this.getCoreIndex()]);
        ets.seek(offset);
        CodecOptions options = new CodecOptions();
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        int tileSize = this.getTileSize();
        if (tileSize == 0) {
            tileSize = this.tileX[this.getCoreIndex()] * this.tileY[this.getCoreIndex()] * 10;
        }
        options.maxBytes = (int)(offset + (long)tileSize);
        byte[] buf = null;
        long end = index < this.tileOffsets[this.getCoreIndex()].length - 1 ? this.tileOffsets[this.getCoreIndex()][index + 1].longValue() : ets.length();
        Closeable reader = null;
        String file2 = null;
        switch (this.compressionType[this.getCoreIndex()]) {
            case 0: {
                buf = new byte[tileSize];
                ets.read(buf);
                break;
            }
            case 2: {
                JPEGCodec codec = new JPEGCodec();
                buf = codec.decompress(ets, options);
                break;
            }
            case 3: {
                JPEG2000Codec codec = new JPEG2000Codec();
                buf = codec.decompress(ets, options);
                break;
            }
            case 8: {
                file2 = "tile.png";
                reader = new APNGReader();
            }
            case 9: {
                if (reader == null) {
                    file2 = "tile.bmp";
                    reader = new BMPReader();
                }
                byte[] b = new byte[(int)(end - offset)];
                ets.read(b);
                Location.mapFile(file2, new ByteArrayHandle(b));
                reader.setId(file2);
                buf = reader.openBytes(0);
                Location.mapFile(file2, null);
            }
        }
        if (reader != null) {
            reader.close();
        }
        ets.close();
        return buf;
    }

    private void parseETSFile(String file2, int s) throws FormatException, IOException {
        RandomAccessInputStream etsFile = new RandomAccessInputStream(file2);
        etsFile.order(true);
        String magic = etsFile.readString(4).trim();
        if (!magic.equals("SIS")) {
            throw new FormatException("Unknown magic bytes: " + magic);
        }
        int headerSize = etsFile.readInt();
        int version = etsFile.readInt();
        this.nDimensions[s] = etsFile.readInt();
        long additionalHeaderOffset = etsFile.readLong();
        int additionalHeaderSize = etsFile.readInt();
        etsFile.skipBytes(4);
        long usedChunkOffset = etsFile.readLong();
        int nUsedChunks = etsFile.readInt();
        etsFile.skipBytes(4);
        etsFile.seek(additionalHeaderOffset);
        String moreMagic = etsFile.readString(4).trim();
        if (!moreMagic.equals("ETS")) {
            throw new FormatException("Unknown magic bytes: " + moreMagic);
        }
        etsFile.skipBytes(4);
        int pixelType = etsFile.readInt();
        this.core[s].sizeC = etsFile.readInt();
        int colorspace = etsFile.readInt();
        this.compressionType[s] = etsFile.readInt();
        int compressionQuality = etsFile.readInt();
        this.tileX[s] = etsFile.readInt();
        this.tileY[s] = etsFile.readInt();
        int tileZ = etsFile.readInt();
        this.core[s].rgb = this.core[s].sizeC > 1;
        etsFile.seek(usedChunkOffset);
        this.tileOffsets[s] = new Long[nUsedChunks];
        ArrayList<TileCoordinate> tmpTiles = new ArrayList<TileCoordinate>();
        for (int chunk = 0; chunk < nUsedChunks; ++chunk) {
            etsFile.skipBytes(4);
            TileCoordinate t = new TileCoordinate(this.nDimensions[s]);
            for (int i = 0; i < this.nDimensions[s]; ++i) {
                t.coordinate[i] = etsFile.readInt();
            }
            this.tileOffsets[s][chunk] = etsFile.readLong();
            int nBytes = etsFile.readInt();
            etsFile.skipBytes(4);
            tmpTiles.add(t);
        }
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        int maxC = 0;
        int maxT = 0;
        for (TileCoordinate t : tmpTiles) {
            int cIndex;
            Integer tv = this.dimensionOrdering.get("T");
            Integer zv = this.dimensionOrdering.get("Z");
            Integer cv = this.dimensionOrdering.get("C");
            int tIndex = tv == null ? -1 : tv + 2;
            int zIndex = zv == null ? -1 : zv + 2;
            int n = cIndex = cv == null ? -1 : cv + 2;
            if (tv == null && zv == null) {
                if (t.coordinate.length > 4 && cv == null) {
                    cIndex = 2;
                    this.dimensionOrdering.put("C", cIndex - 2);
                }
                if (t.coordinate.length > 4) {
                    tIndex = cv == null ? 3 : cIndex + 2;
                    if (tIndex < t.coordinate.length) {
                        this.dimensionOrdering.put("T", tIndex - 2);
                    } else {
                        tIndex = -1;
                    }
                }
                if (t.coordinate.length > 5) {
                    zIndex = cv == null ? 4 : cIndex + 1;
                    if (zIndex < t.coordinate.length) {
                        this.dimensionOrdering.put("Z", zIndex - 2);
                    } else {
                        zIndex = -1;
                    }
                }
            }
            if (t.coordinate[0] > maxX) {
                maxX = t.coordinate[0];
            }
            if (t.coordinate[1] > maxY) {
                maxY = t.coordinate[1];
            }
            if (tIndex >= 0 && t.coordinate[tIndex] > maxT) {
                maxT = t.coordinate[tIndex];
            }
            if (zIndex >= 0 && t.coordinate[zIndex] > maxZ) {
                maxZ = t.coordinate[zIndex];
            }
            if (cIndex < 0 || t.coordinate[cIndex] <= maxC) continue;
            maxC = t.coordinate[cIndex];
        }
        this.core[s].sizeX = maxX > 1 ? this.tileX[s] * (maxX + 1) : this.tileX[s];
        this.core[s].sizeY = maxY > 1 ? this.tileY[s] * (maxY + 1) : this.tileY[s];
        this.core[s].sizeZ = maxZ + 1;
        if (maxC > 0) {
            this.core[s].sizeC *= maxC + 1;
        }
        this.core[s].sizeT = maxT + 1;
        if (this.core[s].sizeZ == 0) {
            this.core[s].sizeZ = 1;
        }
        this.core[s].imageCount = this.core[s].sizeZ * this.core[s].sizeT;
        if (maxC > 0) {
            this.core[s].imageCount *= maxC + 1;
        }
        this.rows[s] = maxY > 1 ? maxY + 1 : 1;
        this.cols[s] = maxX > 1 ? maxX + 1 : 1;
        for (int i = 0; i < tmpTiles.size(); ++i) {
            this.tileMap[s].put((TileCoordinate)tmpTiles.get(i), i);
        }
        this.core[s].pixelType = this.convertPixelType(pixelType);
        etsFile.close();
    }

    private int convertPixelType(int pixelType) throws FormatException {
        switch (pixelType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                throw new FormatException("Unsupported pixel type: long");
            }
            case 8: {
                throw new FormatException("Unsupported pixel type: unsigned long");
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 7;
            }
        }
        throw new FormatException("Unsupported pixel type: " + pixelType);
    }

    private void readTags(RandomAccessInputStream vsi) throws IOException {
        long fp = vsi.getFilePointer();
        if (fp + 24L >= vsi.length()) {
            return;
        }
        short headerSize = vsi.readShort();
        short version = vsi.readShort();
        int volumeVersion = vsi.readInt();
        long dataFieldOffset = vsi.readLong();
        int flags = vsi.readInt();
        vsi.skipBytes(4);
        int tagCount = flags & 0xFFFFFFF;
        if (fp + dataFieldOffset < 0L) {
            return;
        }
        vsi.seek(fp + dataFieldOffset);
        if (vsi.getFilePointer() >= vsi.length()) {
            return;
        }
        for (int i = 0; i < tagCount && vsi.getFilePointer() + 16L < vsi.length(); ++i) {
            int fieldType = vsi.readInt();
            int tag = vsi.readInt();
            long nextField = (long)vsi.readInt() & 0xFFFFFFFFL;
            int dataSize = vsi.readInt();
            boolean extraTag = (fieldType & 0x8000000) >> 27 == 1;
            boolean extendedField = (fieldType & 0x10000000) >> 28 == 1;
            boolean inlineData = (fieldType & 0x40000000) >> 30 == 1;
            boolean array = !inlineData && !extendedField && (fieldType & 0x20000000) >> 29 == 1;
            boolean newVolume = (fieldType & Integer.MIN_VALUE) >> 31 == 1;
            int realType = fieldType & 0xFFFFFF;
            int secondTag = -1;
            if (extraTag) {
                secondTag = vsi.readInt();
            }
            if (extendedField && realType == 0) {
                if (tag == 2007) {
                    this.dimensionTag = secondTag;
                    this.inDimensionProperties = true;
                }
                long endPointer = vsi.getFilePointer() + (long)dataSize;
                while (vsi.getFilePointer() < endPointer && vsi.getFilePointer() < vsi.length()) {
                    long start = vsi.getFilePointer();
                    this.readTags(vsi);
                    long end = vsi.getFilePointer();
                    if (start != end) continue;
                    break;
                }
                if (tag == 2007) {
                    this.inDimensionProperties = false;
                    this.foundChannelTag = false;
                }
            }
            if (this.inDimensionProperties) {
                if (tag == 2012 && !this.dimensionOrdering.containsValue(this.dimensionTag)) {
                    this.dimensionOrdering.put("Z", this.dimensionTag);
                } else if (!(tag != 2100 && tag != 2027 || this.dimensionOrdering.containsValue(this.dimensionTag))) {
                    this.dimensionOrdering.put("T", this.dimensionTag);
                } else if (tag == 2039 && !this.dimensionOrdering.containsValue(this.dimensionTag)) {
                    this.dimensionOrdering.put("L", this.dimensionTag);
                } else if (tag == 2008 && this.foundChannelTag && !this.dimensionOrdering.containsValue(this.dimensionTag)) {
                    this.dimensionOrdering.put("C", this.dimensionTag);
                } else if (tag == 2008) {
                    this.foundChannelTag = true;
                }
            }
            if (nextField == 0L) {
                return;
            }
            if (fp + nextField >= vsi.length() || fp + nextField < 0L) break;
            vsi.seek(fp + nextField);
        }
    }

    class TileCoordinate {
        public int[] coordinate;

        public TileCoordinate(int nDimensions) {
            this.coordinate = new int[nDimensions];
        }

        public boolean equals(Object o) {
            if (!(o instanceof TileCoordinate)) {
                return false;
            }
            TileCoordinate t = (TileCoordinate)o;
            if (this.coordinate.length != t.coordinate.length) {
                return false;
            }
            for (int i = 0; i < this.coordinate.length; ++i) {
                if (this.coordinate[i] == t.coordinate[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int[] lengths = new int[this.coordinate.length];
            lengths[0] = CellSensReader.this.rows[CellSensReader.this.getSeries()];
            lengths[1] = CellSensReader.this.cols[CellSensReader.this.getSeries()];
            for (String dim : CellSensReader.this.dimensionOrdering.keySet()) {
                int index = (Integer)CellSensReader.this.dimensionOrdering.get(dim) + 2;
                if (dim.equals("Z")) {
                    lengths[index] = CellSensReader.this.getSizeZ();
                    continue;
                }
                if (dim.equals("C")) {
                    lengths[index] = CellSensReader.this.getEffectiveSizeC();
                    continue;
                }
                if (!dim.equals("T")) continue;
                lengths[index] = CellSensReader.this.getSizeT();
            }
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] != 0) continue;
                lengths[i] = 1;
            }
            return FormatTools.positionToRaster(lengths, this.coordinate);
        }

        public String toString() {
            StringBuffer b = new StringBuffer("{");
            for (int p : this.coordinate) {
                b.append(p);
                b.append(", ");
            }
            b.append("}");
            return b.toString();
        }
    }
}

