/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.DataSetInfoFileNameDecorator;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.yeastx.etl.DataSetInformationYeastX;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformation;
import ch.systemsx.cisd.yeastx.etl.DatasetMappingResolver;
import ch.systemsx.cisd.yeastx.etl.DatasetMappingUtil;
import ch.systemsx.cisd.yeastx.etl.LogUtils;
import ch.systemsx.cisd.yeastx.etl.MLConversionType;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class BatchDataSetInfoExtractor
implements IDataSetInfoExtractor {
    private final Properties properties;
    private final DataSetInfoFileNameDecorator fileNameDecorator;

    public BatchDataSetInfoExtractor(Properties properties) {
        this.properties = properties;
        this.fileNameDecorator = new DataSetInfoFileNameDecorator(properties);
    }

    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        LogUtils log = new LogUtils(incomingDataSetPath.getParentFile());
        DataSetMappingInformation plainInfo = DatasetMappingUtil.tryGetDatasetMapping(incomingDataSetPath, log);
        if (plainInfo != null) {
            DataSetInformationYeastX info = new DataSetInformationYeastX();
            info.setComplete(true);
            info.setDataSetProperties(plainInfo.getProperties());
            this.setSampleOrExperiment(openbisService, log, plainInfo, info);
            info.setSpaceCode(plainInfo.getSpaceOrGroupCode());
            MLConversionType conversion = BatchDataSetInfoExtractor.getConversion(plainInfo.getConversion());
            info.setConversion(conversion);
            String parentDataSetCodes = plainInfo.getParentDataSetCodes();
            if (StringUtils.isNotBlank((String)parentDataSetCodes)) {
                String[] parentCodes = parentDataSetCodes.split(",");
                info.setParentDataSetCodes(Arrays.asList(parentCodes));
            }
            this.fileNameDecorator.enrich((DataSetInformation)info, incomingDataSetPath);
            return info;
        }
        throw new UserFailureException("No mapping found for the dataset file " + incomingDataSetPath.getPath());
    }

    private void setSampleOrExperiment(IEncapsulatedOpenBISService openbisService, LogUtils log, DataSetMappingInformation mapping, DataSetInformationYeastX info) {
        DatasetMappingResolver mappingResolver = new DatasetMappingResolver(this.properties, openbisService);
        String sampleCode = mappingResolver.tryFigureSampleCode(mapping, log);
        if (sampleCode != null) {
            info.setSampleCode(sampleCode);
        } else {
            ExperimentIdentifier experimentIdentifier = DatasetMappingResolver.tryFigureExperimentIdentifier(mapping);
            if (experimentIdentifier == null) {
                throw new UserFailureException("Both sample and experiment are not provided for the file " + mapping.getFileName());
            }
            info.setExperimentIdentifier(experimentIdentifier);
        }
    }

    private static MLConversionType getConversion(String conversion) {
        MLConversionType conversionType = MLConversionType.tryCreate(conversion);
        if (conversionType == null) {
            throw new UserFailureException("Unknown value in conversion column " + conversion);
        }
        return conversionType;
    }
}

