/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collection;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.IMultiKeyExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TableMapNonUniqueKey<K, E>
implements Iterable<E> {
    private final Map<K, Set<E>> map = new LinkedHashMap<K, Set<E>>();
    private final IMultiKeyExtractor<K, E> extractor;
    private final UniqueValueViolationStrategy uniqueValueViolationStrategy;

    public TableMapNonUniqueKey(Iterable<E> rows, IKeyExtractor<K, E> extractor) {
        this(rows, extractor, UniqueValueViolationStrategy.ERROR);
    }

    public TableMapNonUniqueKey(Iterable<E> rows, IMultiKeyExtractor<K, E> extractor) {
        this(rows, extractor, UniqueValueViolationStrategy.ERROR);
    }

    public TableMapNonUniqueKey(Iterable<E> rows, final IKeyExtractor<K, E> extractor, UniqueValueViolationStrategy uniqueValueViolationStrategy) {
        assert (rows != null) : "Unspecified collection of rows.";
        assert (extractor != null) : "Unspecified key extractor.";
        assert (uniqueValueViolationStrategy != null) : "Unspecified unique value violation strategy.";
        this.extractor = new IMultiKeyExtractor<K, E>(){

            @Override
            public Collection<K> getKey(E e) {
                return Collections.singleton(extractor.getKey(e));
            }
        };
        this.uniqueValueViolationStrategy = uniqueValueViolationStrategy;
        for (E row : rows) {
            this.add(row);
        }
    }

    public TableMapNonUniqueKey(Iterable<E> rows, IMultiKeyExtractor<K, E> extractor, UniqueValueViolationStrategy uniqueValueViolationStrategy) {
        assert (rows != null) : "Unspecified collection of rows.";
        assert (extractor != null) : "Unspecified key extractor.";
        assert (uniqueValueViolationStrategy != null) : "Unspecified unique value violation strategy.";
        this.extractor = extractor;
        this.uniqueValueViolationStrategy = uniqueValueViolationStrategy;
        for (E row : rows) {
            this.add(row);
        }
    }

    public final void add(E row) throws UniqueValueViolationException {
        Collection<K> keys = this.extractor.getKey(row);
        for (K key : keys) {
            Set<E> set = this.map.get(key);
            if (set == null) {
                set = new LinkedHashSet();
                this.map.put(key, set);
                set.add(row);
                continue;
            }
            if (this.uniqueValueViolationStrategy == UniqueValueViolationStrategy.KEEP_FIRST || !set.contains(row)) {
                set.add(row);
                continue;
            }
            if (this.uniqueValueViolationStrategy == UniqueValueViolationStrategy.KEEP_LAST) {
                set.remove(row);
                set.add(row);
                continue;
            }
            if (this.uniqueValueViolationStrategy != UniqueValueViolationStrategy.ERROR) continue;
            throw new UniqueValueViolationException("Row '" + row.toString() + "' already stored in the map.");
        }
    }

    public final Set<E> tryGet(K key) {
        return this.map.get(key);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<Map.Entry<K, Set<E>>> mapSetIterator;
            private Iterator<E> setIterator;
            {
                this.mapSetIterator = TableMapNonUniqueKey.this.map.entrySet().iterator();
            }

            private boolean setHasNext() {
                return this.setIterator != null && this.setIterator.hasNext();
            }

            @Override
            public boolean hasNext() {
                if (!this.setHasNext() && this.mapSetIterator.hasNext()) {
                    this.setIterator = this.mapSetIterator.next().getValue().iterator();
                }
                return this.setHasNext();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                return this.setIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove an element.");
            }
        };
    }

    public static class UniqueValueViolationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        UniqueValueViolationException(String msg) {
            super(msg);
        }
    }

    public static enum UniqueValueViolationStrategy {
        KEEP_FIRST,
        KEEP_LAST,
        ERROR;

    }
}

