/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.spring;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileAdapter
implements IUncheckedMultipartFile {
    private final MultipartFile multipartFile;

    public MultipartFileAdapter(MultipartFile multipartFile) {
        assert (multipartFile != null) : "Unspecified multipart file.";
        this.multipartFile = multipartFile;
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.multipartFile.getBytes();
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    @Override
    public String getContentType() {
        return this.multipartFile.getContentType();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return this.multipartFile.getInputStream();
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    @Override
    public String getName() {
        return this.multipartFile.getName();
    }

    @Override
    public String getOriginalFilename() {
        return this.multipartFile.getOriginalFilename();
    }

    @Override
    public long getSize() {
        return this.multipartFile.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.multipartFile.isEmpty();
    }

    @Override
    public void transferTo(File dest) {
        try {
            this.multipartFile.transferTo(dest);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }
}

