/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.Identifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.UploadClientSortingUtils;
import ch.systemsx.cisd.openbis.dss.client.api.gui.tree.FilterableMutableTreeNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeEntityPickerDialog
extends AbstractEntityPickerDialog
implements TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    protected final JTree tree;
    protected final JOptionPane optionPane;
    private final JTextField filterField;
    private final NewDataSetDTO.DataSetOwnerType entityKind;

    public AbstractTreeEntityPickerDialog(JFrame mainWindow, String title, NewDataSetDTO.DataSetOwnerType entityKind, DataSetUploadClientModel clientModel) {
        super(mainWindow, title, clientModel);
        this.entityKind = entityKind;
        this.tree = new JTree();
        this.tree.setModel(new DefaultTreeModel(null));
        this.tree.addTreeWillExpandListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener();
        this.filterField = this.createFilterField();
        JPanel northPanel = AbstractTreeEntityPickerDialog.createFilterAndRefreshButtonPanel(this.filterField, this.refreshButton);
        this.optionPane = this.createOptionPane(northPanel, this);
        this.setContentPane(this.optionPane);
    }

    private JOptionPane createOptionPane(JPanel northPanel, final JDialog parent) {
        JScrollPane scrollPane = new JScrollPane(this.tree);
        Object[] objects = new Object[]{"Filter experiments: ", northPanel, "Select " + this.entityKind.toString().toLowerCase() + ":", scrollPane};
        JOptionPane theOptionPane = new JOptionPane(objects, -1, 2);
        theOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals("value") || evt.getNewValue() == null) {
                    return;
                }
                if (this.isCancelClicked(evt)) {
                    parent.setVisible(false);
                    return;
                }
                if (this.isOkClicked(evt)) {
                    AbstractTreeEntityPickerDialog.this.acceptCurrentSelectionOrNotify();
                }
            }

            private boolean isOkClicked(PropertyChangeEvent evt) {
                return (Integer)evt.getNewValue() == 0;
            }

            private boolean isCancelClicked(PropertyChangeEvent evt) {
                return !this.isOkClicked(evt);
            }
        });
        return theOptionPane;
    }

    private void acceptCurrentSelectionOrNotify() {
        String selected = this.tryGetSelected();
        if (selected != null) {
            this.setVisible(false);
            return;
        }
        String label = this.entityKind.toString();
        JOptionPane.showMessageDialog(this, String.valueOf(label) + " needs to be selected!", "No " + label.toLowerCase() + " selected!", 2);
        this.optionPane.setValue(this.optionPane.getInitialValue());
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (node.getParent() == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof Identifier) {
            this.expandNode(node, (Identifier)userObject);
        }
    }

    protected abstract void expandNode(DefaultMutableTreeNode var1, Identifier var2);

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (node.isRoot()) {
            throw new ExpandVetoException(event);
        }
        node.removeAllChildren();
        node.add(new DefaultMutableTreeNode("Loading data ..."));
    }

    protected void createNodes(FilterableMutableTreeNode top, List<Experiment> experiments) {
        UploadClientSortingUtils.sortExperimentsByIdentifier(experiments);
        for (Experiment experiment : experiments) {
            DefaultMutableTreeNode category = new DefaultMutableTreeNode(Identifier.create(experiment), true);
            category.add(new DefaultMutableTreeNode("Loading data ..."));
            top.add(category);
        }
    }

    @Override
    protected void setDialogData() {
        FilterableMutableTreeNode top = new FilterableMutableTreeNode("Experiments");
        List<String> projectIdentifiers = this.clientModel.getProjectIdentifiers();
        List<Experiment> experiments = this.clientModel.getOpenBISService().listExperimentsHavingSamplesForProjects(projectIdentifiers);
        this.createNodes(top, experiments);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.setRoot(top);
        this.updateTreeSelection();
    }

    protected void updateTreeSelection() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        FilterableMutableTreeNode rootNode = (FilterableMutableTreeNode)treeModel.getRoot();
        if (rootNode != null) {
            rootNode.filter(this.filterField.getText());
        }
        treeModel.reload();
    }

    public String pickEntity() {
        this.pack();
        int height = this.getHeight() > 500 ? 500 : this.getHeight();
        int width = this.getWidth() > 600 ? 600 : this.getWidth();
        this.setSize(width, height);
        Point mwLocation = this.mainWindow.getLocationOnScreen();
        int x = mwLocation.x + this.mainWindow.getWidth() / 2 - this.getWidth() / 2;
        int y = mwLocation.y + this.mainWindow.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        this.setVisible(true);
        Object value = this.optionPane.getValue();
        Object initialValue = this.optionPane.getInitialValue();
        this.optionPane.setValue(initialValue);
        if (value == null || (Integer)value == 2) {
            return null;
        }
        return this.tryGetSelected();
    }

    private String tryGetSelected() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object lastPathComponent = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        if (!(lastPathComponent instanceof Identifier)) {
            return null;
        }
        Identifier identifier = (Identifier)lastPathComponent;
        return identifier.getOwnerType() == this.entityKind ? identifier.toString() : null;
    }

    private JTextField createFilterField() {
        JTextField textField = new JTextField();
        textField.setEditable(true);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractTreeEntityPickerDialog.this.updateTreeSelection();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractTreeEntityPickerDialog.this.updateTreeSelection();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractTreeEntityPickerDialog.this.updateTreeSelection();
            }
        });
        return textField;
    }

    private void addTreeSelectionListener() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    AbstractTreeEntityPickerDialog.this.optionPane.setValue(0);
                }
            }
        });
    }
}

