/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.ViewMode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailViewConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WebClientConfigurationProvider {
    private static final String CONFIGURATION_FILE_NOT_PROVIDED = "${web-client-configuration-file}";
    private static final String HIDE_SECTIONS = "hide-sections";
    private static final String TYPES = "types";
    private static final String VIEW = "view";
    private static final String DETAIL_VIEWS = "detail-views";
    private static final String HIDE_SMART_VIEW = "hide-smart-view";
    private static final String HIDE_FILE_VIEW = "hide-file-view";
    private static final String DEFAULT_VIEW_MODE = "default-view-mode";
    private static final ViewMode DEFAULT_VIEW_MODE_VALUE = ViewMode.NORMAL;
    private static final String DEFAULT_ANONYMOUS_LOGIN = "default-anonymous-login";
    private static final String MAX_VISIBLE_COLUMNS = "max-visible-columns";
    private static final int DEFAULT_MAX_VISIBLE_COLUMNS = 50;
    private static final String MAX_ENTITY_VISITS = "max-entity-visits";
    private static final int DEFAULT_MAX_ENTITY_VISITS = 20;
    private static final String DATA_SET_TYPES_WITH_IMAGE_OVERVIEW = "data-set-types-with-image-overview";
    private static final String ALLOW_ADDING_UNOFFICIAL_TERMS = "allow-adding-unofficial-terms";
    private static final boolean DEFAULT_ALLOW_ADDING_UNOFFICIAL_TERMS = false;
    private static final String ENABLE_TRASH = "enable-trash";
    private static final boolean DEFAULT_ENABLE_TRASH = false;
    private static final String CREATABLE_DATA_SET_TYPES_WHITELIST = "creatable-data-set-types-whitelist";
    private static final String CREATABLE_DATA_SET_TYPES_BLACKLIST = "creatable-data-set-types-blacklist";
    public static final String TECHNOLOGIES = "technologies";
    private WebClientConfiguration webClientConfiguration = new WebClientConfiguration();

    public WebClientConfigurationProvider(String configurationFile) {
        if (configurationFile.equals(CONFIGURATION_FILE_NOT_PROVIDED)) {
            this.initDefaultValues();
            return;
        }
        Properties properties = PropertyIOUtils.loadProperties(configurationFile);
        this.init(properties);
    }

    public WebClientConfigurationProvider(Properties properties) {
        this.init(properties);
    }

    private void initDefaultValues() {
        this.webClientConfiguration.setDefaultViewMode(DEFAULT_VIEW_MODE_VALUE);
        this.webClientConfiguration.setMaxVisibleColumns(50);
        this.webClientConfiguration.setMaxEntityVisits(20);
        this.webClientConfiguration.setAllowAddingUnofficialTerms(false);
        this.webClientConfiguration.setEnableTrash(false);
    }

    private void init(Properties properties) {
        PropertyParametersUtil.SectionProperties[] props;
        this.webClientConfiguration.setDefaultViewMode(this.extractDefaultViewMode(properties));
        this.webClientConfiguration.setDefaultAnonymousLogin(this.extractDefaultAnonymousLogin(properties));
        this.webClientConfiguration.setMaxVisibleColumns(this.extractMaxVisibleColumns(properties));
        this.webClientConfiguration.setAllowAddingUnofficialTerms(this.extractAllowAddingUnofficialTerms(properties));
        this.webClientConfiguration.setMaxEntityVisits(PropertyUtils.getInt(properties, MAX_ENTITY_VISITS, 20));
        this.webClientConfiguration.setDataSetTypesWithImageOverview(this.extractDataSetTypesWithImageOverview(properties));
        this.webClientConfiguration.setViews(this.extractHiddenSections(properties));
        this.webClientConfiguration.setEnableTrash(this.extractEnableTrash(properties));
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = props = PropertyParametersUtil.extractSectionProperties(properties, TECHNOLOGIES, false);
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            Properties technologyProperties = sectionProperties.getProperties();
            Set<Map.Entry<Object, Object>> entrySet = technologyProperties.entrySet();
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : entrySet) {
                map.put(entry.getKey().toString(), entry.getValue().toString());
            }
            this.webClientConfiguration.addPropertiesForTechnology(sectionProperties.getKey(), map);
            ++n2;
        }
        this.webClientConfiguration.setCreatableDataSetTypePatternsWhitelist(this.extractCreatableDataSetTypes(properties, CREATABLE_DATA_SET_TYPES_WHITELIST));
        this.webClientConfiguration.setCreatableDataSetTypePatternsBlacklist(this.extractCreatableDataSetTypes(properties, CREATABLE_DATA_SET_TYPES_BLACKLIST));
    }

    private Map<String, DetailViewConfiguration> extractHiddenSections(Properties properties) {
        HashMap<String, DetailViewConfiguration> viewConfigurations = new HashMap<String, DetailViewConfiguration>();
        PropertyParametersUtil.SectionProperties[] viewsProperties = this.extractViewsProperties(properties);
        int i = 0;
        while (i < viewsProperties.length) {
            Properties viewProperties = viewsProperties[i].getProperties();
            String viewId = this.extractViewId(viewProperties);
            List<String> types = this.extractEntityTypes(viewProperties);
            List<String> hideSectionsIdsOrNull = this.tryExtractHiddenSections(viewProperties);
            boolean hideSmartView = PropertyUtils.getBoolean(viewProperties, HIDE_SMART_VIEW, false);
            boolean hideFileView = PropertyUtils.getBoolean(viewProperties, HIDE_FILE_VIEW, false);
            for (String type : types) {
                DetailViewConfiguration viewConfiguration = new DetailViewConfiguration();
                if (hideSectionsIdsOrNull != null) {
                    viewConfiguration.setDisabledTabs(new HashSet<String>(hideSectionsIdsOrNull));
                }
                viewConfiguration.setHideSmartView(hideSmartView);
                viewConfiguration.setHideFileView(hideFileView);
                viewConfigurations.put(String.valueOf(viewId) + type, viewConfiguration);
            }
            ++i;
        }
        return viewConfigurations;
    }

    private PropertyParametersUtil.SectionProperties[] extractViewsProperties(Properties properties) {
        return PropertyParametersUtil.extractSectionProperties(properties, DETAIL_VIEWS, false);
    }

    private List<String> tryExtractHiddenSections(Properties viewProperties) {
        return PropertyUtils.tryGetList(viewProperties, HIDE_SECTIONS);
    }

    private List<String> extractEntityTypes(Properties viewProperties) {
        return PropertyUtils.getMandatoryList(viewProperties, TYPES);
    }

    private Set<String> extractDataSetTypesWithImageOverview(Properties properties) {
        List<String> list = PropertyUtils.tryGetList(properties, DATA_SET_TYPES_WITH_IMAGE_OVERVIEW);
        HashSet<String> result = new HashSet<String>();
        if (list != null) {
            result.addAll(list);
        }
        return result;
    }

    private String extractViewId(Properties viewProperties) {
        return PropertyUtils.getMandatoryProperty(viewProperties, VIEW);
    }

    private ViewMode extractDefaultViewMode(Properties properties) {
        String viewMode = PropertyUtils.getProperty(properties, DEFAULT_VIEW_MODE, DEFAULT_VIEW_MODE_VALUE.name());
        try {
            return ViewMode.valueOf(viewMode.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ViewMode.NORMAL;
        }
    }

    private boolean extractDefaultAnonymousLogin(Properties properties) {
        return PropertyUtils.getBoolean(properties, DEFAULT_ANONYMOUS_LOGIN, false);
    }

    private int extractMaxVisibleColumns(Properties properties) {
        return PropertyUtils.getInt(properties, MAX_VISIBLE_COLUMNS, 50);
    }

    private boolean extractAllowAddingUnofficialTerms(Properties properties) {
        return PropertyUtils.getBoolean(properties, ALLOW_ADDING_UNOFFICIAL_TERMS, false);
    }

    private boolean extractEnableTrash(Properties properties) {
        return PropertyUtils.getBoolean(properties, ENABLE_TRASH, false);
    }

    private List<String> extractCreatableDataSetTypes(Properties properties, String key) {
        List<String> list = PropertyUtils.tryGetList(properties, key);
        if (list == null) {
            list = new ArrayList<String>();
        }
        return list;
    }

    public WebClientConfiguration getWebClientConfiguration() {
        return this.webClientConfiguration;
    }
}

