/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.util.Debug;

public class UserCondition
extends Condition {
    private static final long serialVersionUID = -2076347348048202718L;
    private String requiredUsername;

    public UserCondition(String requiredUsername) {
        this.requiredUsername = requiredUsername;
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        if (this.requiredUsername == null) {
            Debug.log("Expected user name not set in user condition. Condition will return false.");
        } else {
            String actualUsername = System.getProperty("user.name");
            if (actualUsername != null && !actualUsername.isEmpty()) {
                result = this.requiredUsername.equals(actualUsername);
            } else {
                Debug.log("Non-existing or empty system property user.name. Condition will return false.");
            }
        }
        return result;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        IXMLElement userElement = xmlcondition.getFirstChildNamed("requiredusername");
        if (userElement == null) {
            throw new Exception("Missing \"requiredusername\" element in condition \"" + this.getId() + "\"");
        }
        this.requiredUsername = userElement.getContent();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl requiredUserEl = new XMLElementImpl("requiredusername", conditionRoot);
        requiredUserEl.setContent(this.requiredUsername);
        conditionRoot.addChild(requiredUserEl);
    }
}

