/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import com.izforge.izpack.util.file.types.selectors.SelectorUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class ContainsSelector
extends BaseExtendSelector {
    private String contains = null;
    private boolean casesensitive = true;
    private boolean ignorewhitespace = false;
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";

    public String toString() {
        StringBuffer buf = new StringBuffer("{containsselector text: ");
        buf.append(this.contains);
        buf.append(" casesensitive: ");
        if (this.casesensitive) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append(" ignorewhitespace: ");
        if (this.ignorewhitespace) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append("}");
        return buf.toString();
    }

    public void setText(String contains) {
        this.contains = contains;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setIgnorewhitespace(boolean ignorewhitespace) {
        this.ignorewhitespace = ignorewhitespace;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                String paramname = parameter.getName();
                if (CONTAINS_KEY.equalsIgnoreCase(paramname)) {
                    this.setText(parameter.getValue());
                } else if (CASE_KEY.equalsIgnoreCase(paramname)) {
                    this.setCasesensitive(Boolean.parseBoolean(parameter.getValue()));
                } else if (WHITESPACE_KEY.equalsIgnoreCase(paramname)) {
                    this.setIgnorewhitespace(Boolean.parseBoolean(parameter.getValue()));
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++n2;
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    @Override
    public boolean isSelected(AutomatedInstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        if (file.isDirectory()) {
            return true;
        }
        String userstr = this.contains;
        if (!this.casesensitive) {
            userstr = this.contains.toLowerCase();
        }
        if (this.ignorewhitespace) {
            userstr = SelectorUtils.removeWhitespace(userstr);
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String teststr = in.readLine();
        }
        catch (IOException ioe) {
            throw new Exception("Could not read file " + filename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    throw new Exception("Could not close file " + filename);
                }
            }
        }
    }
}

