/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.api.IRpcServiceFactory;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceDTO;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceVersionDTO;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.common.io.ConcatenatedContentInputStream;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.FileInfoDssDownloader;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.AbstractDssComponentState;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.DataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.DataStoreApiUrlUtilities;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptRunner;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.python.core.Py;
import org.python.core.PyException;
import org.springframework.remoting.RemoteAccessException;
import sun.net.www.protocol.https.Handler;

class AuthenticatedState
extends AbstractDssComponentState {
    private final String sessionToken;
    private final IRpcServiceFactory dssServiceFactory;
    private final HashMap<String, ValidationScriptRunner> validationScriptRunnerCache = new HashMap();

    AuthenticatedState(IGeneralInformationService generalOpenBisService, IRpcServiceFactory dssServiceFactory, String sessionToken) {
        super(generalOpenBisService);
        this.dssServiceFactory = dssServiceFactory;
        this.sessionToken = sessionToken;
    }

    @Override
    void login(String user, String password) throws AuthorizationFailureException {
        throw new IllegalStateException("Already logged in.");
    }

    @Override
    public void checkSession() {
        if (!this.service.isSessionActive(this.getSessionToken())) {
            throw new InvalidSessionException("Session has expired");
        }
    }

    @Override
    public void logout() {
        this.service.logout(this.getSessionToken());
    }

    @Override
    public IDataSetDss getDataSet(String dataSetCode) throws IllegalArgumentException, EnvironmentFailureException, RemoteAccessException {
        String dataStoreBaseURL = this.service.tryGetDataStoreBaseURL(this.getSessionToken(), dataSetCode);
        if (dataStoreBaseURL == null) {
            throw new IllegalArgumentException("Could not retrieve data set with code " + dataSetCode);
        }
        String url = this.getDataStoreUrlFromDataStore(dataStoreBaseURL);
        IDssServiceRpcGeneric dssService = this.getDssServiceForUrl(url);
        return new DataSetDss(dataSetCode, dssService, this);
    }

    @Override
    public IDataSetDss putDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        ConcatenatedContentInputStream fileInputStream = new ConcatenatedContentInputStream(true, this.getContentForFileInfos(dataSetFile.getPath(), newDataset.getFileInfos()));
        String code = dssService.putDataSet(this.sessionToken, newDataset, (InputStream)fileInputStream);
        return new DataSetDss(code, dssService, this);
    }

    @Override
    public void putFileToSessionWorkspace(String filePath, InputStream inputStream) throws IOExceptionUnchecked {
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        dssService.putFileToSessionWorkspace(this.sessionToken, filePath, inputStream);
    }

    @Override
    public void putFileToSessionWorkspace(String directory, File file) throws IOExceptionUnchecked {
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        String filePath = String.valueOf(directory) + "/" + file.getName();
        FileInputStream istream = null;
        try {
            try {
                istream = new FileInputStream(file);
                dssService.putFileToSessionWorkspace(this.sessionToken, filePath, istream);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(istream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)istream);
    }

    @Override
    public InputStream getFileFromSessionWorkspace(String filePath) throws IOExceptionUnchecked {
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        return dssService.getFileFromSessionWorkspace(this.sessionToken, filePath);
    }

    @Override
    public void getFileFromSessionWorkspace(String filePath, File localFile) throws IOExceptionUnchecked {
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        InputStream istream = dssService.getFileFromSessionWorkspace(this.sessionToken, filePath);
        FileOutputStream ostream = null;
        try {
            try {
                ostream = new FileOutputStream(localFile);
                IOUtils.copyLarge((InputStream)istream, (OutputStream)ostream);
                ((OutputStream)ostream).close();
            }
            catch (IOException ex) {
                localFile.delete();
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)istream);
            IOUtils.closeQuietly((OutputStream)ostream);
        }
    }

    @Override
    public boolean deleteSessionWorkspaceFile(String path) {
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        return dssService.deleteSessionWorkspaceFile(this.sessionToken, path);
    }

    private IDssServiceRpcGeneric getServiceForPutDataStore() {
        String url = this.service.getDefaultPutDataStoreBaseURL(this.sessionToken);
        url = DataStoreApiUrlUtilities.getDataStoreUrlFromDownloadUrl(url);
        IDssServiceRpcGeneric dssService = this.getDssServiceForUrl(url);
        return dssService;
    }

    private List<IHierarchicalContentNode> getContentForFileInfos(String filePath, List<FileInfoDssDTO> fileInfos) {
        ArrayList<IHierarchicalContentNode> files = new ArrayList<IHierarchicalContentNode>();
        File parent = new File(filePath);
        if (!parent.isDirectory()) {
            return Collections.singletonList(new FileBasedContentNode(parent));
        }
        for (FileInfoDssDTO fileInfo : fileInfos) {
            File file = new File(parent, fileInfo.getPathInDataSet());
            if (!file.exists()) {
                throw new IllegalArgumentException("File does not exist " + file);
            }
            if (file.isDirectory()) continue;
            files.add((IHierarchicalContentNode)new FileBasedContentNode(file));
        }
        return files;
    }

    FileInfoDssDTO[] listFiles(DataSetDss dataSetDss, String startPath, boolean isRecursive) throws InvalidSessionException {
        return dataSetDss.getService().listFilesForDataSet(this.getSessionToken(), dataSetDss.getCode(), startPath, isRecursive);
    }

    InputStream getFile(DataSetDss dataSet, String path) throws InvalidSessionException {
        String url = dataSet.getService().getDownloadUrlForFileForDataSet(this.getSessionToken(), dataSet.getCode(), path);
        try {
            if (url.toLowerCase().startsWith("https")) {
                return new URL(null, url, new Handler()).openConnection().getInputStream();
            }
            return new URL(url).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationFailureException("Malformed URL: " + url);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    String getSessionURLForFile(DataSetDss dataSet, String path) throws InvalidSessionException {
        String baseDownloadUrl = this.service.tryGetDataStoreBaseURL(this.getSessionToken(), dataSet.getCode());
        StringBuilder sb = new StringBuilder();
        sb.append(DataStoreApiUrlUtilities.getDownloadUrlFromDataStoreUrl(baseDownloadUrl));
        sb.append("/");
        sb.append(dataSet.getCode());
        sb.append("/");
        sb.append(path);
        sb.append("?sessionID=");
        sb.append(this.getSessionToken());
        return sb.toString();
    }

    String getURLForFileWithTimeout(DataSetDss dataSet, String path, long validityInSeconds) throws InvalidSessionException {
        String url = dataSet.getService().getDownloadUrlForFileForDataSetWithTimeout(this.getSessionToken(), dataSet.getCode(), path, validityInSeconds);
        return url;
    }

    File tryLinkToContents(DataSetDss dataSetDss, String overrideStoreRootPathOrNull) throws InvalidSessionException, EnvironmentFailureException {
        String path = this.tryGetInternalPathInDataStore(dataSetDss, overrideStoreRootPathOrNull);
        if (path == null) {
            return null;
        }
        File contents = new File(path);
        if (contents.exists()) {
            return contents;
        }
        return null;
    }

    String tryGetInternalPathInDataStore(DataSetDss dataSetDss, String overrideStoreRootPathOrNull) throws InvalidSessionException, EnvironmentFailureException {
        int minorVersion = dataSetDss.getService().getMinorVersion();
        if (minorVersion < 1) {
            throw new EnvironmentFailureException("Server does not support this feature.");
        }
        try {
            if (minorVersion < 8) {
                return dataSetDss.getService().getPathToDataSet(this.getSessionToken(), dataSetDss.getCode(), overrideStoreRootPathOrNull);
            }
            return dataSetDss.getService().tryGetPathToDataSet(this.getSessionToken(), dataSetDss.getCode(), overrideStoreRootPathOrNull);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    File getLinkOrCopyOfContents(DataSetDss dataSetDss, String overrideStoreRootPathOrNull, File downloadDir, String pathInDataSetOrNull) throws InvalidSessionException {
        File result;
        if (pathInDataSetOrNull == null) {
            return this.getLinkOrCopyOfContents(dataSetDss, overrideStoreRootPathOrNull, downloadDir);
        }
        File link = this.tryLinkToContents(dataSetDss, overrideStoreRootPathOrNull);
        if (link != null) {
            File file = new File(link, pathInDataSetOrNull);
            if (!file.exists()) {
                throw new IllegalArgumentException("Data set " + dataSetDss.getCode() + " has no file/folder with path '" + pathInDataSetOrNull + "'.");
            }
            return file;
        }
        FileInfoDssDTO[] fileInfos = dataSetDss.getService().listFilesForDataSet(this.getSessionToken(), dataSetDss.getCode(), pathInDataSetOrNull, true);
        File outputDir = result = new File(new File(downloadDir, dataSetDss.getCode()), pathInDataSetOrNull);
        if (fileInfos.length == 1 && !fileInfos[0].isDirectory()) {
            outputDir = result.getParentFile();
        }
        outputDir.mkdirs();
        FileInfoDssDownloader downloader = new FileInfoDssDownloader(dataSetDss, fileInfos, outputDir);
        downloader.downloadFiles();
        return result;
    }

    private File getLinkOrCopyOfContents(DataSetDss dataSetDss, String overrideStoreRootPathOrNull, File downloadDir) throws InvalidSessionException {
        File link = this.tryLinkToContents(dataSetDss, overrideStoreRootPathOrNull);
        if (link != null) {
            return link;
        }
        File outputDir = new File(downloadDir, dataSetDss.getCode());
        outputDir.mkdirs();
        FileInfoDssDTO[] fileInfos = dataSetDss.getService().listFilesForDataSet(this.getSessionToken(), dataSetDss.getCode(), "/", true);
        FileInfoDssDownloader downloader = new FileInfoDssDownloader(dataSetDss, fileInfos, outputDir);
        downloader.downloadFiles();
        return outputDir;
    }

    private IDssServiceRpcGeneric getDssServiceForUrl(String url) {
        String serverURL = url;
        try {
            IDssServiceRpcGeneric dssService = this.basicGetDssServiceForUrl(serverURL);
            return dssService;
        }
        catch (RemoteAccessException e) {
            if (serverURL.startsWith("https://")) {
                serverURL = "http://" + serverURL.substring(8);
                IDssServiceRpcGeneric dssService = this.basicGetDssServiceForUrl(serverURL);
                return dssService;
            }
            throw e;
        }
    }

    private IDssServiceRpcGeneric basicGetDssServiceForUrl(String serverURL) {
        IDssServiceRpcGeneric dssService = null;
        Collection<RpcServiceInterfaceDTO> ifaces = this.dssServiceFactory.getSupportedInterfaces(serverURL, false);
        for (RpcServiceInterfaceDTO iface : ifaces) {
            if (!"DSS Service".equals(iface.getInterfaceName())) continue;
            for (RpcServiceInterfaceVersionDTO ifaceVersion : iface.getVersions()) {
                if (1 != ifaceVersion.getMajorVersion()) continue;
                dssService = this.dssServiceFactory.getService(ifaceVersion, IDssServiceRpcGeneric.class, serverURL, false);
                return dssService;
            }
        }
        throw new IllegalArgumentException("Server does not support the DSS Service interface.");
    }

    private String getDataStoreUrlFromDataStore(String dataStoreDownloadUrl) {
        return DataStoreApiUrlUtilities.getDataStoreUrlFromDownloadUrl(dataStoreDownloadUrl);
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public List<ValidationError> validateDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        ValidationScriptRunner runner = null;
        try {
            runner = this.getValidationScriptRunner(newDataset.tryDataSetType());
        }
        catch (Throwable ex) {
            return this.createValidationError("Script error", ex);
        }
        try {
            return runner.validate(dataSetFile);
        }
        catch (Throwable ex) {
            System.err.println("Could not run validation script: ");
            System.err.println(runner.getScriptString());
            ex.printStackTrace(System.err);
            return this.createValidationError("Script execution error", ex);
        }
    }

    @Override
    public Map<String, String> extractMetadata(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        ValidationScriptRunner runner = null;
        try {
            runner = this.getValidationScriptRunner(newDataset.tryDataSetType());
        }
        catch (Throwable throwable) {
            return Collections.emptyMap();
        }
        try {
            return runner.extractMetadata(dataSetFile);
        }
        catch (Throwable t) {
            System.err.println("Could not run metadata extraction script: ");
            System.err.println(runner.getScriptString());
            t.printStackTrace(System.err);
            return Collections.emptyMap();
        }
    }

    private ValidationScriptRunner getValidationScriptRunner(String dataSetTypeOrNull) throws PyException, Throwable {
        ValidationScriptRunner runner;
        IDssServiceRpcGeneric dssService = this.getServiceForPutDataStore();
        if (dssService.getMinorVersion() < 2) {
            return new ValidationScriptRunner.NullValidationScriptRunner();
        }
        if (this.validationScriptRunnerCache.containsKey(dataSetTypeOrNull)) {
            runner = this.validationScriptRunnerCache.get(dataSetTypeOrNull);
        } else {
            String validationScript = dssService.getValidationScript(this.sessionToken, dataSetTypeOrNull);
            try {
                runner = ValidationScriptRunner.createValidatorFromScriptString(validationScript, false);
                this.validationScriptRunnerCache.put(dataSetTypeOrNull, runner);
            }
            catch (Throwable ex) {
                System.err.println("Could not create validation script ");
                System.err.println(validationScript);
                System.err.println(ex);
                ex.printStackTrace(System.err);
                System.err.println(Py.getSystemState().modules);
                throw ex;
            }
        }
        return runner;
    }

    private List<ValidationError> createValidationError(String messagePrefix, Throwable throwable) {
        return Arrays.asList(ValidationError.createFileValidationError(String.valueOf(messagePrefix) + ": " + throwable));
    }
}

