/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.multiplexer;

import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ITerminableFuture;
import ch.systemsx.cisd.common.concurrent.TerminableCallable;
import ch.systemsx.cisd.common.multiplexer.Batch;
import ch.systemsx.cisd.common.multiplexer.BatchResults;
import ch.systemsx.cisd.common.multiplexer.BatchesResults;
import ch.systemsx.cisd.common.multiplexer.IBatch;
import ch.systemsx.cisd.common.multiplexer.IBatchHandler;
import ch.systemsx.cisd.common.multiplexer.IBatchIdProvider;
import ch.systemsx.cisd.common.multiplexer.IMultiplexer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ThreadPoolMultiplexer
implements IMultiplexer {
    private final NamingThreadPoolExecutor executor;

    public ThreadPoolMultiplexer(String threadPoolName) {
        this.executor = new NamingThreadPoolExecutor(threadPoolName).daemonize();
    }

    @Override
    public <O, I, R> BatchesResults<I, R> process(List<? extends O> objects, IBatchIdProvider<O, I> batchIdProvider, IBatchHandler<O, I, R> batchHandler) {
        List<IBatch<O, I>> batches = ThreadPoolMultiplexer.createBatches(objects, batchIdProvider);
        this.validateBatches(batches, batchHandler);
        Map<IBatch<O, I>, ITerminableFuture<List<R>>> futures = this.submitBatches(batches, batchHandler);
        return this.gatherResults(futures);
    }

    public static <O, I, R> List<IBatch<O, I>> createBatches(List<? extends O> objects, IBatchIdProvider<O, I> batchIdProvider) {
        Map<I, List<O>> batchIdToObjectsMap = ThreadPoolMultiplexer.createBatchIdToObjectsMap(objects, batchIdProvider);
        ArrayList<IBatch<O, I>> batches = new ArrayList<IBatch<O, I>>();
        for (Map.Entry<I, List<O>> batchIdToObjectsMapEntry : batchIdToObjectsMap.entrySet()) {
            Batch<? extends O, I> batch = new Batch<O, I>(batchIdToObjectsMapEntry.getValue(), batchIdToObjectsMapEntry.getKey());
            batches.add(batch);
        }
        return batches;
    }

    public static <O, I, R> Map<I, List<O>> createBatchIdToObjectsMap(List<? extends O> objects, IBatchIdProvider<O, I> batchIdProvider) {
        LinkedHashMap<I, ArrayList<O>> batchIdToObjectsMap = new LinkedHashMap<I, ArrayList<O>>();
        if (objects != null) {
            for (O object : objects) {
                I batchId;
                if (object == null || (batchId = batchIdProvider.getBatchId(object)) == null) continue;
                ArrayList<O> objectsForBatchId = (ArrayList<O>)batchIdToObjectsMap.get(batchId);
                if (objectsForBatchId == null) {
                    objectsForBatchId = new ArrayList<O>();
                    batchIdToObjectsMap.put(batchId, objectsForBatchId);
                }
                objectsForBatchId.add(object);
            }
        }
        return batchIdToObjectsMap;
    }

    private <O, I, R> void validateBatches(List<IBatch<O, I>> batches, IBatchHandler<O, I, R> batchHandler) {
        for (IBatch<O, I> batch : batches) {
            batchHandler.validateBatch(batch);
        }
    }

    private <O, I, R> Map<IBatch<O, I>, ITerminableFuture<List<R>>> submitBatches(List<IBatch<O, I>> batches, final IBatchHandler<O, I, R> batchHandler) {
        LinkedHashMap<IBatch<O, I>, ITerminableFuture<List<R>>> futures = new LinkedHashMap<IBatch<O, I>, ITerminableFuture<List<R>>>();
        final long startTime = System.currentTimeMillis();
        for (final IBatch<O, I> batch : batches) {
            ITerminableFuture future = ConcurrencyUtilities.submit((ExecutorService)this.executor, new TerminableCallable.INamedCallable<List<R>>(){

                @Override
                public List<R> call(TerminableCallable.IStoppableExecutor<List<R>> stoppableExecutor) throws Exception {
                    return batchHandler.processBatch(batch);
                }

                @Override
                public String getCallableName() {
                    return batch.getId() + "(" + startTime + ")";
                }
            });
            futures.put(batch, future);
        }
        return futures;
    }

    /*
     * Unable to fully structure code
     */
    private <O, I, R> BatchesResults<I, R> gatherResults(Map<IBatch<O, I>, ITerminableFuture<List<R>>> futuresMap) {
        block4: {
            batchesResults = new BatchesResults<I, R>();
            try {
                for (Map.Entry<IBatch<O, I>, ITerminableFuture<List<R>>> futureMapEntry : futuresMap.entrySet()) {
                    batch = futureMapEntry.getKey();
                    future = futureMapEntry.getValue();
                    results = ConcurrencyUtilities.tryGetResult(future, -1L);
                    if (results == null) continue;
                    batchesResults.addBatchResults(new BatchResults<I, R>(batch.getId(), results));
                }
                break block4;
            }
            catch (RuntimeException e) {
                ** for (future : futuresMap.values())
            }
lbl-1000:
            // 1 sources

            {
                future.cancel(true);
                continue;
            }
lbl16:
            // 1 sources

            throw e;
        }
        return batchesResults;
    }
}

