/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.string;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Template {
    private static final char PLACEHOLDER_ESCAPE_CHARACTER = '$';
    private static final char PLACEHOLDER_START_CHARACTER = '{';
    private static final char PLACEHOLDER_METADATA_SEPARATOR = ':';
    private static final char PLACEHOLDER_END_CHARACTER = '}';
    private final Map<String, VariableToken> variableTokens;
    private final List<IToken> tokens;

    private static final String createPlaceholder(String variableName) {
        return String.valueOf('$') + '{' + variableName + '}';
    }

    public Template(String template) {
        this(new LinkedHashMap<String, VariableToken>(), new ArrayList<IToken>());
        assert (template != null) : "Unspecified template.";
        TokenBuilder tokenBuilder = new TokenBuilder(this.variableTokens, this.tokens);
        State state = State.PLAIN;
        int n = template.length();
        int i = 0;
        while (i < n) {
            state = state.next(template.charAt(i), tokenBuilder);
            ++i;
        }
        if (state != State.PLAIN) {
            throw new IllegalArgumentException("Incomplete placeholder detected at the end.");
        }
        tokenBuilder.finishPlainToken();
    }

    private Template(Map<String, VariableToken> variableTokens, List<IToken> tokens) {
        this.variableTokens = variableTokens;
        this.tokens = tokens;
    }

    public Template createFreshCopy() {
        LinkedHashMap<String, VariableToken> map = new LinkedHashMap<String, VariableToken>();
        for (VariableToken variableToken : this.variableTokens.values()) {
            String variableName = variableToken.tryGetName();
            String variableMetadata = variableToken.tryGetMetadata();
            int variableIndex = variableToken.getVariableIndex();
            map.put(variableName, new VariableToken(variableName, variableMetadata, variableIndex));
        }
        ArrayList<IToken> list = new ArrayList<IToken>();
        for (IToken token : this.tokens) {
            if (token instanceof VariableToken) {
                list.add(map.get(((VariableToken)token).tryGetName()));
                continue;
            }
            list.add(token);
        }
        return new Template(map, list);
    }

    public Set<String> getPlaceholderNames() {
        return this.variableTokens.keySet();
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }

    public void bind(String placeholderName, String value) {
        boolean successful = this.attemptToBind(placeholderName, value);
        if (!successful) {
            throw new IllegalArgumentException("Unknown variable '" + placeholderName + "'.");
        }
    }

    public boolean attemptToBind(String placeholderName, String value) {
        assert (placeholderName != null) : "Unspecified placeholder name.";
        assert (value != null) : "Unspecified value for '" + placeholderName + "'";
        VariableToken variableToken = this.variableTokens.get(placeholderName);
        if (variableToken == null) {
            return false;
        }
        variableToken.bind(value);
        return true;
    }

    public int tryGetIndex(String placeholderName) {
        assert (placeholderName != null) : "Unspecified placeholder name.";
        VariableToken variableToken = this.variableTokens.get(placeholderName);
        if (variableToken == null) {
            return -1;
        }
        return variableToken.getVariableIndex();
    }

    public String tryGetMetadata(String placeholderName) {
        assert (placeholderName != null) : "Unspecified placeholder name.";
        VariableToken variableToken = this.variableTokens.get(placeholderName);
        if (variableToken == null) {
            return null;
        }
        return variableToken.tryGetMetadata();
    }

    public List<IToken> replaceBrackets(String oldOpeningBracket, String oldClosingBracket, String newOpeningBracket, String newClosingBracket) {
        ArrayList<IToken> tokensReplaced = new ArrayList<IToken>();
        int i = 1;
        while (i < this.tokens.size() - 1) {
            if (this.tokens.get(i).isVariable() && this.tokenEndsWith(i - 1, oldOpeningBracket) && this.tokenStartsWith(i + 1, oldClosingBracket)) {
                this.tokens.get(i - 1).setSubString(0, oldOpeningBracket.length(), "", newOpeningBracket);
                this.tokens.get(i + 1).setSubString(oldClosingBracket.length(), 0, newClosingBracket, "");
                tokensReplaced.add(this.tokens.get(i));
            }
            ++i;
        }
        return tokensReplaced;
    }

    public IToken tryGetLeftNeighbor(String variableName) {
        int i = 1;
        while (i < this.tokens.size() - 1) {
            if (this.tokens.get(i).isVariable() && StringUtils.equals(this.tokens.get(i).tryGetName(), variableName)) {
                return this.tokens.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    public IToken tryGetRightNeighbor(String variableName) {
        int i = 1;
        while (i < this.tokens.size() - 1) {
            if (this.tokens.get(i).isVariable() && StringUtils.equals(this.tokens.get(i).tryGetName(), variableName)) {
                return this.tokens.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    private boolean tokenStartsWith(int tokenInx, String text) {
        IToken token = this.tokens.get(tokenInx);
        return !token.isVariable() && StringUtils.startsWith(token.tryGetValue(), text);
    }

    private boolean tokenEndsWith(int tokenInx, String text) {
        IToken token = this.tokens.get(tokenInx);
        return !token.isVariable() && StringUtils.endsWith(token.tryGetValue(), text);
    }

    public String createText() {
        return this.createText(true);
    }

    public String createText(boolean complete) {
        if (complete) {
            this.assertAllVariablesAreBound();
        }
        StringBuilder builder = new StringBuilder();
        for (IToken token : this.tokens) {
            token.appendTo(builder);
        }
        return builder.toString();
    }

    private void assertAllVariablesAreBound() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, VariableToken> entry : this.variableTokens.entrySet()) {
            if (entry.getValue().isBound()) continue;
            builder.append(entry.getKey()).append(' ');
        }
        if (builder.length() > 0) {
            throw new IllegalStateException("The following variables are not bound: " + builder);
        }
    }

    public boolean allVariablesAreBound() {
        for (VariableToken value : this.variableTokens.values()) {
            if (value.isBound()) continue;
            return false;
        }
        return true;
    }

    public static interface IToken {
        public void appendTo(StringBuilder var1);

        public boolean isVariable();

        public String tryGetName();

        public int getVariableIndex();

        public String tryGetValue();

        public String tryGetMetadata();

        public void setValue(String var1);

        public void setSubString(int var1, int var2, String var3, String var4);

        public String tryGetPrefix();

        public String tryGetSuffix();

        public boolean isBound();

        public void bind(String var1) throws UnsupportedOperationException;
    }

    public static final class PlainToken
    implements IToken {
        private String plainText;

        PlainToken(String plainText) {
            assert (plainText != null) : "Unspecified plain text.";
            this.plainText = plainText;
        }

        @Override
        public void appendTo(StringBuilder builder) {
            builder.append(this.plainText);
        }

        @Override
        public String tryGetName() {
            return null;
        }

        @Override
        public String tryGetMetadata() {
            return null;
        }

        @Override
        public String tryGetValue() {
            return this.plainText;
        }

        @Override
        public void setValue(String value) {
            this.plainText = value;
        }

        @Override
        public void setSubString(int start, int indexFromEnd, String prefix, String suffix) {
            this.plainText = String.valueOf(prefix) + StringUtils.substring(this.plainText, start, StringUtils.length(this.plainText) - indexFromEnd) + suffix;
        }

        @Override
        public String tryGetPrefix() {
            return null;
        }

        @Override
        public String tryGetSuffix() {
            return null;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public int getVariableIndex() {
            return -1;
        }

        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public void bind(String value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static enum State {
        PLAIN{

            @Override
            State next(char character, TokenBuilder tokenBuilder) {
                if (character == '$') {
                    return STARTING_PLACEHOLDER;
                }
                tokenBuilder.addCharacter(character);
                return PLAIN;
            }
        }
        ,
        STARTING_PLACEHOLDER{

            @Override
            State next(char character, TokenBuilder tokenBuilder) {
                switch (character) {
                    case '$': {
                        tokenBuilder.addCharacter('$');
                        return PLAIN;
                    }
                    case '{': {
                        tokenBuilder.finishPlainToken();
                        return PLACEHOLDER;
                    }
                }
                tokenBuilder.addCharacter('$');
                tokenBuilder.addCharacter(character);
                return PLAIN;
            }
        }
        ,
        PLACEHOLDER{

            @Override
            State next(char character, TokenBuilder tokenBuilder) {
                if (character == '}') {
                    tokenBuilder.finishPlaceholder();
                    return PLAIN;
                }
                if (character == ':') {
                    return STARTING_PLACEHOLDER_METADATA;
                }
                tokenBuilder.addCharacter(character);
                return PLACEHOLDER;
            }
        }
        ,
        STARTING_PLACEHOLDER_METADATA{

            @Override
            State next(char character, TokenBuilder tokenBuilder) {
                if (character == ':') {
                    return PLACEHOLDER_METADATA;
                }
                tokenBuilder.addCharacter(':');
                tokenBuilder.addCharacter(character);
                return PLACEHOLDER;
            }
        }
        ,
        PLACEHOLDER_METADATA{

            @Override
            State next(char character, TokenBuilder tokenBuilder) {
                if (character == '}') {
                    tokenBuilder.finishPlaceholder();
                    return PLAIN;
                }
                tokenBuilder.addMetadataCharacter(character);
                return PLACEHOLDER_METADATA;
            }
        };


        abstract State next(char var1, TokenBuilder var2);
    }

    private static final class TokenBuilder {
        private final Map<String, VariableToken> variableTokens;
        private final List<IToken> tokens;
        private final StringBuilder builder;
        private final StringBuilder metadataBuilder;
        private int index;

        TokenBuilder(Map<String, VariableToken> variableTokens, List<IToken> tokens) {
            this.variableTokens = variableTokens;
            this.tokens = tokens;
            this.builder = new StringBuilder();
            this.metadataBuilder = new StringBuilder();
        }

        public void addCharacter(char character) {
            this.builder.append(character);
        }

        public void addMetadataCharacter(char character) {
            this.metadataBuilder.append(character);
        }

        public void finishPlainToken() {
            if (this.builder.length() > 0) {
                this.tokens.add(new PlainToken(this.builder.toString()));
                this.builder.setLength(0);
            }
        }

        public void finishPlaceholder() {
            String variableName = this.builder.toString();
            String variableMetadata = this.metadataBuilder.toString();
            if (variableName.length() == 0) {
                throw new IllegalArgumentException("Nameless placeholder " + Template.createPlaceholder("") + " found.");
            }
            VariableToken token = this.variableTokens.get(variableName);
            if (token == null) {
                token = new VariableToken(variableName, variableMetadata, this.index++);
                this.variableTokens.put(variableName, token);
            }
            this.tokens.add(token);
            this.builder.setLength(0);
            this.metadataBuilder.setLength(0);
        }
    }

    public static final class VariableToken
    implements IToken {
        private final String variableName;
        private final String variableMetadata;
        private final int variableIndex;
        private String prefix;
        private String suffix;
        private String value;

        VariableToken(String variablePlaceHolder, String variableMetadata, int variableIndex) {
            assert (variablePlaceHolder != null) : "Unspecified variable place holder.";
            this.variableName = variablePlaceHolder;
            this.variableMetadata = StringUtils.isEmpty(variableMetadata) ? null : variableMetadata;
            this.variableIndex = variableIndex;
        }

        @Override
        public void appendTo(StringBuilder builder) {
            if (this.prefix != null) {
                builder.append(this.prefix);
            }
            builder.append(this.isBound() ? this.value : Template.createPlaceholder(this.variableName));
            if (this.suffix != null) {
                builder.append(this.suffix);
            }
        }

        @Override
        public String tryGetName() {
            return this.variableName;
        }

        @Override
        public String tryGetMetadata() {
            return this.variableMetadata;
        }

        @Override
        public String tryGetValue() {
            return String.valueOf(this.prefix != null ? this.prefix : "") + this.value + (this.suffix != null ? this.suffix : "");
        }

        @Override
        public void setValue(String value) {
            this.bind(value);
        }

        @Override
        public void setSubString(int start, int indexFromEnd, String prefix, String suffix) {
            this.bind(StringUtils.substring(this.value, start, StringUtils.length(this.value) - indexFromEnd));
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public String tryGetPrefix() {
            return this.prefix;
        }

        @Override
        public String tryGetSuffix() {
            return this.suffix;
        }

        @Override
        public boolean isVariable() {
            return true;
        }

        @Override
        public boolean isBound() {
            return this.value != null;
        }

        @Override
        public void bind(String v) {
            this.value = v;
        }

        @Override
        public int getVariableIndex() {
            return this.variableIndex;
        }
    }
}

