/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io;

import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ConcatenatedContentInputStream
extends InputStream {
    private static final int EOF = -1;
    private int currentIndex = -1;
    private boolean eof = false;
    private IHierarchicalContentNode[] contents;
    private boolean readingContentSize;
    private InputStream currentStream;
    private final boolean ignoreNonExistingContents;

    public static IHierarchicalContentNode[] wrap(List<File> files) {
        ArrayList<FileBasedContentNode> list = new ArrayList<FileBasedContentNode>();
        for (File file : files) {
            list.add(new FileBasedContentNode(file));
        }
        return list.toArray(new IHierarchicalContentNode[files.size()]);
    }

    public ConcatenatedContentInputStream(boolean ignoreNonExistingContents, IHierarchicalContentNode ... contents) {
        this.ignoreNonExistingContents = ignoreNonExistingContents;
        this.contents = contents;
        this.readingContentSize = false;
    }

    public ConcatenatedContentInputStream(boolean ignoreNonExistingContents, List<IHierarchicalContentNode> contents) {
        this(ignoreNonExistingContents, contents.toArray(new IHierarchicalContentNode[contents.size()]));
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentStream();
        this.eof = true;
    }

    @Override
    public int read() throws IOException {
        int result = this.readCurrent();
        while (result == -1 && !this.eof) {
            this.closeCurrentStream();
            if (this.readingContentSize) {
                this.currentStream = ConcatenatedContentInputStream.createContentStream(this.ignoreNonExistingContents, this.tryGetCurrentContent());
                this.readingContentSize = false;
            } else {
                ++this.currentIndex;
                if (!this.hasCurrentContent()) {
                    this.eof = true;
                    return -1;
                }
                this.currentStream = ConcatenatedContentInputStream.createSizeStream(this.tryGetCurrentContent());
                this.readingContentSize = true;
            }
            result = this.currentStream.read();
        }
        return result;
    }

    private IHierarchicalContentNode tryGetCurrentContent() {
        if (!this.hasCurrentContent()) {
            throw new IllegalStateException("there are no more content to read");
        }
        return this.contents[this.currentIndex];
    }

    private boolean hasCurrentContent() {
        return this.contents != null && this.currentIndex < this.contents.length;
    }

    private int readCurrent() throws IOException {
        return this.eof || this.currentStream == null ? -1 : this.currentStream.read();
    }

    private void closeCurrentStream() {
        ConcatenatedContentInputStream.close(this.currentStream);
        this.currentStream = null;
    }

    private static InputStream createContentStream(boolean ignoreNonExistingContents, IHierarchicalContentNode currentContentOrNull) {
        InputStream stream = ignoreNonExistingContents && (currentContentOrNull == null || !currentContentOrNull.exists()) ? ConcatenatedContentInputStream.createEmptyStream() : currentContentOrNull.getInputStream();
        return new BufferedInputStream(stream);
    }

    private static ByteArrayInputStream createEmptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    private static InputStream createSizeStream(IHierarchicalContentNode contentOrNull) throws IOException {
        long size = contentOrNull == null ? 0L : contentOrNull.getFileLength();
        byte[] data = ConcatenatedContentInputStream.longToBytes(size);
        return new ByteArrayInputStream(data);
    }

    private static byte[] longToBytes(long size) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(size);
        dos.flush();
        byte[] data = bos.toByteArray();
        dos.close();
        return data;
    }

    private static void close(InputStream streamOrNull) {
        if (streamOrNull != null) {
            try {
                streamOrNull.close();
            }
            catch (IOException iOException) {}
        }
    }
}

