/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.systemsx.cisd.common.api.retry.Retry;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.AuthenticatedState;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DataSetDss
implements IDataSetDss {
    private final String code;
    private final IDssServiceRpcGeneric service;
    private final AuthenticatedState parent;

    public DataSetDss(String code, IDssServiceRpcGeneric service, AuthenticatedState parent) {
        this.code = code;
        this.service = service;
        this.parent = parent;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public InputStream getFile(String path) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.getFile(this, path);
    }

    @Override
    public FileInfoDssDTO[] listFiles(String startPath, boolean isRecursive) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.listFiles(this, startPath, isRecursive);
    }

    @Override
    public File tryLinkToContents(String overrideStoreRootPathOrNull) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.tryLinkToContents(this, overrideStoreRootPathOrNull);
    }

    @Override
    public String tryGetInternalPathInDataStore() throws InvalidSessionException, EnvironmentFailureException {
        return this.parent.tryGetInternalPathInDataStore(this, null);
    }

    @Override
    public File getLinkOrCopyOfContents(String overrideStoreRootPathOrNull, File downloadDir) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.getLinkOrCopyOfContents(this, overrideStoreRootPathOrNull, downloadDir, null);
    }

    @Override
    public File getLinkOrCopyOfContent(String overrideStoreRootPathOrNull, File downloadDir, String pathInDataSet) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.getLinkOrCopyOfContents(this, overrideStoreRootPathOrNull, downloadDir, pathInDataSet);
    }

    public AuthenticatedState getParent() {
        return this.parent;
    }

    public IDssServiceRpcGeneric getService() {
        return this.service;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("code", this.code);
        return builder.toString();
    }

    @Override
    @Retry
    public String getSessionURLForFile(String path) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.getSessionURLForFile(this, path);
    }

    @Override
    @Retry
    public String getURLForFileWithTimeout(String path, long validityDurationInSeconds) throws IllegalArgumentException, InvalidSessionException {
        return this.parent.getURLForFileWithTimeout(this, path, validityDurationInSeconds);
    }
}

