/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageChannel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonObject(value="ImageDatasetMetadata")
public class ImageDatasetMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IImageDatasetIdentifier imageDataset;
    private int channelsNumber;
    private List<String> channelNames;
    private List<String> channelCodes;
    private List<String> channelLabels;
    private List<ImageChannel> channels;
    private int tilesNumber;
    private int tilesRows;
    private int tilesCols;
    private int width;
    private int height;
    private int thumbnailWidth;
    private int thumbnailHeight;

    public ImageDatasetMetadata(IImageDatasetIdentifier dataset, List<ImageChannel> channels, int tilesRows, int tilesCols, int width, int height, int thumbnailWidth, int thumbnailHeight) {
        this.imageDataset = dataset;
        Collections.sort(channels);
        this.channels = channels;
        this.channelsNumber = channels.size();
        this.channelNames = new ArrayList<String>(this.channelsNumber);
        this.channelCodes = new ArrayList<String>(this.channelsNumber);
        this.channelLabels = new ArrayList<String>(this.channelsNumber);
        for (ImageChannel c : channels) {
            this.channelNames.add(c.getCode());
            this.channelCodes.add(c.getCode());
            this.channelLabels.add(c.getLabel());
        }
        this.tilesRows = tilesRows;
        this.tilesCols = tilesCols;
        this.tilesNumber = tilesRows * tilesCols;
        this.width = width;
        this.height = height;
        this.thumbnailHeight = thumbnailHeight;
        this.thumbnailWidth = thumbnailWidth;
    }

    public IImageDatasetIdentifier getImageDataset() {
        return this.imageDataset;
    }

    public int getNumberOfChannels() {
        return this.channelsNumber;
    }

    public List<ImageChannel> getChannels() {
        return this.channels;
    }

    @Deprecated
    public List<String> getChannelNames() {
        return this.channelNames;
    }

    public List<String> getChannelCodes() {
        return this.channelCodes == null ? this.channelNames : this.channelCodes;
    }

    @Deprecated
    public List<String> getChannelLabels() {
        return this.channelLabels == null ? this.channelNames : this.channelLabels;
    }

    public int getTilesRows() {
        return this.tilesRows;
    }

    public int getTilesCols() {
        return this.tilesCols;
    }

    public int getNumberOfTiles() {
        return this.tilesNumber;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public boolean hasThumbnails() {
        return this.thumbnailHeight > 0 && this.thumbnailWidth > 0;
    }

    public String toString() {
        String thumbnailsDesc = this.hasThumbnails() ? ". Thumbnail resolution: " + this.thumbnailWidth + "x" + this.thumbnailHeight + "." : "";
        return "Dataset " + this.imageDataset + " has [" + this.getChannelCodes() + "] channels, " + this.tilesNumber + " tiles. Image resolution: " + this.width + "x" + this.height + thumbnailsDesc;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.channels == null) {
            List<String> codes = this.getChannelCodes();
            List<String> labels = this.getChannelLabels();
            this.channels = new ArrayList<ImageChannel>(this.channelsNumber);
            int i = 0;
            while (i < this.channelsNumber) {
                this.channels.add(new ImageChannel(codes.get(i), labels.get(i)));
                ++i;
            }
        }
    }

    private ImageDatasetMetadata() {
    }

    private void setImageDataset(IImageDatasetIdentifier imageDataset) {
        this.imageDataset = imageDataset;
    }

    private void setNumberOfChannels(int numberOfChannels) {
        this.channelsNumber = numberOfChannels;
    }

    private void setChannelNames(List<String> channelNames) {
        this.channelNames = channelNames;
    }

    private void setChannelCodes(List<String> channelCodes) {
        this.channelCodes = channelCodes;
    }

    private void setChannelLabels(List<String> channelLabels) {
        this.channelLabels = channelLabels;
    }

    private void setChannels(List<ImageChannel> channels) {
        this.channels = channels;
    }

    private void setNumberOfTiles(int numberOfTiles) {
        this.tilesNumber = numberOfTiles;
    }

    private void setTilesRows(int tilesRows) {
        this.tilesRows = tilesRows;
    }

    private void setTilesCols(int tilesCols) {
        this.tilesCols = tilesCols;
    }

    private void setWidth(int width) {
        this.width = width;
    }

    private void setHeight(int height) {
        this.height = height;
    }

    private void setThumbnailWidth(int thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    private void setThumbnailHeight(int thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }
}

