/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorMessageDialog
extends JDialog {
    private static final long serialVersionUID = 2915724575615063627L;
    private final JTextArea errorArea = new JTextArea();
    private final JFrame mainWindow;
    public JPopupMenu popup;

    public ErrorMessageDialog(JFrame mainWindow) {
        super((Frame)mainWindow, true);
        this.mainWindow = mainWindow;
        JScrollPane scrollPane = new JScrollPane(this.errorArea);
        Object[] objects = new Object[]{"Validation error occured: ", scrollPane};
        final JOptionPane optionPane = new JOptionPane(objects, 0, -1, null);
        this.setContentPane(optionPane);
        this.errorArea.setEditable(false);
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy");
        this.popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorMessageDialog.this.errorArea.copy();
            }
        });
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != null && evt.getPropertyName().equals("value") && evt.getNewValue() != null && (Integer)evt.getNewValue() == 0) {
                    optionPane.setValue(optionPane.getInitialValue());
                    ErrorMessageDialog.this.dispose();
                }
            }
        });
        this.errorArea.addMouseListener(new MousePopupListener());
    }

    public void showErrorMessage(String errorMessage) {
        this.errorArea.setText(errorMessage);
        this.pack();
        int height = this.getHeight() > 500 ? 500 : this.getHeight();
        int width = this.getWidth() > 600 ? 600 : this.getWidth();
        this.setSize(width, height);
        Point mwLocation = this.mainWindow.getLocationOnScreen();
        int x = mwLocation.x + this.mainWindow.getWidth() / 2 - this.getWidth() / 2;
        int y = mwLocation.y + this.mainWindow.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        this.setVisible(true);
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ErrorMessageDialog.this.popup.show(ErrorMessageDialog.this.errorArea, e.getX(), e.getY());
            }
        }
    }
}

