/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.HierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.DssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IDssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.PathInfoDBOnlyHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DataSetAndPathInfoDBConsistencyChecker {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetAndPathInfoDBConsistencyChecker.class);
    private static final Comparator<Map.Entry<IDatasetLocation, List<Difference>>> DATA_SET_COMPARATOR = new Comparator<Map.Entry<IDatasetLocation, List<Difference>>>(){

        @Override
        public int compare(Map.Entry<IDatasetLocation, List<Difference>> e1, Map.Entry<IDatasetLocation, List<Difference>> e2) {
            return e1.getKey().getDataSetCode().compareTo(e2.getKey().getDataSetCode());
        }
    };
    private IHierarchicalContentProvider fileProvider;
    private IHierarchicalContentProvider pathInfoProvider;
    private IDssServiceRpcGenericFactory serviceFactory;
    private Map<IDatasetLocation, List<Difference>> differences;
    private ProcessingStatus status;
    private List<? extends IDatasetLocation> dataSets;

    public DataSetAndPathInfoDBConsistencyChecker(IHierarchicalContentProvider fileProvider, IHierarchicalContentProvider pathInfoProvider) {
        this.fileProvider = fileProvider;
        this.pathInfoProvider = pathInfoProvider;
    }

    public void check(List<? extends IDatasetLocation> datasets) {
        this.dataSets = datasets;
        this.differences = new HashMap<IDatasetLocation, List<Difference>>();
        this.status = new ProcessingStatus();
        for (IDatasetLocation iDatasetLocation : datasets) {
            IHierarchicalContent fileContent = null;
            IHierarchicalContent pathInfoContent = null;
            try {
                try {
                    fileContent = this.tryGetContent(this.getFileProvider(), iDatasetLocation.getDataSetCode());
                    pathInfoContent = this.tryGetContent(this.getPathInfoProvider(), iDatasetLocation.getDataSetCode());
                    ArrayList<Difference> datasetDifferences = new ArrayList<Difference>();
                    this.compare(fileContent, pathInfoContent, datasetDifferences);
                    if (!datasetDifferences.isEmpty()) {
                        this.differences.put(iDatasetLocation, datasetDifferences);
                    }
                    this.status.addDatasetStatus(iDatasetLocation.getDataSetCode(), Status.OK);
                }
                catch (Exception e) {
                    operationLog.error((Object)("Couldn't check consistency of the file system and the path info database for a data set: " + iDatasetLocation.getDataSetCode()), (Throwable)e);
                    this.status.addDatasetStatus(iDatasetLocation.getDataSetCode(), Status.createError("Couldn't check consistency of the file system and the path info database for a data set: " + iDatasetLocation.getDataSetCode() + " because of the following exception: " + e.getMessage()));
                    if (fileContent != null) {
                        fileContent.close();
                    }
                    if (pathInfoContent == null) continue;
                    pathInfoContent.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (fileContent != null) {
                    fileContent.close();
                }
                if (pathInfoContent != null) {
                    pathInfoContent.close();
                }
                throw throwable;
            }
            if (fileContent != null) {
                fileContent.close();
            }
            if (pathInfoContent == null) continue;
            pathInfoContent.close();
        }
    }

    public ProcessingStatus getStatus() {
        if (this.status == null) {
            throw new IllegalStateException("Undefined status before check() has been executed.");
        }
        return this.status;
    }

    public boolean noErrorAndInconsitencyFound() {
        return this.status.getErrorStatuses().isEmpty() && this.differences.isEmpty();
    }

    public String createReport() {
        return this.status.getErrorStatuses().isEmpty() ? this.createNormalReport() : this.createErrorReport();
    }

    private String createNormalReport() {
        StringBuilder builder = new StringBuilder();
        builder.append("Data sets checked:\n\n");
        Iterator<? extends IDatasetLocation> datasetsIterator = this.dataSets.iterator();
        while (datasetsIterator.hasNext()) {
            builder.append(datasetsIterator.next().getDataSetCode());
            if (!datasetsIterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("\n\n");
        builder.append("Differences found:\n\n");
        if (this.differences.isEmpty()) {
            builder.append("None");
        } else {
            ArrayList<Map.Entry<IDatasetLocation, List<Difference>>> entries = new ArrayList<Map.Entry<IDatasetLocation, List<Difference>>>(this.differences.entrySet());
            Collections.sort(entries, DATA_SET_COMPARATOR);
            for (Map.Entry entry : entries) {
                IDatasetLocation dataset = (IDatasetLocation)entry.getKey();
                List datasetDifferences = (List)entry.getValue();
                Collections.sort(datasetDifferences);
                builder.append("Data set " + dataset.getDataSetCode() + ":\n");
                for (Difference datasetDifference : datasetDifferences) {
                    builder.append("- " + datasetDifference.getDescription() + "\n");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private String createErrorReport() {
        StringBuilder builder = new StringBuilder();
        builder.append("Error when checking datasets:\n\n");
        for (Status s : this.status.getErrorStatuses()) {
            builder.append(s.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private void compare(IHierarchicalContent fileContent, IHierarchicalContent pathInfoContent, List<Difference> diffs) {
        IHierarchicalContentNode fileRoot = this.tryGetRoot(fileContent);
        IHierarchicalContentNode pathInfoRoot = this.tryGetRoot(pathInfoContent);
        if (fileRoot != null && pathInfoRoot != null) {
            this.compare(fileRoot, pathInfoRoot, diffs);
        } else if (fileRoot == null && pathInfoRoot != null) {
            diffs.add(new RootExistenceDifference());
        } else if (fileRoot == null && pathInfoRoot == null) {
            diffs.add(new RootExistence());
        }
    }

    private void compare(IHierarchicalContentNode fileNode, IHierarchicalContentNode pathInfoNode, List<Difference> diffs) {
        boolean pathInfoNodeExists;
        boolean fileNodeExists = fileNode != null && fileNode.exists();
        boolean bl = pathInfoNodeExists = pathInfoNode != null && pathInfoNode.exists();
        if (!fileNodeExists || !pathInfoNodeExists) {
            if (fileNodeExists && !pathInfoNodeExists) {
                diffs.add(new NodeExistenceDifference(fileNode.getRelativePath(), true));
            }
            if (pathInfoNodeExists && !fileNodeExists) {
                diffs.add(new NodeExistenceDifference(pathInfoNode.getRelativePath(), false));
            }
            return;
        }
        if (!fileNode.getRelativePath().equals(pathInfoNode.getRelativePath())) {
            diffs.add(new NodeChildrenDifference(fileNode.getRelativePath(), true));
            diffs.add(new NodeChildrenDifference(pathInfoNode.getRelativePath(), false));
        }
        if (fileNode.isDirectory() && pathInfoNode.isDirectory()) {
            Children children = new Children(fileNode, pathInfoNode);
            for (String commonPath : children.getCommonPaths()) {
                this.compare(children.getFileNode(commonPath), children.getPathInfoNode(commonPath), diffs);
            }
            for (IHierarchicalContentNode uncommonNode : children.getFileUncommonNodes()) {
                diffs.add(new NodeChildrenDifference(uncommonNode.getRelativePath(), true));
            }
            for (IHierarchicalContentNode uncommonNode : children.getPathInfoUncommonNodes()) {
                diffs.add(new NodeChildrenDifference(uncommonNode.getRelativePath(), false));
            }
        } else if (!fileNode.isDirectory() && !pathInfoNode.isDirectory()) {
            if (fileNode.getFileLength() != pathInfoNode.getFileLength()) {
                diffs.add(new SizeDifference(fileNode.getRelativePath(), fileNode.getFileLength(), pathInfoNode.getFileLength()));
            }
            if (pathInfoNode.isChecksumCRC32Precalculated() && fileNode.getChecksumCRC32() != pathInfoNode.getChecksumCRC32()) {
                diffs.add(new ChecksumDifference(fileNode.getRelativePath(), fileNode.getChecksumCRC32(), pathInfoNode.getChecksumCRC32()));
            }
        } else {
            diffs.add(new DirectoryDifference(fileNode.getRelativePath(), fileNode.isDirectory()));
        }
    }

    private IHierarchicalContent tryGetContent(IHierarchicalContentProvider contentProvider, String datasetCode) {
        try {
            return contentProvider.asContent(datasetCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private IHierarchicalContentNode tryGetRoot(IHierarchicalContent content) {
        block3: {
            try {
                if (content != null) break block3;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return content.getRootNode();
    }

    private IHierarchicalContentProvider getFileProvider() {
        if (this.fileProvider == null) {
            this.fileProvider = new HierarchicalContentProvider(ServiceProvider.getOpenBISService(), ServiceProvider.getShareIdManager(), ServiceProvider.getConfigProvider(), ServiceProvider.getContentCache(), (IHierarchicalContentFactory)new DefaultFileBasedHierarchicalContentFactory(), this.getServiceFactory(), null, null);
        }
        return this.fileProvider;
    }

    private IHierarchicalContentProvider getPathInfoProvider() {
        if (this.pathInfoProvider == null) {
            IHierarchicalContentFactory pathInfoDBFactory = PathInfoDBOnlyHierarchicalContentFactory.create();
            if (pathInfoDBFactory == null) {
                throw new IllegalArgumentException("Path info database is not configured.");
            }
            this.pathInfoProvider = new HierarchicalContentProvider(ServiceProvider.getOpenBISService(), ServiceProvider.getShareIdManager(), ServiceProvider.getConfigProvider(), ServiceProvider.getContentCache(), pathInfoDBFactory, this.getServiceFactory(), null, null);
        }
        return this.pathInfoProvider;
    }

    private IDssServiceRpcGenericFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new DssServiceRpcGenericFactory();
        }
        return this.serviceFactory;
    }

    private class ChecksumDifference
    extends Difference {
        private int checksumInFS;
        private int checksumInDB;

        public ChecksumDifference(String path, int checksumInFS, int checksumInDB) {
            super(path);
            this.checksumInFS = checksumInFS;
            this.checksumInDB = checksumInDB;
        }

        @Override
        public String getDescription() {
            return "'" + this.getPath() + "' CRC32 checksum in the file system = " + IOUtilities.crc32ToString(this.checksumInFS) + " but in the path info database = " + IOUtilities.crc32ToString(this.checksumInDB);
        }
    }

    private class Children {
        private Map<String, IHierarchicalContentNode> fileChildrenMap;
        private Map<String, IHierarchicalContentNode> pathInfoChildrenMap;

        public Children(IHierarchicalContentNode fileNode, IHierarchicalContentNode pathInfoNode) {
            this.fileChildrenMap = this.getMap(fileNode);
            this.pathInfoChildrenMap = this.getMap(pathInfoNode);
        }

        public IHierarchicalContentNode getFileNode(String path) {
            return this.fileChildrenMap.get(path);
        }

        public IHierarchicalContentNode getPathInfoNode(String path) {
            return this.pathInfoChildrenMap.get(path);
        }

        public Set<IHierarchicalContentNode> getFileUncommonNodes() {
            return this.getUncommonNodes(this.fileChildrenMap);
        }

        public Set<IHierarchicalContentNode> getPathInfoUncommonNodes() {
            return this.getUncommonNodes(this.pathInfoChildrenMap);
        }

        public Set<String> getCommonPaths() {
            HashSet<String> commonPaths = new HashSet<String>();
            for (String path : this.fileChildrenMap.keySet()) {
                if (!this.pathInfoChildrenMap.containsKey(path)) continue;
                commonPaths.add(path);
            }
            return commonPaths;
        }

        private Map<String, IHierarchicalContentNode> getMap(IHierarchicalContentNode node) {
            TreeMap<String, IHierarchicalContentNode> map = new TreeMap<String, IHierarchicalContentNode>();
            for (IHierarchicalContentNode child : node.getChildNodes()) {
                map.put(child.getRelativePath(), child);
            }
            return map;
        }

        public Set<IHierarchicalContentNode> getUncommonNodes(Map<String, IHierarchicalContentNode> childrenMap) {
            Set<String> commonNames = this.getCommonPaths();
            HashSet<IHierarchicalContentNode> uncommonNodes = new HashSet<IHierarchicalContentNode>();
            for (Map.Entry<String, IHierarchicalContentNode> child : childrenMap.entrySet()) {
                if (commonNames.contains(child.getValue().getRelativePath())) continue;
                uncommonNodes.add(child.getValue());
            }
            return uncommonNodes;
        }
    }

    private abstract class Difference
    implements Comparable<Difference> {
        private String path;

        public Difference(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public abstract String getDescription();

        @Override
        public int compareTo(Difference o) {
            return this.getPath().compareTo(o.getPath());
        }
    }

    private class DirectoryDifference
    extends Difference {
        private boolean dirInFS;

        public DirectoryDifference(String path, boolean dirInFS) {
            super(path);
            this.dirInFS = dirInFS;
        }

        @Override
        public String getDescription() {
            if (this.dirInFS) {
                return "'" + this.getPath() + "' is a directory in the file system but a file in the path info database";
            }
            return "'" + this.getPath() + "' is a directory in the path info database but a file in the file system";
        }
    }

    private class NodeChildrenDifference
    extends Difference {
        private boolean existsInFS;

        public NodeChildrenDifference(String path, boolean existsInFS) {
            super(path);
            this.existsInFS = existsInFS;
        }

        @Override
        public String getDescription() {
            if (this.existsInFS) {
                return "'" + this.getPath() + "' is on the file system but is not referenced in the path info database";
            }
            return "'" + this.getPath() + "' is referenced in the path info database but does not exist on the file system";
        }
    }

    private class NodeExistenceDifference
    extends Difference {
        private boolean existsInFS;

        public NodeExistenceDifference(String path, boolean existsInFS) {
            super(path);
            this.existsInFS = existsInFS;
        }

        @Override
        public String getDescription() {
            if (this.existsInFS) {
                return "'" + this.getPath() + "' exists on the file system but does not exist in the path info database";
            }
            return "'" + this.getPath() + "' exists in the path info database but does not exist on the file system";
        }
    }

    private class RootExistence
    extends Difference {
        public RootExistence() {
            super(null);
        }

        @Override
        public String getDescription() {
            return "exists neither in the path info database nor in the file system";
        }
    }

    private class RootExistenceDifference
    extends Difference {
        public RootExistenceDifference() {
            super(null);
        }

        @Override
        public String getDescription() {
            return "exists in the path info database but does not exist in the file system";
        }
    }

    private class SizeDifference
    extends Difference {
        private long sizeInFS;
        private long sizeInDB;

        public SizeDifference(String path, long sizeInFS, long sizeInDB) {
            super(path);
            this.sizeInFS = sizeInFS;
            this.sizeInDB = sizeInDB;
        }

        @Override
        public String getDescription() {
            return "'" + this.getPath() + "' size in the file system = " + this.sizeInFS + " bytes but in the path info database = " + this.sizeInDB + " bytes.";
        }
    }
}

