/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.fileconverter.IFileConversionStrategy;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import org.apache.log4j.Logger;

class FileConversionTaskExecutor
implements ITaskExecutor<File> {
    @Private
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileConversionTaskExecutor.class);
    private static final String INPROGRESS_MARKER = ".CONVERSION_IN_PROGRESS_";
    private static final String CONVERTED_MARKER = ".CONVERTED_";
    private final IFileConversionStrategy conversionStrategy;

    private File prefixInProgress(File file) {
        assert (file != null);
        return new File(file.getParent(), INPROGRESS_MARKER + file.getName());
    }

    private File prefixConverted(File file) {
        assert (file != null);
        return new File(file.getParent(), CONVERTED_MARKER + file.getName());
    }

    private File tryRemovePrefix(File file) {
        assert (file != null);
        String name = file.getName();
        if (name.startsWith(INPROGRESS_MARKER)) {
            return new File(file.getParent(), name.substring(INPROGRESS_MARKER.length()));
        }
        if (name.startsWith(CONVERTED_MARKER)) {
            return new File(file.getParent(), name.substring(CONVERTED_MARKER.length()));
        }
        return null;
    }

    private boolean isConvertedFile(File fileToCompress) {
        return fileToCompress.getName().startsWith(CONVERTED_MARKER);
    }

    private boolean isInProgressFile(File fileToCompress) {
        return fileToCompress.getName().startsWith(INPROGRESS_MARKER);
    }

    private Status createStatus(String msgTemplate, Object ... params) {
        String msg = String.format(msgTemplate, params);
        return Status.createError(msg);
    }

    FileConversionTaskExecutor(IFileConversionStrategy conversionStrategy) {
        assert (conversionStrategy != null);
        this.conversionStrategy = conversionStrategy;
    }

    @Override
    public Status execute(File fileToConvert) {
        File convertedFile = this.conversionStrategy.tryCheckConvert(fileToConvert);
        if (convertedFile == null) {
            return this.createStatus("IllegalFile: '%s'", fileToConvert.getAbsolutePath());
        }
        if (convertedFile.equals(fileToConvert)) {
            return this.convertInPlace(fileToConvert);
        }
        return this.convert(fileToConvert, convertedFile, this.conversionStrategy.deleteOriginalFile());
    }

    private Status convert(File fileToConvert, File convertedFile, boolean deleteOriginalFile) {
        if (this.isInProgressFile(fileToConvert)) {
            return this.deleteOriginalFile(fileToConvert);
        }
        if (convertedFile.exists() && convertedFile.length() > 0L) {
            return this.deleteOriginalFileIfRequestedAndGetStatus(fileToConvert, deleteOriginalFile);
        }
        File inProgressFile = this.prefixInProgress(convertedFile);
        boolean runOK = this.conversionStrategy.getConverter().convert(fileToConvert, inProgressFile);
        if (!runOK) {
            return this.createStatus("Unable to convert '%s'.", fileToConvert.getAbsolutePath());
        }
        boolean renameOK = inProgressFile.renameTo(convertedFile);
        if (!renameOK) {
            return this.createStatus("Unable to rename '%s' to '%s'.", inProgressFile.getAbsolutePath(), convertedFile.getAbsolutePath());
        }
        return this.deleteOriginalFileIfRequestedAndGetStatus(fileToConvert, deleteOriginalFile);
    }

    private Status convertInPlace(File fileToConvert) {
        if (this.isInProgressFile(fileToConvert)) {
            return this.deleteOriginalFile(fileToConvert);
        }
        if (this.isConvertedFile(fileToConvert)) {
            boolean ok;
            File originalFile = this.tryRemovePrefix(fileToConvert);
            assert (originalFile != null);
            if (originalFile.exists() && !(ok = originalFile.delete())) {
                return this.createStatus("Clean up: Unable to delete original file '%s' failed.", originalFile);
            }
            if (fileToConvert.renameTo(originalFile)) {
                return Status.OK;
            }
            return this.createStatus("Renaming converted file '%s' to original name '%s' failed.", fileToConvert, originalFile);
        }
        File inProgressFile = this.prefixInProgress(fileToConvert);
        File convertedFile = this.prefixConverted(fileToConvert);
        boolean runOK = this.conversionStrategy.getConverter().convert(fileToConvert, inProgressFile);
        if (!runOK) {
            return this.createStatus("Unable to convert '%s'.", fileToConvert.getAbsolutePath());
        }
        boolean firstRenameOK = inProgressFile.renameTo(convertedFile);
        if (!firstRenameOK) {
            return this.createStatus("Unable to rename '%s' to '%s'.", inProgressFile.getAbsolutePath(), convertedFile.getAbsolutePath());
        }
        boolean removalOfOriginalOK = fileToConvert.delete();
        if (!removalOfOriginalOK) {
            return this.createStatus("Unable to delete original file '%s'", fileToConvert.getAbsolutePath());
        }
        boolean secondRenameOK = convertedFile.renameTo(fileToConvert);
        if (!secondRenameOK) {
            return this.createStatus("Unable to rename '%s' to '%s'.", convertedFile.getAbsolutePath(), fileToConvert.getAbsolutePath());
        }
        return Status.OK;
    }

    private Status deleteOriginalFileIfRequestedAndGetStatus(File fileToConvert, boolean deleteOriginalFile) {
        if (deleteOriginalFile && fileToConvert.exists()) {
            return this.deleteOriginalFile(fileToConvert);
        }
        return Status.OK;
    }

    private Status deleteOriginalFile(File fileToConvert) {
        boolean ok = fileToConvert.delete();
        if (ok) {
            operationLog.info(String.format("Clean up: successfully deleting temporary file '%s'", fileToConvert.getAbsolutePath()));
            return Status.OK;
        }
        return this.createStatus("Clean up: Unable to delete temporary file '%s'", fileToConvert.getAbsolutePath());
    }
}

