/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.config.RetryConfiguration;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.generic.server.EncapsulatedFilteredBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.server.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ManagedAuthentication;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.OpenBisServiceFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetShareId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.IQueryApiServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;

public final class EncapsulatedOpenBISService
implements IEncapsulatedOpenBISService,
FactoryBean {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, EncapsulatedOpenBISService.class);
    private final IServiceForDataStoreServer service;
    private Integer version;
    private DatabaseInstance homeDatabaseInstance;
    private OpenBISSessionHolder session;
    private IShareIdManager shareIdManager;
    private IServiceConversationClientManagerLocal conversationClient;

    public static IServiceForDataStoreServer createOpenBisService(String openBISURL, String timeout) {
        return (IServiceForDataStoreServer)new RetryingOpenBisCreator(openBISURL, timeout).callWithRetry();
    }

    public static IGeneralInformationService createGeneralInformationService(String openBISURL, String timeout) {
        ServiceFinder finder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        if (timeout.startsWith("$")) {
            return finder.createService(IGeneralInformationService.class, openBISURL);
        }
        return finder.createService(IGeneralInformationService.class, openBISURL, EncapsulatedOpenBISService.normalizeTimeout(timeout));
    }

    public static IQueryApiServer createQueryApiServer(String openBISURL, String timeout) {
        ServiceFinder finder = new ServiceFinder("openbis", "/rmi-query-v1");
        if (timeout.startsWith("$")) {
            return finder.createService(IQueryApiServer.class, openBISURL);
        }
        return finder.createService(IQueryApiServer.class, openBISURL, EncapsulatedOpenBISService.normalizeTimeout(timeout));
    }

    private static long normalizeTimeout(String timeout) {
        return (long)Integer.parseInt(timeout) * 60000L;
    }

    public EncapsulatedOpenBISService(IServiceForDataStoreServer service, OpenBISSessionHolder sessionHolder, String downloadUrl) {
        this(service, sessionHolder, downloadUrl, null);
    }

    public EncapsulatedOpenBISService(IServiceForDataStoreServer service, OpenBISSessionHolder sessionHolder, String downloadUrl, IShareIdManager shareIdManager) {
        this.shareIdManager = shareIdManager;
        assert (service != null) : "Given IETLLIMSService implementation can not be null.";
        assert (sessionHolder != null) : "Given OpenBISSessionHolder can not be null.";
        this.service = service;
        this.session = sessionHolder;
    }

    @Override
    public IEncapsulatedBasicOpenBISService getBasicFilteredOpenBISService(String user) {
        return new EncapsulatedFilteredBasicOpenBISService(user, this.service, this, this.session.getSessionToken());
    }

    private IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    public Object getObject() throws Exception {
        return this;
    }

    public Class getObjectType() {
        return IEncapsulatedOpenBISService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public Experiment tryGetExperiment(ExperimentIdentifier experimentIdentifier) {
        assert (experimentIdentifier != null) : " Unspecified experiment identifier.";
        return this.service.tryGetExperiment(this.session.getSessionToken(), experimentIdentifier);
    }

    @Override
    public Space tryGetSpace(SpaceIdentifier spaceIdentifier) throws UserFailureException {
        assert (spaceIdentifier != null) : "Unspecified space identifier";
        return this.service.tryGetSpace(this.session.getSessionToken(), spaceIdentifier);
    }

    @Override
    public Project tryGetProject(ProjectIdentifier projectIdentifier) throws UserFailureException {
        assert (projectIdentifier != null) : "Unspecified project identifier";
        return this.service.tryGetProject(this.session.getSessionToken(), projectIdentifier);
    }

    @Override
    public List<Sample> listSamples(ListSampleCriteria criteria) {
        assert (criteria != null) : "Unspecifed criteria.";
        return this.service.listSamples(this.session.getSessionToken(), criteria);
    }

    @Override
    public final Sample tryGetSampleWithExperiment(SampleIdentifier sampleIdentifier) {
        assert (sampleIdentifier != null) : "Given sample identifier can not be null.";
        return this.service.tryGetSampleWithExperiment(this.session.getSessionToken(), sampleIdentifier);
    }

    @Override
    public SampleIdentifier tryGetSampleIdentifier(String samplePermID) throws UserFailureException {
        return this.service.tryGetSampleIdentifier(this.session.getSessionToken(), samplePermID);
    }

    @Override
    public Map<String, SampleIdentifier> listSampleIdentifiers(List<String> samplePermID) throws UserFailureException {
        return this.service.listSamplesByPermId(this.session.getSessionToken(), samplePermID);
    }

    @Override
    public ExperimentType getExperimentType(String experimentTypeCode) throws UserFailureException {
        return this.service.getExperimentType(this.session.getSessionToken(), experimentTypeCode);
    }

    @Override
    public Collection<VocabularyTerm> listVocabularyTerms(String vocabularyCode) throws UserFailureException {
        return this.service.listVocabularyTerms(this.session.getSessionToken(), vocabularyCode);
    }

    @Override
    public Vocabulary tryGetVocabulary(String code) {
        return this.service.tryGetVocabulary(this.session.getSessionToken(), code);
    }

    @Override
    public SampleType getSampleType(String sampleTypeCode) throws UserFailureException {
        return this.service.getSampleType(this.session.getSessionToken(), sampleTypeCode);
    }

    @Override
    public DataSetTypeWithVocabularyTerms getDataSetType(String dataSetTypeCode) {
        return this.service.getDataSetType(this.session.getSessionToken(), dataSetTypeCode);
    }

    @Override
    public List<AbstractExternalData> listDataSetsByExperimentID(long experimentID) throws UserFailureException {
        TechId id = new TechId(experimentID);
        return this.service.listDataSetsByExperimentID(this.session.getSessionToken(), id);
    }

    @Override
    public List<AbstractExternalData> listDataSetsBySampleID(long sampleID, boolean showOnlyDirectlyConnected) {
        TechId id = new TechId(sampleID);
        return this.service.listDataSetsBySampleID(this.session.getSessionToken(), id, showOnlyDirectlyConnected);
    }

    @Override
    public List<AbstractExternalData> listDataSetsByCode(List<String> dataSetCodes) throws UserFailureException {
        return this.service.listDataSetsByCode(this.session.getSessionToken(), dataSetCodes);
    }

    @Override
    public long registerExperiment(NewExperiment experiment) throws UserFailureException {
        assert (experiment != null) : "Unspecified experiment.";
        return this.service.registerExperiment(this.session.getSessionToken(), experiment);
    }

    @Override
    public void registerSamples(List<NewSamplesWithTypes> newSamples, String userIDOrNull) throws UserFailureException {
        assert (newSamples != null) : "Unspecified samples.";
        this.service.registerSamples(this.session.getSessionToken(), newSamples, userIDOrNull);
    }

    @Override
    public long registerSample(NewSample newSample, String userIDOrNull) throws UserFailureException {
        assert (newSample != null) : "Unspecified sample.";
        return this.service.registerSample(this.session.getSessionToken(), newSample, userIDOrNull);
    }

    @Override
    public void updateSample(SampleUpdatesDTO sampleUpdate) throws UserFailureException {
        assert (sampleUpdate != null) : "Unspecified sample.";
        this.service.updateSample(this.session.getSessionToken(), sampleUpdate);
    }

    @Override
    public final void registerDataSet(DataSetInformation dataSetInformation, NewExternalData data) {
        assert (dataSetInformation != null) : "missing sample identifier";
        assert (data != null) : "missing data";
        SampleIdentifier sampleIdentifier = dataSetInformation.getSampleIdentifier();
        if (sampleIdentifier == null) {
            ExperimentIdentifier experimentIdentifier = dataSetInformation.getExperimentIdentifier();
            this.service.registerDataSet(this.session.getSessionToken(), experimentIdentifier, data);
        } else {
            this.service.registerDataSet(this.session.getSessionToken(), sampleIdentifier, data);
        }
        this.setShareId(data);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Registered in openBIS: data set " + dataSetInformation.describe() + ".");
        }
    }

    @Override
    public final void updateDataSet(String code, List<NewProperty> properties, SpaceIdentifier space) throws UserFailureException {
        assert (code != null) : "missing data set code";
        assert (properties != null) : "missing data";
        assert (space != null) : "space missing";
        this.service.addPropertiesToDataSet(this.session.getSessionToken(), properties, code, space);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Updated in openBIS: data set " + code + ".");
        }
    }

    @Override
    public void updateShareIdAndSize(String dataSetCode, String shareId, long size) throws UserFailureException {
        this.service.updateShareIdAndSize(this.session.getSessionToken(), dataSetCode, shareId, size);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Updated in openBIS: data set " + dataSetCode + ", share Id: " + shareId + ", size: " + size);
        }
    }

    @Override
    public final void updateDataSetStatuses(List<String> codes, DataSetArchivingStatus newStatus, boolean presentInArchive) throws UserFailureException {
        assert (codes != null) : "missing data set codes";
        assert (newStatus != null) : "missing status";
        this.service.updateDataSetStatuses(this.session.getSessionToken(), codes, newStatus, presentInArchive);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Updated in openBIS: data sets " + codes + ", status=" + (Object)((Object)newStatus));
        }
    }

    @Override
    public boolean compareAndSetDataSetStatus(String dataSetCode, DataSetArchivingStatus oldStatus, DataSetArchivingStatus newStatus, boolean newPresentInArchive) throws UserFailureException {
        assert (dataSetCode != null) : "missing data set codes";
        assert (oldStatus != null) : "missing old status";
        assert (newStatus != null) : "missing new status";
        return this.service.compareAndSetDataSetStatus(this.session.getSessionToken(), dataSetCode, oldStatus, newStatus, newPresentInArchive);
    }

    @Override
    public IEntityProperty[] tryGetPropertiesOfSample(SampleIdentifier sampleIdentifier) throws UserFailureException {
        assert (sampleIdentifier != null) : "Given sample identifier can not be null.";
        return this.service.tryGetPropertiesOfSample(this.session.getSessionToken(), sampleIdentifier);
    }

    @Override
    public final IEntityProperty[] tryGetPropertiesOfTopSample(SampleIdentifier sampleIdentifier) throws UserFailureException {
        assert (sampleIdentifier != null) : "Given sample identifier can not be null.";
        return this.service.tryGetPropertiesOfSample(this.session.getSessionToken(), sampleIdentifier);
    }

    @Override
    public final List<Sample> listSamplesByCriteria(ListSamplesByPropertyCriteria criteria) throws UserFailureException {
        return this.service.listSamplesByCriteria(this.session.getSessionToken(), criteria);
    }

    @Override
    public final int getVersion() {
        if (this.version == null) {
            this.version = this.service.getVersion();
        }
        return this.version;
    }

    @Override
    public final DatabaseInstance getHomeDatabaseInstance() {
        if (this.homeDatabaseInstance == null) {
            this.homeDatabaseInstance = this.service.getHomeDatabaseInstance(this.session.getSessionToken());
        }
        return this.homeDatabaseInstance;
    }

    @Override
    public final String createPermId() {
        return this.service.createPermId(this.session.getSessionToken());
    }

    @Override
    public final List<String> createPermIds(int n) {
        return this.service.createPermIds(this.session.getSessionToken(), n);
    }

    @Override
    public long drawANewUniqueID() {
        return this.service.drawANewUniqueID(this.session.getSessionToken());
    }

    @Override
    public IDatasetLocationNode tryGetDataSetLocation(String dataSetCode) throws UserFailureException {
        return this.service.tryGetDataSetLocation(this.session.getSessionToken(), dataSetCode);
    }

    @Override
    public AbstractExternalData tryGetDataSet(String dataSetCode) throws UserFailureException {
        return this.service.tryGetDataSet(this.session.getSessionToken(), dataSetCode);
    }

    @Override
    public AbstractExternalData tryGetThinDataSet(String dataSetCode) throws UserFailureException {
        return this.service.tryGetThinDataSet(this.session.getSessionToken(), dataSetCode);
    }

    @Override
    public AbstractExternalData tryGetLocalDataSet(String dataSetCode) throws UserFailureException {
        return this.service.tryGetLocalDataSet(this.session.getSessionToken(), dataSetCode, this.session.getDataStoreCode());
    }

    @Override
    public AbstractExternalData tryGetDataSet(String sToken, String dataSetCode) throws UserFailureException {
        return this.service.tryGetDataSet(sToken, dataSetCode);
    }

    @Override
    public void checkInstanceAdminAuthorization(String sToken) throws UserFailureException {
        this.service.checkInstanceAdminAuthorization(sToken);
    }

    @Override
    public void checkSpacePowerUserAuthorization(String sessionToken) throws UserFailureException {
        this.service.checkSpacePowerUserAuthorization(sessionToken);
    }

    @Override
    public void checkDataSetAccess(String sToken, String dataSetCode) throws UserFailureException {
        this.service.checkDataSetAccess(sToken, dataSetCode);
    }

    @Override
    public void checkDataSetCollectionAccess(String sToken, List<String> dataSetCodes) throws UserFailureException {
        this.service.checkDataSetCollectionAccess(sToken, dataSetCodes);
    }

    @Override
    public void checkSpaceAccess(String sToken, SpaceIdentifier spaceId) {
        this.service.checkSpaceAccess(sToken, spaceId);
    }

    @Override
    public List<DataSetShareId> listDataSetShareIds() throws UserFailureException {
        List<DataSetShareId> shareIds = this.service.listShareIds(this.session.getSessionToken(), this.session.getDataStoreCode());
        for (DataSetShareId dataSetShareId : shareIds) {
            if (dataSetShareId.getShareId() != null) continue;
            dataSetShareId.setShareId("1");
        }
        return shareIds;
    }

    @Override
    public List<SimpleDataSetInformationDTO> listPhysicalDataSets() throws UserFailureException {
        List<SimpleDataSetInformationDTO> dataSets = this.service.listPhysicalDataSets(this.session.getSessionToken(), this.session.getDataStoreCode());
        return this.injectDefaultShareIdIfMissing(dataSets);
    }

    @Override
    public List<SimpleDataSetInformationDTO> listOldestPhysicalDataSets(int chunkSize) throws UserFailureException {
        List<SimpleDataSetInformationDTO> dataSets = this.service.listOldestPhysicalDataSets(this.session.getSessionToken(), this.session.getDataStoreCode(), chunkSize);
        return this.injectDefaultShareIdIfMissing(dataSets);
    }

    @Override
    public List<SimpleDataSetInformationDTO> listOldestPhysicalDataSets(Date youngerThan, int chunkSize) throws UserFailureException {
        List<SimpleDataSetInformationDTO> dataSets = this.service.listOldestPhysicalDataSets(this.session.getSessionToken(), this.session.getDataStoreCode(), youngerThan, chunkSize);
        return this.injectDefaultShareIdIfMissing(dataSets);
    }

    private List<SimpleDataSetInformationDTO> injectDefaultShareIdIfMissing(List<SimpleDataSetInformationDTO> dataSets) {
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            if (dataSet.getDataSetShareId() != null) continue;
            dataSet.setDataSetShareId("1");
        }
        return dataSets;
    }

    @Override
    public List<AbstractExternalData> listNewerDataSets(TrackingDataSetCriteria criteria) throws UserFailureException {
        return this.service.listDataSets(this.session.getSessionToken(), this.session.getDataStoreCode(), criteria);
    }

    @Override
    public List<AbstractExternalData> listAvailableDataSets(ArchiverDataSetCriteria criteria) throws UserFailureException {
        return this.service.listAvailableDataSets(this.session.getSessionToken(), this.session.getDataStoreCode(), criteria);
    }

    @Override
    public List<DeletedDataSet> listDeletedDataSets(Long lastSeenDeletionEventIdOrNull, Date maxDeletionDataOrNull) {
        return this.service.listDeletedDataSets(this.session.getSessionToken(), lastSeenDeletionEventIdOrNull, maxDeletionDataOrNull);
    }

    @Override
    public void archiveDataSets(List<String> dataSetCodes, boolean removeFromDataStore) throws UserFailureException {
        this.service.archiveDatasets(this.session.getSessionToken(), dataSetCodes, removeFromDataStore);
    }

    @Override
    public void unarchiveDataSets(List<String> dataSetCodes) throws UserFailureException {
        this.service.unarchiveDatasets(this.session.getSessionToken(), dataSetCodes);
    }

    @Override
    public SessionContextDTO tryGetSession(String sToken) {
        return this.service.tryGetSession(sToken);
    }

    @Override
    public void checkSession(String sessionToken) {
        this.service.checkSession(sessionToken);
    }

    @Override
    public List<String> generateCodes(String prefix, ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind entityKind, int size) {
        return this.service.generateCodes(this.session.getSessionToken(), prefix, entityKind, size);
    }

    @Override
    public List<Person> listAdministrators() {
        return this.service.listAdministrators(this.session.getSessionToken());
    }

    @Override
    public Person tryPersonWithUserIdOrEmail(String useridOrEmail) {
        return this.service.tryPersonWithUserIdOrEmail(this.session.getSessionToken(), useridOrEmail);
    }

    @Override
    public Sample registerSampleAndDataSet(NewSample newSample, NewExternalData externalData, String userIdOrNull) throws UserFailureException {
        Sample sample = this.service.registerSampleAndDataSet(this.session.getSessionToken(), newSample, externalData, userIdOrNull);
        this.setShareId(externalData);
        return sample;
    }

    @Override
    public Sample updateSampleAndRegisterDataSet(SampleUpdatesDTO newSample, NewExternalData externalData) {
        Sample sample = this.service.updateSampleAndRegisterDataSet(this.session.getSessionToken(), newSample, externalData);
        this.setShareId(externalData);
        return sample;
    }

    @Override
    public AtomicEntityOperationResult performEntityOperations(AtomicEntityOperationDetails operationDetails) {
        IServiceForDataStoreServer conversationalService = this.conversationClient.getETLService(this.session.getSessionToken());
        AtomicEntityOperationResult operations = conversationalService.performEntityOperations(this.session.getSessionToken(), operationDetails);
        List<? extends NewExternalData> dataSets = operationDetails.getDataSetRegistrations();
        for (NewExternalData newExternalData : dataSets) {
            this.setShareId(newExternalData);
        }
        return operations;
    }

    private void setShareId(NewExternalData data) {
        this.getShareIdManager().setShareId(data.getCode(), data.getShareId());
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria) {
        return this.service.searchForSamples(this.session.getSessionToken(), searchCriteria);
    }

    @Override
    public List<AbstractExternalData> searchForDataSets(SearchCriteria searchCriteria) {
        return this.service.searchForDataSets(this.session.getSessionToken(), searchCriteria);
    }

    @Override
    public List<Project> listProjects() {
        return this.service.listProjects(this.session.getSessionToken());
    }

    @Override
    public List<Experiment> listExperiments(ProjectIdentifier projectIdentifier) {
        return this.service.listExperiments(this.session.getSessionToken(), projectIdentifier);
    }

    @Override
    public Material tryGetMaterial(MaterialIdentifier materialIdentifier) {
        return this.service.tryGetMaterial(this.session.getSessionToken(), materialIdentifier);
    }

    @Override
    public List<Material> listMaterials(ListMaterialCriteria criteria, boolean withProperties) {
        return this.service.listMaterials(this.session.getSessionToken(), criteria, withProperties);
    }

    @Override
    public Metaproject tryGetMetaproject(String name, String ownerId) {
        return this.service.tryGetMetaproject(this.session.getSessionToken(), name, ownerId);
    }

    @Override
    public void removeDataSetsPermanently(List<String> dataSetCodes, String reason) {
        this.service.removeDataSetsPermanently(this.session.getSessionToken(), dataSetCodes, reason);
    }

    @Override
    public void updateDataSet(DataSetUpdatesDTO dataSetUpdates) {
        this.service.updateDataSet(this.session.getSessionToken(), dataSetUpdates);
    }

    @Override
    public List<String> getTrustedCrossOriginDomains() {
        return this.service.getTrustedCrossOriginDomains(this.session.getSessionToken());
    }

    @Override
    public void setStorageConfirmed(String dataSetCode) {
        this.service.setStorageConfirmed(this.session.getSessionToken(), dataSetCode);
    }

    @Override
    public void markSuccessfulPostRegistration(String dataSetCode) {
        this.service.markSuccessfulPostRegistration(this.session.getSessionToken(), dataSetCode);
    }

    @Override
    public List<AbstractExternalData> listDataSetsForPostRegistration() {
        return this.service.listDataSetsForPostRegistration(this.session.getSessionToken(), this.session.getDataStoreCode());
    }

    @Override
    public EntityOperationsState didEntityOperationsSucceed(TechId registrationId) {
        return this.service.didEntityOperationsSucceed(this.session.getSessionToken(), registrationId);
    }

    @Override
    public void heartbeat() {
        this.service.heartbeat(this.session.getSessionToken());
    }

    @Override
    public boolean doesUserHaveRole(String user, String roleCode, String spaceOrNull) {
        return this.service.doesUserHaveRole(this.session.getSessionToken(), user, roleCode, spaceOrNull);
    }

    @Override
    public List<String> filterToVisibleDataSets(String user, List<String> dataSetCodes) {
        return this.service.filterToVisibleDataSets(this.session.getSessionToken(), user, dataSetCodes);
    }

    @Override
    public List<String> filterToVisibleExperiments(String user, List<String> experimentIds) {
        return this.service.filterToVisibleExperiments(this.session.getSessionToken(), user, experimentIds);
    }

    @Override
    public List<String> filterToVisibleSamples(String user, List<String> sampleIdentifiers) {
        return this.service.filterToVisibleSamples(this.session.getSessionToken(), user, sampleIdentifiers);
    }

    @Override
    public ExternalDataManagementSystem tryGetExternalDataManagementSystem(String externalDataManagementSystemCode) {
        return this.service.tryGetExternalDataManagementSystem(this.session.getSessionToken(), externalDataManagementSystemCode);
    }

    public void setConversationClient(IServiceConversationClientManagerLocal conversationClient) {
        this.conversationClient = conversationClient;
    }

    @Override
    public List<? extends EntityTypePropertyType<?>> listPropertyDefinitionsForEntityType(String code, EntityKind entityKind) {
        return this.service.listPropertyDefinitionsForType(this.session.getSessionToken(), code, entityKind);
    }

    @Override
    public List<Metaproject> listMetaprojects() {
        throw new UnsupportedOperationException("Listing metaprojects is available only for the user-filtered version of service");
    }

    @Override
    public Metaproject tryGetMetaproject(String name) {
        throw new UnsupportedOperationException("Getting metaproject is available only for the user-filtered version of service");
    }

    @Override
    @ManagedAuthentication
    public MetaprojectAssignments getMetaprojectAssignments(String name) {
        throw new UnsupportedOperationException("getting metaproject assignments is available only for the user-filtered version of service");
    }

    @Override
    @ManagedAuthentication
    public List<Metaproject> listMetaprojectsForEntity(IObjectId entityId) {
        throw new UnsupportedOperationException("Listing metaprojects is available only for the user-filtered version of service");
    }

    @Override
    public List<AuthorizationGroup> listAuthorizationGroups() {
        return this.service.listAuthorizationGroups(this.session.getSessionToken());
    }

    @Override
    public List<AuthorizationGroup> listAuthorizationGroupsForUser(String userId) {
        return this.service.listAuthorizationGroupsForUser(this.session.getSessionToken(), userId);
    }

    @Override
    public List<Person> listUsersForAuthorizationGroup(TechId authorizationGroupId) {
        return this.service.listUsersForAuthorizationGroup(this.session.getSessionToken(), authorizationGroupId);
    }

    @Override
    public List<RoleAssignment> listRoleAssignments() {
        return this.service.listRoleAssignments(this.session.getSessionToken());
    }

    @Override
    public List<Attachment> listAttachments(AttachmentHolderKind attachmentHolderKind, Long attachmentHolderId) {
        return this.service.listAttachments(this.session.getSessionToken(), attachmentHolderKind, attachmentHolderId);
    }

    @Override
    public InputStream getAttachmentContent(AttachmentHolderKind attachmentHolderKind, Long attachmentHolderId, String fileName, Integer versionOrNull) {
        AttachmentWithContent attachment = this.service.getAttachment(this.session.getSessionToken(), attachmentHolderKind, attachmentHolderId, fileName, versionOrNull);
        return attachment != null ? new ByteArrayInputStream(attachment.getContent()) : null;
    }

    private static class RetryingOpenBisCreator
    extends RetryCaller<IServiceForDataStoreServer, RuntimeException> {
        private final String openBISURL;
        private String timeout;

        RetryingOpenBisCreator(String openBISURL, String timeout) {
            super(new RetryConfiguration(){

                @Override
                public float getWaitingTimeBetweenRetriesIncreasingFactor() {
                    return 2.0f;
                }

                @Override
                public int getWaitingTimeBetweenRetries() {
                    return 5000;
                }

                @Override
                public int getMaximumNumberOfRetries() {
                    return 5;
                }
            }, new Log4jSimpleLogger(operationLog));
            this.openBISURL = openBISURL;
            this.timeout = timeout;
        }

        @Override
        protected boolean isRetryableException(RuntimeException e) {
            return true;
        }

        @Override
        protected IServiceForDataStoreServer call() throws RuntimeException {
            OpenBisServiceFactory factory = new OpenBisServiceFactory(this.openBISURL, "/rmi-etl");
            IServiceForDataStoreServer service = null;
            service = this.timeout.startsWith("$") ? factory.createService() : factory.createService(EncapsulatedOpenBISService.normalizeTimeout(this.timeout));
            return service;
        }
    }
}

