/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.openbis.dss.generic.server.graph.AbstractTabularDataGraph;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataScatterplotConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TabularDataScatterplot
extends AbstractTabularDataGraph<TabularDataScatterplotConfiguration> {
    public TabularDataScatterplot(TabularDataScatterplotConfiguration configuration, ITabularData fileLines, OutputStream out) {
        super(configuration, fileLines, out);
    }

    protected XYDataset tryCreateChartDataset() {
        final XYSeries series = new XYSeries((Comparable)((Object)this.getTitle()));
        boolean success = this.tryIterateOverFileLinesUsing(new AbstractTabularDataGraph.ILineProcessor(){

            @Override
            public void processLine(String xString, String yString, int index) {
                double x = TabularDataScatterplot.parseDouble(xString);
                double y = TabularDataScatterplot.parseDouble(yString);
                series.add(x, y);
            }
        });
        if (!success) {
            return null;
        }
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        return dataset;
    }

    @Override
    protected JFreeChart createDataChart(Dataset dataset) {
        JFreeChart chart = ChartFactory.createScatterPlot((String)this.getTitle(), (String)this.getXAxisLabel(), (String)this.getYAxisLabel(), (XYDataset)((XYDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        return chart;
    }

    @Override
    protected void configureChart(JFreeChart chart, int imageWidth, int imageHeight) {
        float width;
        super.configureChart(chart, imageWidth, imageHeight);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        float height = width = (float)Math.max(1, imageWidth / 300);
        Ellipse2D.Float plotShape = new Ellipse2D.Float(0.0f, 0.0f, width, height);
        renderer.setSeriesShape(0, (Shape)plotShape);
    }
}

