/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.MJPBCodecOptions;

public class MJPBCodec
extends BaseCodec {
    private static final byte[] HEADER = new byte[]{-1, -40, 0, 16, 74, 70, 73, 70, 0, 1, 1, 0, 72, 72, 0, 0};

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("Motion JPEG-B compression not supported.");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (!(options instanceof MJPBCodecOptions)) {
            throw new FormatException("Options must be an instance of loci.formats.codec.MJPBCodecOptions");
        }
        byte[] raw = null;
        byte[] raw2 = null;
        long fp = in.getFilePointer();
        try {
            in.skipBytes(4);
            byte[] lumDcBits = null;
            byte[] lumAcBits = null;
            byte[] lumDc = null;
            byte[] lumAc = null;
            byte[] quant = null;
            String s1 = in.readString(4);
            in.skipBytes(12);
            String s2 = in.readString(4);
            in.seek(in.getFilePointer() - 4L);
            if (s1.equals("mjpg") || s2.equals("mjpg")) {
                int extra = 16;
                if (s1.startsWith("m")) {
                    extra = 0;
                    in.seek(fp + 4L);
                }
                in.skipBytes(12);
                int offset = in.readInt() + extra;
                int quantOffset = in.readInt() + extra;
                int huffmanOffset = in.readInt() + extra;
                int sof = in.readInt() + extra;
                int sos = in.readInt() + extra;
                int sod = in.readInt() + extra;
                if (quantOffset != 0 && (long)quantOffset + fp < in.length()) {
                    in.seek(fp + (long)quantOffset);
                    in.skipBytes(3);
                    quant = new byte[64];
                    in.read(quant);
                } else {
                    quant = new byte[]{7, 5, 5, 6, 5, 5, 7, 6, 6, 6, 8, 7, 7, 8, 10, 17, 11, 10, 9, 9, 10, 20, 15, 15, 12, 17, 24, 21, 25, 25, 23, 21, 23, 23, 26, 29, 37, 32, 26, 28, 35, 28, 23, 23, 33, 44, 33, 35, 39, 40, 42, 42, 42, 25, 31, 46, 49, 45, 41, 49, 37, 41, 42, 40};
                }
                if (huffmanOffset != 0 && (long)huffmanOffset + fp < in.length()) {
                    in.seek(fp + (long)huffmanOffset);
                    in.skipBytes(3);
                    lumDcBits = new byte[16];
                    in.read(lumDcBits);
                    lumDc = new byte[12];
                    in.read(lumDc);
                    in.skipBytes(1);
                    lumAcBits = new byte[16];
                    in.read(lumAcBits);
                    int sum = 0;
                    for (int i = 0; i < lumAcBits.length; ++i) {
                        sum += lumAcBits[i] & 0xFF;
                    }
                    lumAc = new byte[sum];
                    in.read(lumAc);
                }
                in.seek(fp + (long)sof + 7L);
                int channels = in.read() & 0xFF;
                int[] sampling = new int[channels];
                for (int i = 0; i < channels; ++i) {
                    in.skipBytes(1);
                    sampling[i] = in.read();
                    in.skipBytes(1);
                }
                in.seek(fp + (long)sos + 3L);
                int[] tables = new int[channels];
                for (int i = 0; i < channels; ++i) {
                    in.skipBytes(1);
                    tables[i] = in.read();
                }
                in.seek(fp + (long)sod);
                int numBytes = (int)((long)offset - in.getFilePointer());
                if (offset == 0) {
                    numBytes = (int)(in.length() - in.getFilePointer());
                }
                raw = new byte[numBytes];
                in.read(raw);
                if (offset != 0) {
                    in.seek(fp + (long)offset + 36L);
                    int n = in.readInt();
                    in.skipBytes(n);
                    in.seek(in.getFilePointer() - 40L);
                    numBytes = (int)(in.length() - in.getFilePointer());
                    raw2 = new byte[numBytes];
                    in.read(raw2);
                }
            }
            ByteVector b = new ByteVector();
            for (int i = 0; i < raw.length; ++i) {
                b.add((byte)raw[i]);
                if (raw[i] != -1) continue;
                b.add((byte)0);
            }
            if (raw2 == null) {
                raw2 = new byte[]{};
            }
            ByteVector b2 = new ByteVector();
            for (int i = 0; i < raw2.length; ++i) {
                b2.add(raw2[i]);
                if (raw2[i] != -1) continue;
                b2.add((byte)0);
            }
            ByteVector v = new ByteVector(1000);
            v.add(HEADER);
            v.add(new byte[]{-1, -37});
            int length = 4 + quant.length * 2;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            v.add((byte)0);
            v.add(quant);
            v.add((byte)1);
            v.add(quant);
            v.add(new byte[]{-1, -60});
            length = (lumDcBits.length + lumDc.length + lumAcBits.length + lumAc.length) * 2 + 6;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            v.add((byte)0);
            v.add(lumDcBits);
            v.add(lumDc);
            v.add((byte)1);
            v.add(lumDcBits);
            v.add(lumDc);
            v.add((byte)16);
            v.add(lumAcBits);
            v.add(lumAc);
            v.add((byte)17);
            v.add(lumAcBits);
            v.add(lumAc);
            v.add((byte)-1);
            v.add((byte)-64);
            length = options.bitsPerSample >= 40 ? 11 : 17;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            int fieldHeight = options.height;
            if (((MJPBCodecOptions)options).interlaced) {
                fieldHeight /= 2;
            }
            if (options.height % 2 == 1) {
                ++fieldHeight;
            }
            int c = options.bitsPerSample == 24 ? 3 : (options.bitsPerSample == 32 ? 4 : 1);
            v.add(options.bitsPerSample >= 40 ? (byte)(options.bitsPerSample - 32) : (byte)(options.bitsPerSample / c));
            v.add((byte)(fieldHeight >>> 8 & 0xFF));
            v.add((byte)(fieldHeight & 0xFF));
            v.add((byte)(options.width >>> 8 & 0xFF));
            v.add((byte)(options.width & 0xFF));
            v.add(options.bitsPerSample >= 40 ? (byte)1 : 3);
            v.add((byte)1);
            v.add((byte)33);
            v.add((byte)0);
            if (options.bitsPerSample < 40) {
                v.add((byte)2);
                v.add((byte)17);
                v.add((byte)1);
                v.add((byte)3);
                v.add((byte)17);
                v.add((byte)1);
            }
            v.add((byte)-1);
            v.add((byte)-38);
            length = options.bitsPerSample >= 40 ? 8 : 12;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            v.add(options.bitsPerSample >= 40 ? (byte)1 : 3);
            v.add((byte)1);
            v.add((byte)0);
            if (options.bitsPerSample < 40) {
                v.add((byte)2);
                v.add((byte)1);
                v.add((byte)3);
                v.add((byte)1);
            }
            v.add((byte)0);
            v.add((byte)63);
            v.add((byte)0);
            if (((MJPBCodecOptions)options).interlaced) {
                ByteVector v2 = new ByteVector(v.size());
                v2.add(v.toByteArray());
                v.add(b.toByteArray());
                v.add((byte)-1);
                v.add((byte)-39);
                v2.add(b2.toByteArray());
                v2.add((byte)-1);
                v2.add((byte)-39);
                JPEGCodec jpeg = new JPEGCodec();
                byte[] top = jpeg.decompress(v.toByteArray(), options);
                byte[] bottom = jpeg.decompress(v2.toByteArray(), options);
                int bpp = options.bitsPerSample < 40 ? options.bitsPerSample / 8 : (options.bitsPerSample - 32) / 8;
                int ch = options.bitsPerSample < 40 ? 3 : 1;
                byte[] result = new byte[options.width * options.height * bpp * ch];
                int topNdx = 0;
                int bottomNdx = 0;
                int row = options.width * bpp;
                for (int yy = 0; yy < options.height; ++yy) {
                    if (yy % 2 == 0 && (topNdx + 1) * row <= top.length) {
                        System.arraycopy(top, topNdx * row, result, yy * row, row);
                        ++topNdx;
                        continue;
                    }
                    if ((bottomNdx + 1) * row <= bottom.length) {
                        System.arraycopy(bottom, bottomNdx * row, result, yy * row, row);
                    }
                    ++bottomNdx;
                }
                return result;
            }
            v.add(b.toByteArray());
            v.add((byte)-1);
            v.add((byte)-39);
            return new JPEGCodec().decompress(v.toByteArray(), options);
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
    }
}

