/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.datatype.DateRange;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetCache;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.unidata.geoloc.LatLonRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridDataset
implements ucar.nc2.dt.GridDataset {
    private NetcdfDataset ds;
    private ArrayList<GeoGrid> grids = new ArrayList();
    private Map<String, Gridset> gridsetHash = new HashMap<String, Gridset>();
    private LatLonRect llbbMax = null;
    private DateRange dateRangeMax = null;
    private StringBuffer parseInfo = new StringBuffer();

    public static GridDataset open(String netcdfFileURI) throws IOException {
        NetcdfDataset ds = NetcdfDatasetCache.acquire(netcdfFileURI, null);
        return new GridDataset(ds);
    }

    public GridDataset(NetcdfDataset ds) {
        this.ds = ds;
        this.parseInfo.append("GridDataset look for GeoGrids\n");
        List<Variable> vars = ds.getVariables();
        for (Variable var : vars) {
            VariableEnhanced varDS = (VariableEnhanced)((Object)var);
            this.constructCoordinateSystems(ds, varDS);
        }
    }

    private void constructCoordinateSystems(NetcdfDataset ds, VariableEnhanced v) {
        if (v instanceof StructureDS) {
            StructureDS s = (StructureDS)v;
            List<Variable> members = s.getVariables();
            for (Variable nested : members) {
                this.constructCoordinateSystems(ds, (VariableEnhanced)((Object)nested));
            }
        } else {
            GridCoordSys gcs = null;
            List<CoordinateSystem> csys = v.getCoordinateSystems();
            for (CoordinateSystem cs : csys) {
                GridCoordSys gcsTry = GridCoordSys.makeGridCoordSys(this.parseInfo, cs, v);
                if (gcsTry == null) continue;
                gcs = gcsTry;
                if (!gcsTry.isProductSet()) continue;
                break;
            }
            if (gcs != null) {
                this.addGeoGrid(v, gcs);
            }
        }
    }

    private void makeRanges() {
        for (GridDataset.Gridset gset : this.getGridsets()) {
            DateRange dateRange;
            GridCoordSystem gcs = gset.getGeoCoordSystem();
            LatLonRect llbb = gcs.getLatLonBoundingBox();
            if (this.llbbMax == null) {
                this.llbbMax = llbb;
            } else {
                this.llbbMax.extend(llbb);
            }
            if ((dateRange = gcs.getDateRange()) == null) continue;
            if (this.dateRangeMax == null) {
                this.dateRangeMax = dateRange;
                continue;
            }
            this.dateRangeMax.extend(dateRange);
        }
    }

    @Override
    public String getTitle() {
        String title = this.ds.findAttValueIgnoreCase(null, "title", null);
        return title == null ? this.getName() : title;
    }

    @Override
    public String getDescription() {
        String desc = this.ds.findAttValueIgnoreCase(null, "description", null);
        if (desc == null) {
            desc = this.ds.findAttValueIgnoreCase(null, "history", null);
        }
        return desc == null ? this.getName() : desc;
    }

    @Override
    public String getLocationURI() {
        return this.ds.getLocation();
    }

    @Override
    public Date getStartDate() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getStart().getDate();
    }

    @Override
    public Date getEndDate() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getEnd().getDate();
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.llbbMax == null) {
            this.makeRanges();
        }
        return this.llbbMax;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.ds.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ds.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        return new ArrayList<VariableSimpleIF>(this.ds.getVariables());
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        return this.ds.findTopVariable(shortName);
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.ds;
    }

    @Override
    public void close() throws IOException {
        this.ds.close();
    }

    private void addGeoGrid(VariableEnhanced varDS, GridCoordSys gcs) {
        Gridset gridset = this.gridsetHash.get(gcs.getName());
        if (null == gridset) {
            gridset = new Gridset(gcs);
            this.gridsetHash.put(gcs.getName(), gridset);
            this.parseInfo.append(" -make new GridCoordSys= ").append(gcs.getName()).append("\n");
            gcs.makeVerticalTransform(this, this.parseInfo);
        }
        GeoGrid geogrid = new GeoGrid(this, varDS, gridset.gcc);
        this.grids.add(geogrid);
        gridset.add(geogrid);
    }

    public String getName() {
        return this.ds.getLocation();
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    @Override
    public List<GridDatatype> getGrids() {
        return new ArrayList<GridDatatype>(this.grids);
    }

    @Override
    public GridDatatype findGridDatatype(String name) {
        return this.findGridByName(name);
    }

    @Override
    public List<GridDataset.Gridset> getGridsets() {
        return new ArrayList<GridDataset.Gridset>(this.gridsetHash.values());
    }

    public GeoGrid findGridByName(String name) {
        for (GeoGrid ggi : this.grids) {
            if (!name.equals(ggi.getName())) continue;
            return ggi;
        }
        return null;
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer(20000);
        int countGridset = 0;
        buf.setLength(0);
        for (Gridset gs : this.gridsetHash.values()) {
            buf.append("\nGridset ").append(countGridset).append(" coordSys ").append(gs.getGeoCoordSystem()).append("\n");
            buf.append("Name___________Unit___________hasMissing_____Description\n");
            for (GeoGrid grid : this.grids) {
                buf.append(grid.getInfo());
                buf.append("\n");
            }
            ++countGridset;
            buf.append("\n");
        }
        buf.append("\nGeoReferencing Coordinate Axes\n");
        buf.append("Name___________Len__Unit________________Type___Description\n");
        for (CoordinateAxis axis : this.ds.getCoordinateAxes()) {
            if (axis.getAxisType() == null) continue;
            buf.append(axis.getInfo());
            buf.append("\n");
        }
        return buf.toString();
    }

    public StringBuffer getParseInfo() {
        return this.parseInfo;
    }

    @Override
    public String getDetailInfo() {
        StringBuffer buff = new StringBuffer(5000);
        buff.append(this.ds.toString());
        buff.append("\n\n----------------------------------------------------\n");
        buff.append(this.getInfo());
        buff.append("\n\n----------------------------------------------------\n");
        buff.append(this.ds.getInfo().getParseInfo());
        buff.append("\n\n----------------------------------------------------\n");
        buff.append(this.parseInfo.toString());
        return buff.toString();
    }

    public static GridDataset factory(String netcdfFileURI) throws IOException {
        return GridDataset.open(netcdfFileURI);
    }

    public static void main(String[] arg) {
        String defaultFilename = "R:/testdata/grid/netcdf/cf/mississippi.nc";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        try {
            GridDataset gridDs = GridDataset.open(filename);
            String outFilename = "C:/data/writeGrid.nc";
            GeoGrid gg = gridDs.findGridByName("cape_sfc");
            gg.writeFile(outFilename);
            gridDs = GridDataset.open(outFilename);
            System.out.println(gridDs.getDetailInfo());
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Gridset
    implements GridDataset.Gridset {
        private GridCoordSys gcc;
        private List<GridDatatype> grids = new ArrayList<GridDatatype>();

        private Gridset(GridCoordSys gcc) {
            this.gcc = gcc;
        }

        private void add(GeoGrid grid) {
            this.grids.add(grid);
        }

        @Override
        public List<GridDatatype> getGrids() {
            return this.grids;
        }

        @Override
        public GridCoordSystem getGeoCoordSystem() {
            return this.gcc;
        }

        public GridCoordSys getGeoCoordSys() {
            return this.gcc;
        }
    }
}

