/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.highwatermark;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.NonHangingFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.highwatermark.HostAwareFileWithHighwaterMark;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.CallableExecutor;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public final class HighwaterMarkWatcher
implements Runnable {
    private static final String UNSPECIFIED = "unspecified";
    private static final IFreeSpaceProvider DEFAULT_FREE_SPACE_PROVIDER = new NonHangingFreeSpaceProvider(new SimpleFreeSpaceProvider());
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HighwaterMarkWatcher.class);
    private final long highwaterMarkInKb;
    private final EventListenerList listenerList = new EventListenerList();
    private HostAwareFile path;
    private HighwaterMarkState highwaterMarkState;
    private final IFreeSpaceProvider freeSpaceProvider;

    public HighwaterMarkWatcher(long highwaterMarkInKb) {
        this(highwaterMarkInKb, DEFAULT_FREE_SPACE_PROVIDER);
    }

    public HighwaterMarkWatcher(long highwaterMarkInKb, IFreeSpaceProvider freeSpaceProvider) {
        assert (freeSpaceProvider != null) : "Unspecified IFreeSpaceProvider";
        this.highwaterMarkInKb = highwaterMarkInKb;
        this.freeSpaceProvider = freeSpaceProvider;
        this.addChangeListener(new NotificationLogChangeListener());
    }

    private final void fireChangeListeners(HighwaterMarkEvent highwaterMarkEvent) {
        ChangeListener[] listeners;
        ChangeListener[] changeListenerArray = listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener changeListener = changeListenerArray[n2];
            changeListener.stateChanged(highwaterMarkEvent);
            ++n2;
        }
    }

    public static final String displayKilobyteValue(long value) {
        if (value < 0L) {
            return UNSPECIFIED;
        }
        return FileUtilities.byteCountToDisplaySize(value * 1024L);
    }

    public static final boolean isBelow(HighwaterMarkState highwaterMarkState) {
        assert (highwaterMarkState != null) : "Unspecified WatermarkState";
        return highwaterMarkState.freeSpace < highwaterMarkState.getHighwaterMark();
    }

    public final synchronized void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null) : "Unspecified ChangeListener";
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null) : "Unspecified ChangeListener";
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public final synchronized boolean isBelow() {
        return this.highwaterMarkState == null ? false : HighwaterMarkWatcher.isBelow(this.highwaterMarkState);
    }

    public final synchronized void setPath(HostAwareFile path) {
        this.path = path;
    }

    public final synchronized HostAwareFile getPath() {
        return this.path;
    }

    public final synchronized void setPathAndRun(HostAwareFile path) {
        this.setPath(path);
        this.run();
    }

    public final HighwaterMarkState getHighwaterMarkState(final HostAwareFile file) throws EnvironmentFailureException {
        assert (file != null) : "Unspecified file";
        String errorMsg = String.format("Could not compute available free space for '%s'.", file);
        Long freeSpaceInKb = new CallableExecutor(5, 10000L).executeCallable(new Callable<Long>(){

            @Override
            public final Long call() throws Exception {
                try {
                    return HighwaterMarkWatcher.this.freeSpaceProvider.freeSpaceKb(file);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        });
        if (freeSpaceInKb == null) {
            throw new EnvironmentFailureException(errorMsg);
        }
        return new HighwaterMarkState(new HostAwareFileWithHighwaterMark(file.tryGetHost(), file.getPath(), file.tryGetRsyncModule(), this.getLocalHighWaterMark(file)), freeSpaceInKb);
    }

    public final long getHighwaterMark() {
        return this.highwaterMarkInKb;
    }

    @Override
    public final synchronized void run() {
        assert (this.path != null) : "Unspecified path";
        if (this.getLocalHighWaterMark(this.path) < 0L) {
            return;
        }
        try {
            HighwaterMarkState state = this.getHighwaterMarkState(this.path);
            boolean newBelowValue = HighwaterMarkWatcher.isBelow(state);
            boolean stateChanged = this.isBelow() ^ newBelowValue;
            this.highwaterMarkState = state;
            if (stateChanged) {
                this.fireChangeListeners(new HighwaterMarkEvent(this, state));
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Free space on '%s': %s, highwater mark: %s.", state.hostAwareFileWithHighwaterMark.getPathDescription(), HighwaterMarkWatcher.displayKilobyteValue(state.freeSpace), HighwaterMarkWatcher.displayKilobyteValue(this.getLocalHighWaterMark(this.path))));
            }
        }
        catch (EnvironmentFailureException ex) {
            operationLog.error((Object)"The highwater mark watcher can not work properly due to an environment exception.", (Throwable)ex);
        }
    }

    private long getLocalHighWaterMark(HostAwareFile file) {
        return file instanceof HostAwareFileWithHighwaterMark ? ((HostAwareFileWithHighwaterMark)file).getHighwaterMark() : this.highwaterMarkInKb;
    }

    public static final class HighwaterMarkEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1L;
        private final HighwaterMarkState highwaterMarkState;

        HighwaterMarkEvent(Object source, HighwaterMarkState highwaterMarkState) {
            super(source);
            this.highwaterMarkState = highwaterMarkState;
        }

        public final boolean isBelow() {
            return HighwaterMarkWatcher.isBelow(this.highwaterMarkState);
        }

        public final String getPath() {
            return this.highwaterMarkState.hostAwareFileWithHighwaterMark.getPath();
        }

        public final long getFreeSpace() {
            return this.highwaterMarkState.freeSpace;
        }

        public final long getHighwaterMark() {
            return this.highwaterMarkState.hostAwareFileWithHighwaterMark.getHighwaterMark();
        }
    }

    public static final class HighwaterMarkState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final HostAwareFileWithHighwaterMark hostAwareFileWithHighwaterMark;
        private final long freeSpace;

        HighwaterMarkState(HostAwareFileWithHighwaterMark hostAwareFileWithHighwaterMark, Long freeSpace) {
            this.hostAwareFileWithHighwaterMark = hostAwareFileWithHighwaterMark;
            this.freeSpace = freeSpace;
        }

        public final String getPath() {
            return this.hostAwareFileWithHighwaterMark.getPath();
        }

        public final long getFreeSpace() {
            return this.freeSpace;
        }

        public final long getHighwaterMark() {
            return this.hostAwareFileWithHighwaterMark.getHighwaterMark();
        }
    }

    static final class NotificationLogChangeListener
    implements ChangeListener {
        static final String INFO_LOG_FORMAT = "Low space condition resolved on '%s', required: %s, found: %s, resuming operation.";
        static final String WARNING_LOG_FORMAT = "Highwater mark reached on '%s', required: %s, found: %s, missing: %s, suspending operation.";
        private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, NotificationLogChangeListener.class);

        NotificationLogChangeListener() {
        }

        @Override
        public final void stateChanged(ChangeEvent e) {
            HighwaterMarkEvent event = (HighwaterMarkEvent)e;
            String path = event.getPath();
            String highwaterMarkDisplayed = HighwaterMarkWatcher.displayKilobyteValue(event.getHighwaterMark());
            String freeSpaceDisplayed = HighwaterMarkWatcher.displayKilobyteValue(event.getFreeSpace());
            if (event.isBelow()) {
                String missingSpace = HighwaterMarkWatcher.displayKilobyteValue(event.getHighwaterMark() - event.getFreeSpace());
                notificationLog.warn((Object)String.format(WARNING_LOG_FORMAT, path, highwaterMarkDisplayed, freeSpaceDisplayed, missingSpace));
            } else {
                notificationLog.info((Object)String.format(INFO_LOG_FORMAT, path, highwaterMarkDisplayed, freeSpaceDisplayed));
            }
        }
    }
}

