/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.crowd;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.crowd.IRequestExecutor;
import ch.systemsx.cisd.authentication.crowd.SOAPAttributeContentHandler;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CrowdAuthenticationService
implements IAuthenticationService {
    private static final int CONNECTION_TIMEOUT = 300000;
    private static final String DUMMY_TOKEN_STR = "DUMMY-TOKEN";
    private static final String EMAIL_PROPERTY_KEY = "mail";
    private static final String LAST_NAME_PROPERTY_KEY = "sn";
    private static final String FIRST_NAME_PROPERTY_KEY = "givenName";
    private static final String ERROR_MSG_WITH_INVALID_APPLICATION_TOKEN = "The application.name or application.password in the crowd.properties file does not match the password in Crowd.";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CrowdAuthenticationService.class);
    @Private
    static final MessageFormat AUTHENTICATE_APPL = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soap:Body>\n   <authenticateApplication xmlns=\"urn:SecurityServer\">\n     <in0>\n       <credential xmlns=\"http://authentication.integration.crowd.atlassian.com\">\n         <credential>{1}</credential>\n       </credential>\n       <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</name>\n       <validationFactors xmlns=\"http://authentication.integration.crowd.atlassian.com\"                           xsi:nil=\"true\" />\n     </in0>\n   </authenticateApplication>\n </soap:Body>\n</soap:Envelope>\n");
    @Private
    static final MessageFormat AUTHENTICATE_USER = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soap:Body>\n   <authenticatePrincipal xmlns=\"urn:SecurityServer\">\n     <in0>\n       <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</name>\n       <token xmlns=\"http://authentication.integration.crowd.atlassian.com\">{1}</token>\n     </in0>\n     <in1>\n       <application xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</application>\n       <credential xmlns=\"http://authentication.integration.crowd.atlassian.com\">\n         <credential>{3}</credential>\n       </credential>\n       <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{2}</name>\n       <validationFactors xmlns=\"http://authentication.integration.crowd.atlassian.com\" />\n     </in1>\n   </authenticatePrincipal>\n </soap:Body>\n</soap:Envelope>\n");
    @Private
    static final MessageFormat FIND_PRINCIPAL_BY_NAME = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n   <soap:Body>\n       <findPrincipalByName xmlns=\"urn:SecurityServer\">\n           <in0>\n               <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</name>\n               <token xmlns=\"http://authentication.integration.crowd.atlassian.com\">{1}</token>\n           </in0>\n           <in1>{2}</in1>\n       </findPrincipalByName>\n   </soap:Body>\n</soap:Envelope>\n");
    private final String url;
    private final String application;
    private final String applicationPassword;
    private final IRequestExecutor requestExecutor;
    private final AtomicReference<String> applicationTokenHolder = new AtomicReference();

    private static IRequestExecutor createExecutor() {
        return new IRequestExecutor(){

            @Override
            public String execute(String serviceUrl, String message) {
                try {
                    HttpClient client = new HttpClient();
                    PostMethod post = new PostMethod(serviceUrl);
                    post.getParams().setSoTimeout(300000);
                    StringRequestEntity entity = new StringRequestEntity(message, "application/soap+xml", "utf-8");
                    post.setRequestEntity((RequestEntity)entity);
                    String response = null;
                    try {
                        client.executeMethod((HttpMethod)post);
                        response = post.getResponseBodyAsString();
                    }
                    finally {
                        post.releaseConnection();
                    }
                    return response;
                }
                catch (Exception ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        };
    }

    public CrowdAuthenticationService(String host, String port, String application, String applicationPassword) {
        this("https://" + host + ":" + CrowdAuthenticationService.checkPort(port) + "/crowd/services/SecurityServer", application, applicationPassword, CrowdAuthenticationService.createExecutor());
    }

    CrowdAuthenticationService(String url, String application, String applicationPassword, IRequestExecutor requestExecutor) {
        this.url = url;
        this.application = application;
        this.applicationPassword = applicationPassword;
        this.requestExecutor = requestExecutor;
        if (operationLog.isDebugEnabled()) {
            String msg = "A new CrowdAuthenticationService instance has been created for [url=" + url + ", application=" + application + "]";
            operationLog.debug((Object)msg);
        }
    }

    private static String checkPort(String portStr) throws ConfigurationFailureException {
        try {
            if (portStr != null && !portStr.startsWith("${") && Integer.parseInt(portStr) <= 0) {
                throw ConfigurationFailureException.fromTemplate("Illegal port '%s'", portStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConfigurationFailureException.fromTemplate("Illegal port '%s'", portStr);
        }
        return portStr;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public final void check() throws EnvironmentFailureException, ConfigurationFailureException {
        try {
            String xmlResponse = this.executeAuthenticateApplication();
            String applicationToken = StringEscapeUtils.unescapeXml((String)CrowdAuthenticationService.pickElementContent(xmlResponse, "token"));
            this.applicationTokenHolder.set(applicationToken);
            if (applicationToken == null) {
                throw new EnvironmentFailureException("Application '" + this.application + "' couldn't be authenticated: " + xmlResponse);
            }
        }
        catch (EnvironmentFailureException ex) {
            throw ex;
        }
        catch (CheckedExceptionTunnel ex) {
            throw new EnvironmentFailureException(ex.getMessage(), CheckedExceptionTunnel.unwrapIfNecessary(ex));
        }
        catch (RuntimeException ex) {
            throw new EnvironmentFailureException(ex.getMessage(), ex);
        }
    }

    @Override
    public final String authenticateApplication() {
        return DUMMY_TOKEN_STR;
    }

    @Override
    public final boolean authenticateUser(String dummyToken, String user, String password) {
        return this.authenticateUser(user, password);
    }

    @Override
    public final boolean authenticateUser(String user, String password) {
        String xmlResponse;
        assert (user != null);
        String userToken = null;
        while ((userToken = this.extractUserToken(xmlResponse = this.execute(AUTHENTICATE_USER, this.application, this.getApplicationToken(false), user, password), user)) == null && this.isApplicationNotAuthenticated(xmlResponse)) {
            if (this.getApplicationToken(true) != null) continue;
            operationLog.error((Object)("Cannot authenticate user '" + user + "' because authentication of the application with the " + "CROWD service failed."));
            break;
        }
        this.logAuthentication(user, userToken != null);
        return userToken != null;
    }

    private void logAuthentication(String user, boolean authenticated) {
        if (operationLog.isInfoEnabled()) {
            String msg = "CROWD: authentication of user '" + user + "', application '" + this.application + "': ";
            operationLog.info((Object)(String.valueOf(msg) + (authenticated ? "SUCCESS." : "FAILED.")));
        }
    }

    private String executeAuthenticateApplication() {
        operationLog.info((Object)("CROWD: Attempting to authenticate as application " + this.application + "..."));
        return this.execute(AUTHENTICATE_APPL, this.application, this.applicationPassword);
    }

    private String getApplicationToken(boolean forceNewToken) {
        String applicationToken = this.applicationTokenHolder.get();
        if (applicationToken == null || forceNewToken) {
            String xmlResponse = this.executeAuthenticateApplication();
            applicationToken = StringEscapeUtils.unescapeXml((String)CrowdAuthenticationService.pickElementContent(xmlResponse, "token"));
            if (applicationToken == null) {
                operationLog.error((Object)("CROWD: application '" + this.application + "' failed to authenticate."));
            } else {
                operationLog.info((Object)("CROWD: application '" + this.application + "' successfully authenticated."));
            }
            this.applicationTokenHolder.set(applicationToken);
        }
        return applicationToken;
    }

    private boolean isApplicationNotAuthenticated(String xmlResponse) {
        return xmlResponse.indexOf(ERROR_MSG_WITH_INVALID_APPLICATION_TOKEN) >= 0;
    }

    private final String extractUserToken(String xmlResponse, String user) {
        String userToken = StringEscapeUtils.unescapeXml((String)CrowdAuthenticationService.pickElementContent(xmlResponse, "out"));
        return userToken;
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String dummyToken, String user, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(user, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String user, String passwordOrNull) {
        String xmlResponse = null;
        try {
            Principal principal = null;
            do {
                Map<String, String> parseXmlResponse;
                if ((parseXmlResponse = CrowdAuthenticationService.parseXmlResponse(xmlResponse = this.execute(FIND_PRINCIPAL_BY_NAME, this.application, this.getApplicationToken(false), user))).size() >= 1) {
                    principal = CrowdAuthenticationService.createPrincipal(user, parseXmlResponse);
                } else if (this.isApplicationNotAuthenticated(xmlResponse)) {
                    if (this.getApplicationToken(true) == null) {
                        if (passwordOrNull != null) {
                            operationLog.error((Object)("Cannot authenticate user '" + user + "' because authentication of the application with the " + "CROWD service failed."));
                            break;
                        }
                        operationLog.error((Object)("Cannot obtain details for user '" + user + "' because authentication of the application with the " + "CROWD service failed."));
                        break;
                    }
                } else {
                    if (!operationLog.isDebugEnabled()) break;
                    operationLog.debug((Object)"No SOAPAttribute element could be found in the SOAP XML response.");
                    break;
                }
                if (principal == null || passwordOrNull == null) continue;
                principal.setAuthenticated(this.authenticateUser(this.getApplicationToken(false), user, passwordOrNull));
            } while (principal == null);
            if (passwordOrNull != null) {
                this.logAuthentication(user, Principal.isAuthenticated(principal));
            }
            return principal;
        }
        catch (Exception ex) {
            String message = "Parsing XML response '" + xmlResponse + "' throws an Exception.";
            throw new EnvironmentFailureException(message, ex);
        }
    }

    @Override
    public final Principal getPrincipal(String applicationToken, String user) {
        return this.getPrincipal(user);
    }

    @Override
    public final Principal getPrincipal(String user) {
        Principal principalOrNull = this.tryGetAndAuthenticateUser(user, null);
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + user + "'.");
        }
        return principalOrNull;
    }

    private static final Map<String, String> parseXmlResponse(String xmlResponse) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        SOAPAttributeContentHandler contentHandler = new SOAPAttributeContentHandler();
        xmlReader.setContentHandler(contentHandler);
        StringReader stringReader = new StringReader(xmlResponse);
        xmlReader.parse(new InputSource(stringReader));
        stringReader.close();
        return contentHandler.getSoapAttributes();
    }

    private static final Principal createPrincipal(String user, Map<String, String> soapAttributes) {
        String firstName = soapAttributes.get(FIRST_NAME_PROPERTY_KEY);
        String lastName = soapAttributes.get(LAST_NAME_PROPERTY_KEY);
        String email = soapAttributes.get(EMAIL_PROPERTY_KEY);
        return new Principal(user, firstName, lastName, email, false, soapAttributes);
    }

    private final String execute(MessageFormat template, String ... args) {
        Object[] decodedArguments = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            decodedArguments[i] = StringEscapeUtils.escapeXml((String)args[i]);
            ++i;
        }
        return this.requestExecutor.execute(this.url, template.format(decodedArguments));
    }

    private static final String pickElementContent(String xmlString, String element) {
        if (xmlString == null) {
            operationLog.error((Object)("Response of web service is invalid (null). We were looking for element '" + element + "'."));
            return null;
        }
        int index = CrowdAuthenticationService.getIndex(xmlString, "<", element, 0);
        if (index < 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)("Element '" + element + "' could not be found in '" + StringUtils.abbreviate((String)xmlString, (int)50) + "'."));
            }
            return null;
        }
        if ((index = xmlString.indexOf(">", index)) < 0) {
            operationLog.error((Object)("Element '" + element + "' seems to be present but XML is invalid: '" + StringUtils.abbreviate((String)xmlString, (int)50) + "'."));
            return null;
        }
        int endIndex = CrowdAuthenticationService.getIndex(xmlString, "</", String.valueOf(element) + ">", index);
        if (endIndex < 0) {
            operationLog.error((Object)("Start tag of element '" + element + "' is present but end tag is missing: '" + StringUtils.abbreviate((String)xmlString, (int)50) + "'."));
            return null;
        }
        return xmlString.substring(index + 1, endIndex);
    }

    private static int getIndex(String xmlString, String begin, String element, int startIndex) {
        String regex = ".*(" + begin + "(\\w*:)?" + element + ").*";
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(xmlString);
        boolean result = matcher.matches();
        if (!result) {
            return -1;
        }
        int index = matcher.start(1);
        return index;
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String applicationToken, String emailQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String applicationToken, String email, String passwordOrNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String applicationToken, String lastNameQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String applicationToken, String userIdQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsListingByEmail() {
        return false;
    }

    @Override
    public boolean supportsListingByLastName() {
        return false;
    }

    @Override
    public boolean supportsListingByUserId() {
        return false;
    }
}

