/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem;

import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.IFileLocator;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetLocationUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.UUID;

public class ShardingFileLocator
implements IFileLocator {
    @Override
    public File getPathToArchiveOfDataSet(File directory, String dataSetCode) {
        File[] fileArray = directory.listFiles(new UUIDFileFilter());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File uuidDir = fileArray[n2];
            File candidate = new File(uuidDir, String.valueOf(DatasetLocationUtil.getDatasetLocationPath(dataSetCode, "")) + "/" + dataSetCode + ".zip");
            if (candidate.exists()) {
                return candidate;
            }
            ++n2;
        }
        return new File("...");
    }

    private class UUIDFileFilter
    implements FileFilter {
        private UUIDFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            try {
                UUID.fromString(file.getName());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
    }
}

