/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ArchiverPluginFactory {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ArchiverPluginFactory.class);
    private final String className;
    private final Properties archiverProperties;
    @Private
    public static final String CLASS_PROPERTY_NAME = "class";

    public ArchiverPluginFactory(PropertyParametersUtil.SectionProperties sectionProperties) {
        this.className = sectionProperties.getProperties().getProperty(CLASS_PROPERTY_NAME);
        this.archiverProperties = sectionProperties.getProperties();
    }

    public void check(File storeRoot) {
        if (!this.isArchiverConfigured()) {
            return;
        }
        this.createInstance(storeRoot);
    }

    public boolean isArchiverConfigured() {
        return this.className != null;
    }

    public IArchiverPlugin createInstance(File storeRoot) {
        if (!this.isArchiverConfigured()) {
            throw new ConfigurationFailureException("Archiver class is not configured.");
        }
        try {
            return ClassUtils.create(IArchiverPlugin.class, this.className, this.archiverProperties, storeRoot);
        }
        catch (ConfigurationFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot find the archiver class '" + this.className + "'", CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }

    public void logConfiguration() {
        operationLog.info((Object)"Archiver configuration:");
        this.logPropertiesConfiguration();
    }

    private final void logPropertiesConfiguration() {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("%s = %s", CLASS_PROPERTY_NAME, this.className));
        }
    }
}

