/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.MatchingEntitiesPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity;
import com.extjs.gxt.ui.client.widget.MessageBox;

public class GlobalSearchTabItemFactory {
    public static void openTabIfEntitiesFound(IViewContext<ICommonClientServiceAsync> viewContext, SearchableEntity searchableEntity, String queryText) {
        GlobalSearchTabItemFactory.openTab(viewContext, searchableEntity, queryText, false);
    }

    public static void openTab(IViewContext<ICommonClientServiceAsync> viewContext, SearchableEntity searchableEntity, String queryText) {
        GlobalSearchTabItemFactory.openTab(viewContext, searchableEntity, queryText, true);
    }

    private static void openTab(final IViewContext<ICommonClientServiceAsync> viewContext, SearchableEntity searchableEntity, final String queryText, final boolean openIfNoEntitiesFound) {
        final boolean useWildcardSearchMode = viewContext.getDisplaySettingsManager().isUseWildcardSearchMode();
        final MatchingEntitiesPanel matchingEntitiesGrid = new MatchingEntitiesPanel(viewContext, searchableEntity, queryText, useWildcardSearchMode);
        String entityDescription = searchableEntity != null ? searchableEntity.getDescription() : null;
        String title = GlobalSearchTabItemFactory.createTabTitle(viewContext, entityDescription, queryText);
        final AbstractTabItemFactory tabFactory = GlobalSearchTabItemFactory.createTabFactory(matchingEntitiesGrid, title, viewContext);
        matchingEntitiesGrid.refresh(new IDataRefreshCallback(){
            private boolean firstCall = true;

            @Override
            public void postRefresh(boolean wasSuccessful) {
                if (!this.firstCall) {
                    return;
                }
                this.firstCall = false;
                if (matchingEntitiesGrid.getRowNumber() == 0) {
                    Object[] objectArray;
                    if (useWildcardSearchMode) {
                        Object[] objectArray2 = new String[3];
                        objectArray2[0] = queryText;
                        objectArray2[1] = "";
                        objectArray = objectArray2;
                        objectArray2[2] = "off";
                    } else {
                        String[] stringArray = new String[3];
                        stringArray[0] = queryText;
                        stringArray[1] = "not";
                        objectArray = stringArray;
                        stringArray[2] = "on";
                    }
                    Object[] msgParameters = objectArray;
                    MessageBox.alert((String)viewContext.getMessage("messagebox_warning", new Object[0]), (String)viewContext.getMessage("no_match", msgParameters), null);
                    if (!openIfNoEntitiesFound) {
                        return;
                    }
                }
                DispatcherHelper.dispatchNaviEvent(tabFactory);
            }
        });
    }

    private static String createTabTitle(IViewContext<ICommonClientServiceAsync> viewContext, String chosenEntity, String queryText) {
        String entity = chosenEntity != null ? chosenEntity : "All";
        return viewContext.getMessage("global_search", entity, queryText);
    }

    private static AbstractTabItemFactory createTabFactory(final MatchingEntitiesPanel matchingEntitiesPanel, final String title, IViewContext<?> viewContext) {
        final ITabItem tab = DefaultTabItem.create(title, matchingEntitiesPanel.asDisposableComponent(), viewContext);
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                return tab;
            }

            @Override
            public String getId() {
                return matchingEntitiesPanel.getId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SEARCH, HelpPageIdentifier.HelpPageAction.ACTION);
            }

            @Override
            public String getTabTitle() {
                return title;
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }
}

