/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

abstract class AbstractCommonServer<T extends IServer>
extends AbstractServer<T> {
    private final IAuthenticationService authenticationService;
    protected final ICommonBusinessObjectFactory businessObjectFactory;

    public AbstractCommonServer(IAuthenticationService authenticationService, IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonBusinessObjectFactory businessObjectFactory) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.authenticationService = authenticationService;
        this.businessObjectFactory = businessObjectFactory;
    }

    protected List<PersonPE> registerPersons(String sessionToken, List<String> userIDs) {
        Session session = this.getSession(sessionToken);
        List<PersonPE> persons = this.getDAOFactory().getPersonDAO().listByCodes(userIDs);
        if (persons.size() > 0) {
            throw UserFailureException.fromTemplate("Following persons already exist: [%s]", StringUtils.join(userIDs, (String)","));
        }
        ArrayList<String> unknownUsers = new ArrayList<String>();
        DisplaySettings defaultDisplaySettings = this.getDefaultDisplaySettings(sessionToken);
        ArrayList<PersonPE> newPersons = new ArrayList<PersonPE>();
        for (String userID : userIDs) {
            try {
                Principal principal = this.authenticationService.getPrincipal(userID);
                newPersons.add(this.createPerson(principal, session.tryGetPerson(), defaultDisplaySettings));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                unknownUsers.add(userID);
            }
        }
        if (unknownUsers.size() > 0) {
            throw UserFailureException.fromTemplate("Following persons unknown by the authentication service: [%s]", StringUtils.join(userIDs, (String)","));
        }
        return newPersons;
    }

    public int archiveDatasets(String sessionToken, List<String> datasetCodes, boolean deleteFromDataStore) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(datasetCodes, false, true);
        return dataSetTable.archiveDatasets(deleteFromDataStore);
    }

    public int unarchiveDatasets(String sessionToken, List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(datasetCodes, false, true);
        return dataSetTable.unarchiveDatasets();
    }

    protected IDatasetLister createDatasetLister(Session session) {
        return this.businessObjectFactory.createDatasetLister(session);
    }
}

