/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryEditor;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class QueryBrowserGrid
extends TypedTableGrid<QueryExpression> {
    private static final String BROWSER_ID = "openbis_query-modulequeries_browser";
    private final IViewContext<IQueryClientServiceAsync> viewContext;
    private QueryEditor queryEditor;

    public static DatabaseModificationAwareComponent create(IViewContext<IQueryClientServiceAsync> viewContext) {
        QueryBrowserGrid browser = new QueryBrowserGrid(viewContext);
        return new DatabaseModificationAwareComponent((Component)browser, (IDatabaseModificationObserver)browser.asDisposableWithoutToolbar());
    }

    QueryBrowserGrid(IViewContext<IQueryClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, true, DisplayTypeIDGenerator.QUERY_EDITOR);
        this.viewContext = viewContext;
        this.extendBottomToolbar();
    }

    @Override
    protected void disposeCache() {
        if (this.queryEditor != null) {
            this.queryEditor.dispose();
        }
        super.disposeCache();
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add_query", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                QueryBrowserGrid.this.queryEditor = new QueryEditor(QueryBrowserGrid.this.viewContext, null, QueryBrowserGrid.this.createRefreshGridAction(), QueryBrowserGrid.this.getWidth(), QueryBrowserGrid.this.getHeight());
                QueryBrowserGrid.this.queryEditor.show();
            }
        });
        this.addButton(addButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<QueryExpression>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<QueryExpression>> selectedItem, boolean keyPressed) {
                QueryExpression query = selectedItem.getBaseObject().getObjectOrNull();
                QueryBrowserGrid.this.queryEditor = new QueryEditor(QueryBrowserGrid.this.viewContext, query, QueryBrowserGrid.this.createRefreshGridAction(), QueryBrowserGrid.this.getWidth(), QueryBrowserGrid.this.getHeight());
                QueryBrowserGrid.this.queryEditor.show();
            }
        });
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<QueryExpression>> selected, IBrowserGridActionInvoker invoker) {
                return new DeletionConfirmationDialog(QueryBrowserGrid.this.viewContext, selected, QueryBrowserGrid.this.createRefreshCallback(invoker));
            }
        });
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<QueryExpression>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<QueryExpression>> definitions = super.createColumnsDefinition();
        definitions.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        return definitions;
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("NAME", "IS_PUBLIC");
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<QueryExpression>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<QueryExpression>> callback) {
        this.viewContext.getService().listQueries(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<QueryExpression>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.viewContext.getService().prepareExportQueries(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.QUERY);
    }

    private static class DeletionConfirmationDialog
    extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<QueryExpression>>> {
        private static final int LABEL_WIDTH = 60;
        private static final int FIELD_WIDTH = 180;
        private final IViewContext<IQueryClientServiceAsync> viewContext;
        private final AbstractAsyncCallback<Void> callback;

        public DeletionConfirmationDialog(IViewContext<IQueryClientServiceAsync> viewContext, List<TableModelRowWithObject<QueryExpression>> data, AbstractAsyncCallback<Void> callback) {
            super(viewContext, data, viewContext.getMessage("delete_confirmation_title", new Object[0]));
            this.callback = callback;
            this.viewContext = viewContext;
        }

        @Override
        protected void extendForm() {
            this.formPanel.setLabelWidth(60);
            this.formPanel.setFieldWidth(180);
        }

        @Override
        protected String createMessage() {
            ArrayList<String> names = new ArrayList<String>();
            for (TableModelRowWithObject query : (List)this.data) {
                names.add(((QueryExpression)query.getObjectOrNull()).getName());
            }
            return this.viewContext.getMessage("query_deletion_confirmation", names);
        }

        @Override
        protected void executeConfirmedAction() {
            this.viewContext.getService().deleteQueries(TechId.createList((Collection)this.data), this.callback);
        }
    }
}

