/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.plugins.dss;

import ch.systemsx.cisd.cifex.server.trigger.ITrigger;
import ch.systemsx.cisd.cifex.server.trigger.ITriggerConsole;
import ch.systemsx.cisd.cifex.server.trigger.ITriggerRequest;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.HardLinkMaker;
import ch.systemsx.cisd.common.filesystem.IFileImmutableCopier;
import ch.systemsx.cisd.common.mail.EMailAddress;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DataStoreTrigger
implements ITrigger {
    private static final String USER_EMAIL_KEY = "user-email";
    private static final String COMMENT_KEY = "comment";
    private static final String REQUEST_PROPERTIES_FILE = "request.properties";
    private static final String INCOMING_DIRECTORY_PATH_KEY = "dss-incoming-directory";
    private static final String DATASET_PROEPERTIES_FILENAME = "dss-data-set-properties-file-name";
    private File incomingDirectory;
    private String propertiesFileNameOrNull;

    public DataStoreTrigger(Properties properties) {
        String incomingDirectoryPath = properties.getProperty(INCOMING_DIRECTORY_PATH_KEY);
        if (StringUtils.isEmpty((String)incomingDirectoryPath)) {
            throw new ConfigurationFailureException("dss-incoming-directory not configured");
        }
        this.incomingDirectory = new File(incomingDirectoryPath);
        String errorMessage = FileUtilities.checkDirectoryFullyAccessible(this.incomingDirectory, "data store incoming directory");
        if (errorMessage != null) {
            throw new EnvironmentFailureException(errorMessage);
        }
        this.propertiesFileNameOrNull = properties.getProperty(DATASET_PROEPERTIES_FILENAME);
        if (StringUtils.isBlank((String)this.propertiesFileNameOrNull)) {
            this.propertiesFileNameOrNull = null;
        }
    }

    @Override
    public void handle(ITriggerRequest request, ITriggerConsole console) {
        if (this.propertiesFileNameOrNull != null && this.propertiesFileNameOrNull.equals(request.getFileName())) {
            return;
        }
        request.dismiss();
        File sourceFile = request.getFile();
        ITriggerRequest propertiesFileOrNull = this.tryGetDataSetPropertiesFile(console);
        try {
            File destDir = this.createDestinationDirectory(sourceFile);
            this.saveRequestPropertiesFile(destDir, request);
            this.copyUploadedFile(sourceFile, destDir, request.getFileName());
            if (propertiesFileOrNull != null) {
                this.copyUploadedFile(propertiesFileOrNull.getFile(), destDir, propertiesFileOrNull.getFileName());
            }
        }
        catch (Exception ex) {
            console.sendEmailMessage("Data set upload failed", String.format("Upload of data set (file: '%s', comment: '%s') failed. ('%s')", sourceFile, request.getComment(), ex.getMessage()), null, null, new EMailAddress(request.getUploadingUserEmail()));
        }
    }

    private ITriggerRequest tryGetDataSetPropertiesFile(ITriggerConsole console) {
        if (this.propertiesFileNameOrNull == null) {
            return null;
        }
        List<ITriggerRequest> propertyFiles = console.getPendingRequests(this.propertiesFileNameOrNull);
        if (propertyFiles.isEmpty()) {
            return null;
        }
        ITriggerRequest latestPropertyFile = null;
        for (ITriggerRequest pfile : propertyFiles) {
            if (latestPropertyFile == null || pfile.getRequestTime().getTime() > latestPropertyFile.getRequestTime().getTime()) {
                latestPropertyFile = pfile;
            }
            pfile.dismiss();
        }
        return latestPropertyFile;
    }

    private File createDestinationDirectory(File sourceFile) {
        File destDir = FileUtilities.createNextNumberedFile(new File(this.incomingDirectory, String.valueOf(sourceFile.getName()) + ".dir"), null);
        boolean success = destDir.mkdir();
        if (!success) {
            throw new EnvironmentFailureException("Could not create destination directory");
        }
        return destDir;
    }

    private void copyUploadedFile(File sourceFile, File destinationDirectory, String destinationFileName) {
        IFileImmutableCopier copier = HardLinkMaker.tryCreate();
        if (copier != null) {
            Status status = copier.copyFileImmutably(sourceFile, destinationDirectory, destinationFileName);
            if (status.isError()) {
                throw new EnvironmentFailureException("Could not create the hardlink copy: " + status.tryGetErrorMessage());
            }
        } else {
            FileOperations.getInstance().copyToDirectory(sourceFile, destinationDirectory);
        }
    }

    private void saveRequestPropertiesFile(File destDir, ITriggerRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(DataStoreTrigger.createProperty(COMMENT_KEY, request.getComment()));
        sb.append(DataStoreTrigger.createProperty(USER_EMAIL_KEY, request.getUploadingUserEmail()));
        File requestPropertiesFile = new File(destDir, REQUEST_PROPERTIES_FILE);
        FileUtilities.writeToFile(requestPropertiesFile, sb.toString());
    }

    private static String createProperty(String key, String value) {
        return String.valueOf(key) + "=" + value + "\n";
    }
}

