/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.Update;
import net.lemnik.eodsql.impl.UpdateMethodImplementation;
import net.lemnik.eodsql.spi.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatchUpdateMethodImplementation
extends UpdateMethodImplementation {
    private final ParameterViewFactory[] viewFactories;
    private final int firstIndexOfFiniteCollection;

    BatchUpdateMethodImplementation(Method method) throws ParseException {
        super(method);
        this.viewFactories = BatchUpdateMethodImplementation.createParameterViewFactories(method.getParameterTypes());
        this.firstIndexOfFiniteCollection = BatchUpdateMethodImplementation.findFirstIndexOfFiniteCollection(this.viewFactories);
        if (this.firstIndexOfFiniteCollection == -1) {
            throw new RuntimeException("Method '" + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "' supposed to do batch update, but has no batch parameter.");
        }
    }

    BatchUpdateMethodImplementation(Update update, Class[] classArray, Class[] classArray2, Type type, Method method) throws ParseException {
        super(update, classArray2, type);
        this.viewFactories = BatchUpdateMethodImplementation.createParameterViewFactories(classArray);
        this.firstIndexOfFiniteCollection = BatchUpdateMethodImplementation.findFirstIndexOfFiniteCollection(this.viewFactories);
        if (this.firstIndexOfFiniteCollection == -1) {
            throw new RuntimeException("Method '" + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "' supposed to do batch update, but has no batch parameter.");
        }
    }

    private Iterator<?>[] createParameterViews(Object[] objectArray) {
        int n = objectArray.length;
        Iterator[] iteratorArray = new Iterator[n];
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Collection<?> collection = this.viewFactories[i].createView(objectArray[i]);
            int n3 = collection.size();
            if (n3 != -1) {
                if (n2 == -1) {
                    n2 = n3;
                } else if (n2 != n3) {
                    throw new EoDException("Batch parameter is mismatched in size: " + i);
                }
            }
            iteratorArray[i] = collection.iterator();
        }
        return iteratorArray;
    }

    private Iterator<Context<Update>> iterate(final Context<Update> context) {
        final Iterator[] iteratorArray = this.createParameterViews(context.getParameters());
        if (iteratorArray.length == 0) {
            return Collections.emptyList().iterator();
        }
        return new Iterator<Context<Update>>(){
            private final int paramCount;
            private final Object[] parameters;
            private final Context<Update> context;
            {
                this.paramCount = iteratorArray.length;
                this.parameters = new Object[this.paramCount];
                this.context = new Context(context, this.parameters);
            }

            @Override
            public boolean hasNext() {
                return iteratorArray[BatchUpdateMethodImplementation.this.firstIndexOfFiniteCollection].hasNext();
            }

            @Override
            public Context<Update> next() {
                for (int i = 0; i < this.paramCount; ++i) {
                    this.parameters[i] = iteratorArray[i].next();
                }
                return this.context;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    private static ParameterViewFactory createParameterViewFactory(Class<?> clazz) {
        if (clazz.isArray()) {
            return new ArrayViewFactory();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionViewFactory();
        }
        return new SimpleParameterIteratorFactory();
    }

    static ParameterViewFactory[] createParameterViewFactories(Class<?>[] classArray) {
        int n = classArray.length;
        ParameterViewFactory[] parameterViewFactoryArray = new ParameterViewFactory[n];
        for (int i = 0; i < n; ++i) {
            parameterViewFactoryArray[i] = BatchUpdateMethodImplementation.createParameterViewFactory(classArray[i]);
        }
        return parameterViewFactoryArray;
    }

    private static int findFirstIndexOfFiniteCollection(ParameterViewFactory[] parameterViewFactoryArray) {
        for (int i = 0; i < parameterViewFactoryArray.length; ++i) {
            if (!parameterViewFactoryArray[i].isFiniteCollection()) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?>[] getParameterTypes(Method method) {
        Type[] typeArray = method.getGenericParameterTypes();
        int n = typeArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Type type;
            Type type2;
            Type type3 = typeArray[i];
            Type type4 = null;
            if (type3 instanceof Class) {
                type4 = (Class)type3;
                if (((Class)type4).isArray()) {
                    type4 = ((Class)type4).getComponentType();
                }
            } else if (type3 instanceof ParameterizedType) {
                type2 = (ParameterizedType)type3;
                if (!(type2.getRawType() instanceof Class)) throw new InvalidQueryException("A generic type must has a concrete class type: " + type3, method);
                type = (Class)type2.getRawType();
                if (Iterable.class.isAssignableFrom((Class<?>)type)) {
                    Type[] typeArray2 = type2.getActualTypeArguments();
                    if (typeArray2.length != 1) {
                        throw new InvalidQueryException("A generic Iterable may only have one type argument: " + type2, method);
                    }
                    if (!(typeArray2[0] instanceof Class)) throw new InvalidQueryException("A generic Iterable must have a concrete parameter type: " + type2, method);
                    type4 = (Class)typeArray2[0];
                } else {
                    type4 = type;
                    if (((Class)type4).isArray()) {
                        type4 = ((Class)type4).getComponentType();
                    }
                }
            } else {
                if (!(type3 instanceof GenericArrayType)) throw new InvalidQueryException("Unsupported type: " + type3, method);
                type2 = (GenericArrayType)type3;
                type = type2.getGenericComponentType();
                if (!(type instanceof Class)) throw new InvalidQueryException("Arrays must have a concrete component type: " + type2, method);
                type4 = (Class)type;
            }
            classArray[i] = type4;
        }
        return classArray;
    }

    @Override
    protected void update(PreparedStatement preparedStatement, Context<Update> context) throws SQLException {
        Iterator<Context<Update>> iterator = this.iterate(context);
        while (iterator.hasNext()) {
            Context<Update> context2 = iterator.next();
            this.fillPreparedStatementParameters(context2, preparedStatement);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleParameterIteratorFactory
    implements ParameterViewFactory {
        private SimpleParameterIteratorFactory() {
        }

        @Override
        public Collection<?> createView(final Object object) {
            return new IteratingCollection<Object>(){

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Object next() {
                    return object;
                }

                @Override
                public int size() {
                    return -1;
                }
            };
        }

        @Override
        public boolean isFiniteCollection() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionViewFactory
    implements ParameterViewFactory {
        private CollectionViewFactory() {
        }

        @Override
        public Collection<?> createView(Object object) {
            return (Collection)object;
        }

        @Override
        public boolean isFiniteCollection() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayViewFactory
    implements ParameterViewFactory {
        private ArrayViewFactory() {
        }

        @Override
        public Collection<?> createView(final Object object) {
            return new IteratingCollection<Object>(){
                private final int size;
                private int i;
                {
                    this.size = Array.getLength(object);
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.i < this.size;
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return Array.get(object, this.i++);
                }

                @Override
                public int size() {
                    return this.size;
                }
            };
        }

        @Override
        public boolean isFiniteCollection() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class IteratingCollection<T>
    extends AbstractCollection<T>
    implements Iterator<T> {
        IteratingCollection() {
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ParameterViewFactory {
        public static final int UNKNOWN_SIZE = -1;

        public Collection<?> createView(Object var1);

        public boolean isFiniteCollection();
    }
}

