/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.Element;

public class CodeFieldWithGenerator
extends CodeField {
    private final IViewContext<?> viewContext;
    private final String codePrefix;
    private final boolean autoGenerateCode;
    private final EntityKind entityKind;

    public CodeFieldWithGenerator(IViewContext<?> viewContext, String label, String codePrefix, EntityKind entityKind, boolean autoGenerateCode) {
        super(viewContext, label);
        this.viewContext = viewContext;
        this.codePrefix = codePrefix;
        this.entityKind = entityKind;
        this.autoGenerateCode = autoGenerateCode;
        this.setTriggerStyle("x-form-trigger-generate");
        this.setHideTrigger(false);
        GWTUtils.setToolTip((Component)this, "Click the button to automatically generate the code");
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        if (this.autoGenerateCode) {
            this.generateCode();
        }
    }

    public void setHideTrigger(boolean hideTrigger) {
        super.setHideTrigger(hideTrigger);
        if (hideTrigger) {
            GWTUtils.setToolTip((Component)this, "");
        }
    }

    public void reset() {
        if (this.autoGenerateCode) {
            this.generateCode();
        } else {
            super.reset();
        }
    }

    protected void onTriggerClick(ComponentEvent ce) {
        super.onTriggerClick(ce);
        this.generateCode();
    }

    public void generateCode() {
        this.viewContext.getCommonService().generateCode(this.codePrefix, this.entityKind, new GenerateCodeCallback(this.viewContext));
    }

    private final class GenerateCodeCallback
    extends AbstractAsyncCallback<String> {
        GenerateCodeCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(String result) {
            CodeFieldWithGenerator.this.setValue(result);
        }
    }
}

