/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.dto;

import ch.systemsx.cisd.base.convert.NativeTaggedArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.WellLocationUtils;
import java.util.Arrays;

public final class PlateFeatureValues {
    private final MDFloatArray valueArray;
    private final Geometry geometry;

    public PlateFeatureValues(Geometry geometry) {
        this.geometry = geometry;
        this.valueArray = new MDFloatArray(geometry.getCartesianDimensions());
        Arrays.fill(this.valueArray.getAsFlatArray(), Float.NaN);
    }

    public PlateFeatureValues(byte[] byteArray) {
        this.valueArray = NativeTaggedArray.tryToFloatArray((byte[])byteArray);
        if (this.valueArray == null || this.valueArray.rank() != 2) {
            throw new IllegalArgumentException("byteArray is not a valid two-dimensional tagged array.");
        }
        this.geometry = Geometry.createFromCartesianDimensions(this.valueArray.dimensions());
    }

    public void setForCartesianCoordinates(float value, int x, int y) {
        this.valueArray.set(value, x, y);
    }

    public float getForCartesianCoordinates(int x, int y) {
        return this.valueArray.get(x, y);
    }

    public void setForWellLocation(float value, int row, int col) {
        this.valueArray.set(value, WellLocationUtils.calcX(this.geometry, row, col), WellLocationUtils.calcY(this.geometry, row, col));
    }

    public float getForWellLocation(int row, int col) {
        return this.valueArray.get(WellLocationUtils.calcX(this.geometry, row, col), WellLocationUtils.calcY(this.geometry, row, col));
    }

    public void setForWellLocation(float value, WellLocation wellLocation) {
        this.valueArray.set(value, WellLocationUtils.calcX(this.geometry, wellLocation), WellLocationUtils.calcY(this.geometry, wellLocation));
    }

    public float getForWellLocation(WellLocation wellLocation) {
        return this.valueArray.get(WellLocationUtils.calcX(this.geometry, wellLocation), WellLocationUtils.calcY(this.geometry, wellLocation));
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public byte[] toByteArray() {
        return NativeTaggedArray.toByteArray((MDFloatArray)this.valueArray);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.valueArray == null ? 0 : this.valueArray.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlateFeatureValues other = (PlateFeatureValues)obj;
        return !(this.valueArray == null ? other.valueArray != null : !this.valueArray.equals((Object)other.valueArray));
    }
}

