/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import net.lemnik.eodsql.spi.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context<A extends Annotation> {
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private final Map<Class<?>, Resource<?>> resources = new LinkedHashMap();
    private final A annotation;
    private final Object[] parameters;
    private final Class<?> returnType;
    private Object returnValue = null;
    private boolean autoclose = true;
    private boolean dontCloseConnection = false;
    private boolean closed = false;
    private final boolean childContext;

    public Context(A a, Class<?> clazz, Object[] objectArray) {
        this.annotation = a;
        this.returnType = clazz;
        this.parameters = objectArray != null ? objectArray : EMPTY_PARAMETERS;
        this.childContext = false;
    }

    public Context(Context<A> context, Object[] objectArray) throws IllegalStateException, NullPointerException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.closed) {
            throw new IllegalStateException("Parent context is already closed");
        }
        this.annotation = context.getAnnotation();
        this.returnType = context.returnType;
        this.resources.putAll(context.resources);
        this.parameters = objectArray;
        this.autoclose = context.autoclose;
        this.childContext = true;
    }

    protected void finalize() throws Exception {
        if (this.autoclose) {
            this.close();
        }
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object object) {
        this.returnValue = object;
    }

    public void setResource(Resource<?> resource) {
        if (this.childContext) {
            throw new IllegalStateException("Cannot add resource to nested context");
        }
        this.resources.put(resource.getResourceType(), resource);
    }

    public <T> Resource<T> getResource(Class<T> clazz) throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Cannot fetch a resource from a closed Context object.");
        }
        Resource<?> resource = this.resources.get(clazz);
        if (resource == null || !resource.isClosed()) {
            return resource;
        }
        throw new IllegalStateException("Resource " + clazz.getName() + " is already closed in this Context object.");
    }

    public void setAutoclose(boolean bl) {
        this.autoclose = bl;
    }

    public boolean isAutoclose() {
        return this.autoclose;
    }

    public boolean isDontCloseConnection() {
        return this.dontCloseConnection;
    }

    public void setDontCloseConnection(boolean bl) {
        this.dontCloseConnection = bl;
    }

    private final boolean isConnectionResource(Resource<?> resource) {
        return resource.getResourceType() == Connection.class;
    }

    public void close() throws SQLException {
        if (!this.closed && !this.childContext) {
            this.closed = true;
            ArrayList arrayList = new ArrayList(this.resources.values());
            this.resources.clear();
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                Resource resource = (Resource)listIterator.previous();
                if (this.dontCloseConnection && this.isConnectionResource(resource) || resource.isClosed()) continue;
                resource.close();
            }
        }
    }
}

