/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.JsonRpcServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;

public class StreamServer {
    private static final Logger LOGGER = Logger.getLogger(StreamServer.class.getName());
    private static final long SERVER_SOCKET_SO_TIMEOUT = 5000L;
    private ThreadPoolExecutor executor;
    private ServerSocket serverSocket;
    private JsonRpcServer jsonRpcServer;
    private int maxClientErrors = 5;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AtomicBoolean keepRunning = new AtomicBoolean(false);

    public StreamServer(JsonRpcServer jsonRpcServer, int maxThreads, ServerSocket serverSocket) {
        this.jsonRpcServer = jsonRpcServer;
        this.serverSocket = serverSocket;
        this.executor = new ThreadPoolExecutor(maxThreads + 1, maxThreads + 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        jsonRpcServer.setRethrowExceptions(false);
    }

    public StreamServer(JsonRpcServer jsonRpcServer, int maxThreads, int port, int backlog, InetAddress bindAddress) throws IOException {
        this(jsonRpcServer, maxThreads, ServerSocketFactory.getDefault().createServerSocket(port, backlog, bindAddress));
    }

    public void start() {
        if (!this.isStarted.compareAndSet(false, true)) {
            throw new IllegalStateException("The StreamServer is already started");
        }
        LOGGER.log(Level.INFO, "StreamServer starting " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort());
        this.keepRunning.set(true);
        this.executor.submit(new Server());
    }

    public void stop() throws InterruptedException {
        if (!this.isStarted.get()) {
            throw new IllegalStateException("The StreamServer is not started");
        }
        this.keepRunning.set(false);
        this.executor.shutdownNow();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (!this.executor.isTerminated()) {
                this.executor.awaitTermination(7000L, TimeUnit.MILLISECONDS);
            }
            this.isStarted.set(false);
            this.keepRunning.set(false);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "InterruptedException while waiting for termination", e);
            throw e;
        }
    }

    public int getMaxClientErrors() {
        return this.maxClientErrors;
    }

    public void setMaxClientErrors(int maxClientErrors) {
        this.maxClientErrors = maxClientErrors;
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    private class Server
    implements Runnable {
        private Server() {
        }

        @Override
        public void run() {
            OutputStream output;
            InputStream input;
            ServerSocket serverSocket = StreamServer.this.serverSocket;
            Socket clientSocket = null;
            while (StreamServer.this.keepRunning.get()) {
                try {
                    serverSocket.setSoTimeout(5000);
                    clientSocket = serverSocket.accept();
                    LOGGER.log(Level.INFO, "Connection from " + clientSocket.getInetAddress() + ":" + clientSocket.getPort());
                    StreamServer.this.executor.submit(new Server());
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (SSLException ssle) {
                    LOGGER.log(Level.SEVERE, "SSLException while listening for clients, terminating", ssle);
                    break;
                }
                catch (IOException ioe) {
                    if (SocketException.class.isInstance(ioe) && !StreamServer.this.keepRunning.get()) break;
                    LOGGER.log(Level.SEVERE, "Exception while listening for clients", ioe);
                }
            }
            try {
                input = clientSocket.getInputStream();
                output = clientSocket.getOutputStream();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Client socket failed", e);
                return;
            }
            int errors = 0;
            while (StreamServer.this.keepRunning.get() && clientSocket.isConnected()) {
                try {
                    if (input.available() == 0) {
                        Thread.yield();
                        continue;
                    }
                    StreamServer.this.jsonRpcServer.handle(input, output);
                }
                catch (Throwable t) {
                    if (++errors < StreamServer.this.maxClientErrors) {
                        LOGGER.log(Level.SEVERE, "Exception while handling request", t);
                        continue;
                    }
                    LOGGER.log(Level.SEVERE, "Closing client connection due to repeated errors", t);
                    break;
                }
            }
            try {
                clientSocket.close();
                input.close();
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

