/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackingStateDTO;
import ch.ethz.bsse.cisd.dsu.tracking.main.ITrackingDAO;
import ch.ethz.bsse.cisd.dsu.tracking.utils.LogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class FileBasedTrackingDAO
implements ITrackingDAO {
    static String LAST_SEEN_DATASET_ID = "lastSeenDatasetId";
    static String TO_BE_PROCESSED = "trackedSamplesToBeProcessed";
    static String PROCESSED = "trackedSamplesProcessedSuccessfully";
    static String SEPARATOR = " ";
    private final String filePath;

    public FileBasedTrackingDAO(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void saveTrackingState(TrackingStateDTO state) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.valueOf(LAST_SEEN_DATASET_ID) + SEPARATOR + state.getLastSeenDatasetId());
        lines.add(String.valueOf(TO_BE_PROCESSED) + SEPARATOR + this.sampleIdsAsString(state.getAlreadyTrackedSampleIdsToBeProcessed()));
        lines.add(String.valueOf(PROCESSED) + SEPARATOR + this.sampleIdsAsString(state.getAlreadyTrackedSampleIdsProcessed()));
        FileBasedTrackingDAO.writeLines(new File(this.filePath), lines);
    }

    private String sampleIdsAsString(Collection<Long> sampleIds) {
        return StringUtils.join(sampleIds, (String)SEPARATOR);
    }

    @Override
    public TrackingStateDTO getTrackingState() {
        try {
            List lines = IOUtils.readLines((Reader)new FileReader(this.filePath));
            if (lines.size() != 3) {
                throw LogUtils.environmentError("File %s should have exactly 3 rows.", this.filePath);
            }
            TrackingStateDTO state = new TrackingStateDTO();
            String[] datasetId = ((String)lines.get(0)).split(SEPARATOR);
            String[] toBeProcessed = ((String)lines.get(1)).split(SEPARATOR);
            String[] processed = ((String)lines.get(2)).split(SEPARATOR);
            state.setLastSeenDatasetId(Long.parseLong(datasetId[1]));
            state.setAlreadyTrackedSampleIdsToBeProcessed(FileBasedTrackingDAO.parseIds(toBeProcessed));
            state.setAlreadyTrackedSampleIdsProcessed(FileBasedTrackingDAO.parseIds(processed));
            return state;
        }
        catch (Exception e) {
            throw LogUtils.environmentError("Incorrect file format", e);
        }
    }

    private static Set<Long> parseIds(String[] array) {
        TreeSet<Long> ids = new TreeSet<Long>();
        int i = 1;
        while (i < array.length) {
            ids.add(Long.parseLong(array[i]));
            ++i;
        }
        return ids;
    }

    private static void writeLines(File file, List<String> lines) {
        try {
            IOUtils.writeLines(lines, (String)"\n", (OutputStream)new FileOutputStream(file));
        }
        catch (IOException ex) {
            throw LogUtils.environmentError(String.format("Cannot save the file %s with content: %s", file.getPath(), lines), ex);
        }
    }
}

