/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.zip.ZipEntry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.util.Paths;
import de.schlichtherle.util.zip.BasicZipFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.zip.ZipException;

public class ZipInputArchive
extends BasicZipFile
implements InputArchive {
    private InputArchiveMetaData metaData;

    public ZipInputArchive(ReadOnlyFile rof, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(rof, charset, preambled, postambled);
    }

    protected de.schlichtherle.util.zip.ZipEntry createZipEntry(String entryName) {
        return new ZipEntry(Paths.normalize(entryName, '/'));
    }

    public int getNumArchiveEntries() {
        return super.size();
    }

    public Enumeration getArchiveEntries() {
        return super.entries();
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        return (ZipEntry)super.getEntry(entryName);
    }

    public InputStream getInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        return super.getInputStream(entry.getName(), false, !(dstEntry instanceof ZipEntry));
    }

    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InputArchiveMetaData metaData) {
        this.metaData = metaData;
    }
}

