/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.HashMap;
import java.util.Map;
import ucar.ma2.StructureData;

public class DataType {
    private static Map<String, DataType> hash = new HashMap<String, DataType>(20);
    public static final DataType BOOLEAN = new DataType("boolean", 1);
    public static final DataType BYTE = new DataType("byte", 1);
    public static final DataType CHAR = new DataType("char", 1);
    public static final DataType SHORT = new DataType("short", 2);
    public static final DataType INT = new DataType("int", 4);
    public static final DataType LONG = new DataType("long", 8);
    public static final DataType FLOAT = new DataType("float", 4);
    public static final DataType DOUBLE = new DataType("double", 8);
    public static final DataType STRING = new DataType("String", 1);
    public static final DataType STRUCTURE = new DataType("Structure", 1);
    public static final DataType OPAQUE = new DataType("opaque", 1);
    public static final DataType ENUM = new DataType("enum", 1);
    private String _DataType;
    private int size;

    private DataType(String s, int size) {
        this._DataType = s;
        this.size = size;
        hash.put(s, this);
    }

    public static DataType getType(String name) {
        if (name == null) {
            return null;
        }
        return hash.get(name);
    }

    public static DataType getType(Class c) {
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return INT;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return BYTE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Long.TYPE || c == Long.class) {
            return LONG;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == StructureData.class) {
            return STRUCTURE;
        }
        return null;
    }

    public String toString() {
        return this._DataType;
    }

    public int getSize() {
        return this.size;
    }

    public Class getPrimitiveClassType() {
        if (this == FLOAT) {
            return Float.TYPE;
        }
        if (this == DOUBLE) {
            return Double.TYPE;
        }
        if (this == SHORT) {
            return Short.TYPE;
        }
        if (this == INT) {
            return Integer.TYPE;
        }
        if (this == BYTE || this == OPAQUE) {
            return Byte.TYPE;
        }
        if (this == CHAR) {
            return Character.TYPE;
        }
        if (this == BOOLEAN) {
            return Boolean.TYPE;
        }
        if (this == LONG) {
            return Long.TYPE;
        }
        if (this == STRING || this == ENUM) {
            return String.class;
        }
        if (this == STRUCTURE) {
            return StructureData.class;
        }
        return null;
    }

    public Class getClassType() {
        if (this == BYTE || this == OPAQUE) {
            return Byte.class;
        }
        if (this == FLOAT) {
            return Float.class;
        }
        if (this == DOUBLE) {
            return Double.class;
        }
        if (this == SHORT) {
            return Short.class;
        }
        if (this == INT || this == ENUM) {
            return Integer.class;
        }
        if (this == CHAR) {
            return Character.class;
        }
        if (this == BOOLEAN) {
            return Boolean.class;
        }
        if (this == LONG) {
            return Long.class;
        }
        if (this == STRING) {
            return String.class;
        }
        if (this == STRUCTURE) {
            return Object.class;
        }
        return null;
    }

    public static long unsignedIntToLong(int i) {
        return i < 0 ? (long)i + 0x100000000L : (long)i;
    }

    public static int unsignedShortToInt(short s) {
        return s & 0xFFFF;
    }

    public static short unsignedByteToShort(byte b) {
        return (short)(b & 0xFF);
    }

    static {
        hash.put("string", STRING);
        hash.put("structure", STRUCTURE);
    }
}

