/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbstractHandler;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbundanceHandler;
import ch.systemsx.cisd.openbis.etlserver.proteomics.IProtDAO;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ModificationFraction;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ModificationFractionHandler;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ProteinDescription;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.AminoAcidMass;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.AnnotatedProtein;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.DataSet;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Database;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Experiment;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Parameter;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Peptide;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.PeptideModification;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Protein;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinAnnotation;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinGroup;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinProphetDetails;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinReference;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinSummary;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinSummaryDataFilter;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sample;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sequence;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.ProbabilityToFDRCalculator;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Occurrence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.OccurrenceUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.lang.StringUtils;

class ResultDataSetUploader
extends AbstractHandler {
    private static final double MAX_FALSE_DISCOVERY_RATE = 0.1;
    static final String PARAMETER_TYPE_ABUNDANCE = "abundance";
    static final String PARAMETER_TYPE_MODIFICATION = "modification";
    private final Connection connection;
    private final IEncapsulatedOpenBISService openbisService;
    private final StringBuffer errorMessages;
    private final boolean assumingExtendedProtXML;
    private final String delimiter;
    private final boolean restrictedSampleResolving;

    ResultDataSetUploader(Connection connection, IEncapsulatedOpenBISService openbisService, boolean assumingExtendedProtXML, String delimiter, boolean restrictedSampleResolving) {
        this((IProtDAO)QueryTool.getQuery((Connection)connection, IProtDAO.class), connection, openbisService, assumingExtendedProtXML, delimiter, restrictedSampleResolving);
    }

    ResultDataSetUploader(IProtDAO dao, Connection connection, IEncapsulatedOpenBISService openbisService, boolean assumingExtendedProtXML, String delimiter, boolean restrictedSampleResolving) {
        super(dao);
        this.connection = connection;
        this.openbisService = openbisService;
        this.assumingExtendedProtXML = assumingExtendedProtXML;
        this.delimiter = delimiter;
        this.restrictedSampleResolving = restrictedSampleResolving;
        this.errorMessages = new StringBuffer();
    }

    void upload(DataSetInformation dataSetInfo, ProteinSummary summary) {
        try {
            Experiment experiment = this.getOrCreateExperiment(dataSetInfo.tryToGetExperiment().getPermId());
            ExperimentIdentifier experimentIdentifier = dataSetInfo.getExperimentIdentifier();
            String referenceDatabase = summary.getSummaryHeader().getReferenceDatabase();
            Database database = this.getOrGreateDatabase(referenceDatabase);
            DataSet ds = this.getOrCreateDataSet(experiment, database, dataSetInfo.getDataSetCode());
            this.addToDatabase(ds, experiment, experimentIdentifier, summary);
        }
        catch (Throwable throwable) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {}
            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)throwable);
        }
        if (this.errorMessages.length() != 0) {
            this.rollback();
            throw UserFailureException.fromTemplate((String)"Following errors occurred while uploading protein information to the dataset database from the dataset '%s': %s ", (Object[])new Object[]{dataSetInfo.getDataSetCode(), this.errorMessages.toString()});
        }
    }

    public void rollback() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.rollback();
                this.connection.close();
            }
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public void commit() {
        try {
            this.connection.commit();
            this.connection.close();
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private Database getOrGreateDatabase(String databaseNameAndVersion) {
        int indexOfLastSlash = databaseNameAndVersion.lastIndexOf(47);
        String nameOrVersion = indexOfLastSlash < 0 ? databaseNameAndVersion : databaseNameAndVersion.substring(indexOfLastSlash + 1);
        Database database = this.dao.tryToGetDatabaseByName(nameOrVersion);
        if (database == null) {
            database = new Database();
            database.setNameAndVersion(nameOrVersion);
            database.setId(this.dao.createDatabase(database.getNameAndVersion()));
        }
        return database;
    }

    private DataSet getOrCreateDataSet(Experiment experiment, Database database, String dataSetPermID) {
        DataSet dataSet = this.dao.tryToGetDataSetByPermID(dataSetPermID);
        if (dataSet == null) {
            dataSet = new DataSet();
            dataSet.setPermID(dataSetPermID);
            long experimentID = experiment.getId();
            dataSet.setExperimentID(experimentID);
            long databaseID = database.getId();
            dataSet.setDatabaseID(databaseID);
            dataSet.setId(this.dao.createDataSet(experimentID, dataSetPermID, databaseID));
        }
        return dataSet;
    }

    private Experiment getOrCreateExperiment(String experimentPermID) {
        Experiment experiment = this.dao.tryToGetExperimentByPermID(experimentPermID);
        if (experiment == null) {
            experiment = new Experiment();
            experiment.setPermID(experimentPermID);
            experiment.setId(this.dao.createExperiment(experimentPermID));
        }
        return experiment;
    }

    private void addToDatabase(DataSet dataSet, Experiment experiment, ExperimentIdentifier experimentIdentifier, ProteinSummary summary) {
        long dataSetID = dataSet.getId();
        Long databaseID = dataSet.getDatabaseID();
        AbundanceHandler abundanceHandler = new AbundanceHandler(this.openbisService, this.dao, experimentIdentifier, experiment, this.delimiter, this.restrictedSampleResolving);
        ModificationFractionHandler modificationFractionHandler = new ModificationFractionHandler(this.openbisService, this.dao, experimentIdentifier, experiment, this.delimiter, this.restrictedSampleResolving);
        ProbabilityToFDRCalculator calculator = this.createProbabilityToFDRMapping(dataSetID, summary);
        List<ProteinGroup> proteinGroups = summary.getProteinGroups();
        for (ProteinGroup proteinGroup : proteinGroups) {
            for (Protein protein : proteinGroup.getProteins()) {
                try {
                    double fdr = calculator.calculateFDR(protein.getProbability());
                    if (!Double.isNaN(fdr) && !(fdr <= 0.1)) continue;
                    this.addProtein(protein, dataSetID, databaseID, abundanceHandler, modificationFractionHandler);
                }
                catch (Exception e) {
                    this.logException(e, "protein", protein.getName());
                }
            }
        }
    }

    private void logException(Exception e, String objectType, String instanceDescription) {
        StringBuffer sb = new StringBuffer();
        sb.append("Cannot load following '");
        sb.append(objectType);
        sb.append("': ");
        sb.append(instanceDescription);
        sb.append(" because of the following exception: ");
        String message = e.getMessage();
        sb.append(message == null ? e.toString() : message);
        sb.append("\n");
        this.errorMessages.append(sb.toString());
    }

    private void addProtein(Protein protein, long dataSetID, Long databaseID, AbundanceHandler abundanceHandler, ModificationFractionHandler modificationFractionHandler) {
        long proteinID = this.dao.createProtein(dataSetID, protein.getProbability());
        for (Parameter parameter : protein.getParameters()) {
            if (!PARAMETER_TYPE_ABUNDANCE.equals(parameter.getType())) continue;
            abundanceHandler.addAbundancesToDatabase(parameter, proteinID, protein.getName());
        }
        List<Peptide> peptides = protein.getPeptides();
        HashSet<String> peptideSequences = new HashSet<String>();
        for (Peptide peptide : peptides) {
            try {
                this.addPeptide(proteinID, peptide, modificationFractionHandler);
                peptideSequences.add(peptide.getSequence());
            }
            catch (Exception e) {
                this.logException(e, "peptide", peptide.getSequence().toString());
            }
        }
        this.createIdentifiedProtein(proteinID, peptideSequences, databaseID, protein.getAnnotation(), true);
        for (AnnotatedProtein annotatedProtein : protein.getIndistinguishableProteins()) {
            this.createIdentifiedProtein(proteinID, peptideSequences, databaseID, annotatedProtein.getAnnotation(), false);
        }
    }

    private void addPeptide(long proteinID, Peptide peptide, ModificationFractionHandler modificationFractionHandler) {
        String peptideSequence = peptide.getSequence();
        int charge = peptide.getCharge();
        long peptideID = this.dao.createPeptide(proteinID, peptideSequence, charge);
        List<PeptideModification> modifications = peptide.getModifications();
        for (PeptideModification modification : modifications) {
            try {
                this.addPeptideModification(peptideID, modification);
            }
            catch (Exception e) {
                this.logException(e, PARAMETER_TYPE_MODIFICATION, modification.toString());
            }
        }
        List<ModificationFraction> modificationFractions = this.extractModificationFractions(peptide);
        if (modificationFractions.isEmpty()) {
            return;
        }
        long modPeptideID = this.dao.createModifiedPeptide(peptideID, 0.0, 0.0);
        Map<AminoAcidMass, List<ModificationFraction>> map = this.groupByPositionAndMass(modificationFractions);
        Set<Map.Entry<AminoAcidMass, List<ModificationFraction>>> entrySet = map.entrySet();
        for (Map.Entry<AminoAcidMass, List<ModificationFraction>> entry : entrySet) {
            AminoAcidMass positionAndMass = entry.getKey();
            long modID = this.createModification(modPeptideID, positionAndMass);
            List<ModificationFraction> list = entry.getValue();
            modificationFractionHandler.addModificationFractions(peptideSequence, modID, list);
        }
    }

    private Map<AminoAcidMass, List<ModificationFraction>> groupByPositionAndMass(List<ModificationFraction> modificationFractions) {
        HashMap<AminoAcidMass, List<ModificationFraction>> result = new HashMap<AminoAcidMass, List<ModificationFraction>>();
        for (ModificationFraction modificationFraction : modificationFractions) {
            AminoAcidMass positionAndMass = modificationFraction.getAminoAcidMass();
            ArrayList<ModificationFraction> list = (ArrayList<ModificationFraction>)result.get(positionAndMass);
            if (list == null) {
                list = new ArrayList<ModificationFraction>();
                result.put(positionAndMass, list);
            }
            list.add(modificationFraction);
        }
        return result;
    }

    private List<ModificationFraction> extractModificationFractions(Peptide peptide) {
        ArrayList<ModificationFraction> result = new ArrayList<ModificationFraction>();
        for (Parameter parameter : peptide.getParameters()) {
            if (!PARAMETER_TYPE_MODIFICATION.equals(parameter.getType())) continue;
            result.add(new ModificationFraction(parameter.getName(), parameter.getValue()));
        }
        return result;
    }

    private void addPeptideModification(long peptideID, PeptideModification modification) {
        double ntermMass = modification.getNTermMass();
        double ctermMass = modification.getCTermMass();
        long modPeptideID = this.dao.createModifiedPeptide(peptideID, ntermMass, ctermMass);
        List<AminoAcidMass> aminoAcidMasses = modification.getAminoAcidMasses();
        for (AminoAcidMass aminoAcidMass : aminoAcidMasses) {
            this.createModification(modPeptideID, aminoAcidMass);
        }
    }

    private long createModification(long modPeptideID, AminoAcidMass aminoAcidMass) {
        return this.dao.createModification(modPeptideID, aminoAcidMass.getPosition(), aminoAcidMass.getMass());
    }

    private void createIdentifiedProtein(long proteinID, Set<String> peptideSequences, Long databaseID, ProteinAnnotation annotation, boolean primary) {
        ProteinDescription protDesc = new ProteinDescription(annotation, proteinID, this.assumingExtendedProtXML);
        String accessionNumber = protDesc.getAccessionNumber();
        String description = protDesc.getDescription();
        ProteinReference proteinReference = this.dao.tryToGetProteinReference(accessionNumber);
        if (proteinReference == null) {
            proteinReference = new ProteinReference();
            proteinReference.setId(this.dao.createProteinReference(accessionNumber, description));
        } else if (!StringUtils.equals((String)description, (String)proteinReference.getDescription())) {
            this.dao.updateProteinReferenceDescription(proteinReference.getId(), description);
        }
        Sequence sequence = this.tryFindSequence(proteinReference.getId(), databaseID, protDesc.getSequence());
        if (sequence == null) {
            sequence = new Sequence(protDesc.getSequence());
            sequence.setDatabaseID(databaseID);
            sequence.setProteinReferenceID(proteinReference.getId());
            sequence.setId(this.dao.createSequence(sequence));
        }
        double coverage = this.calculateCoverage(sequence.getSequence(), peptideSequences);
        this.dao.createIdentifiedProtein(proteinID, sequence.getId(), coverage, primary);
    }

    private double calculateCoverage(String aminoAcidSequence, Set<String> peptideSequences) {
        List<Occurrence> list = OccurrenceUtil.getCoverage(aminoAcidSequence, peptideSequences);
        int sumPeptides = 0;
        for (Occurrence occurrence : list) {
            sumPeptides += occurrence.getWord().length();
        }
        return (double)sumPeptides / (double)aminoAcidSequence.length();
    }

    private Sequence tryFindSequence(long referenceID, Long databaseID, String sequence) {
        List<Sequence> sequences = this.dao.tryToGetSequencesByReferenceAndDatabase(referenceID, databaseID);
        if (sequences == null || sequences.isEmpty()) {
            return null;
        }
        for (Sequence foundSequence : sequences) {
            if (!sequence.equals(foundSequence.getSequence())) continue;
            return foundSequence;
        }
        return null;
    }

    private ProbabilityToFDRCalculator createProbabilityToFDRMapping(long dataSetID, ProteinSummary summary) {
        ProbabilityToFDRCalculator calculator = new ProbabilityToFDRCalculator();
        Object[] s = summary.getSummaryHeader().getProgramDetails().getSummary();
        if (s != null) {
            Object[] objectArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ProteinProphetDetails) {
                    ProteinProphetDetails details = (ProteinProphetDetails)object;
                    List<ProteinSummaryDataFilter> filters = details.getDataFilters();
                    for (ProteinSummaryDataFilter proteinSummaryDataFilter : filters) {
                        double probability = proteinSummaryDataFilter.getMinProbability();
                        double fdr = proteinSummaryDataFilter.getFalsePositiveErrorRate();
                        calculator.add(probability, fdr);
                        this.dao.createProbabilityToFDRMapping(dataSetID, probability, fdr);
                    }
                    return calculator;
                }
                ++n2;
            }
        }
        if (!this.assumingExtendedProtXML) {
            return calculator;
        }
        throw new UserFailureException("Missing Protein Prophet details.");
    }

    protected Sample getOrCreateSample(Experiment experiment, String samplePermID) {
        Sample sample = this.dao.tryToGetSampleByPermID(samplePermID);
        if (sample == null) {
            sample = new Sample();
            sample.setPermID(samplePermID);
            sample.setId(this.dao.createSample(experiment.getId(), samplePermID));
        }
        return sample;
    }
}

