/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dynamix;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dynamix.WellLocationMappingUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class HCSImageFileExtractor
extends AbstractImageFileExtractor {
    private static final String DYNAMIX_TOKEN_SEPARATOR = "_";
    private static final String POSITION_MAPPING_FILE_NAME = "pos2loc.tsv";
    private final Map<File, Map<WellLocationMappingUtils.DynamixWellPosition, WellLocation>> wellLocationMapCache = new HashMap<File, Map<WellLocationMappingUtils.DynamixWellPosition, WellLocation>>();
    private final Map<File, Date> firstMeasurementDateCache = new HashMap<File, Date>();

    public HCSImageFileExtractor(Properties properties) {
        super(properties, false);
    }

    @Override
    protected ImageFileInfo tryExtractImageInfo(File imageFile, File incomingDataSetDirectory, SampleIdentifier datasetSample) {
        String baseName = FilenameUtils.getBaseName((String)imageFile.getPath());
        String[] tokens = StringUtils.split((String)baseName, (String)DYNAMIX_TOKEN_SEPARATOR);
        if (tokens == null || tokens.length != 5) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Not enough underscore-separated tokens in %s, exactly 5 expected", imageFile));
            }
            return null;
        }
        WellLocation wellLocation = this.getWellLocation(imageFile, tokens);
        String channelCode = tokens[1].toUpperCase();
        Float timepoint = Float.valueOf(this.getSecondsFromFirstMeasurement(imageFile, tokens));
        String imageRelativePath = HCSImageFileExtractor.getRelativeImagePath(incomingDataSetDirectory, imageFile);
        ImageFileInfo info = new ImageFileInfo(channelCode, 1, 1, imageRelativePath);
        info.setTimepoint(timepoint);
        info.setWell(wellLocation.getRow(), wellLocation.getColumn());
        return info;
    }

    private long getSecondsFromFirstMeasurement(File imageFile, String[] tokens) {
        Date firstMeasurementDate = this.getFirstMeasurementDate(imageFile);
        return HCSImageFileExtractor.getSecondsFromFirstMeasurement(tokens, firstMeasurementDate);
    }

    private Date getFirstMeasurementDate(File imageFile) {
        File wellImagesDir = imageFile.getParentFile();
        Date date = this.firstMeasurementDateCache.get(wellImagesDir);
        if (date == null) {
            date = HCSImageFileExtractor.calculateFirstMeasurementDate(imageFile);
            this.firstMeasurementDateCache.put(wellImagesDir, date);
        }
        return date;
    }

    private static Date calculateFirstMeasurementDate(File imageFile) {
        Object[] images = imageFile.getParentFile().listFiles();
        Arrays.sort(images);
        String firstMeasurementFilePath = ((File)images[0]).getPath();
        String firstMeasurementFileBaseName = FilenameUtils.getBaseName((String)firstMeasurementFilePath);
        String[] firstMeasurementTokens = StringUtils.split((String)firstMeasurementFileBaseName, (String)DYNAMIX_TOKEN_SEPARATOR);
        return HCSImageFileExtractor.parseDate(firstMeasurementTokens);
    }

    @Private
    static long getSecondsFromFirstMeasurement(String[] tokens, Date firstMeasurementDate) {
        Date thisMeasurementDate = HCSImageFileExtractor.parseDate(tokens);
        return (thisMeasurementDate.getTime() - firstMeasurementDate.getTime()) / 1000L;
    }

    @Private
    static Date parseDate(String[] tokens) {
        String dateToken = String.valueOf(tokens[3].substring(1)) + tokens[4];
        try {
            return new SimpleDateFormat("yyyymmddhhmmss").parse(dateToken);
        }
        catch (ParseException ex) {
            throw new EnvironmentFailureException("Cannot parse the data in the file name: " + ex);
        }
    }

    private WellLocation getWellLocation(File imageFile, String[] tokens) {
        Map<WellLocationMappingUtils.DynamixWellPosition, WellLocation> map = this.getWellLocationMapping(imageFile);
        String posToken = tokens[2].substring("pos".length());
        WellLocationMappingUtils.DynamixWellPosition wellPos = WellLocationMappingUtils.parseWellPosition(tokens[0], posToken);
        return map.get(wellPos);
    }

    private Map<WellLocationMappingUtils.DynamixWellPosition, WellLocation> getWellLocationMapping(File imageFile) {
        File mappingFile = HCSImageFileExtractor.getMappingFile(imageFile);
        Map<WellLocationMappingUtils.DynamixWellPosition, WellLocation> map = this.wellLocationMapCache.get(mappingFile);
        if (map == null) {
            map = WellLocationMappingUtils.parseWellLocationMap(mappingFile);
            this.wellLocationMapCache.put(mappingFile, map);
        }
        return map;
    }

    private static File getMappingFile(File imageFile) {
        File mappingDir = imageFile.getParentFile().getParentFile().getParentFile();
        return new File(mappingDir, POSITION_MAPPING_FILE_NAME);
    }
}

