/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import java.util.HashMap;
import java.util.Map;

public class Cache {
    static final long LIVE_TIME = 1000L;
    private final Map<String, TimeStampedObject<DataSet>> dataSets = new HashMap<String, TimeStampedObject<DataSet>>();
    private final Map<String, TimeStampedObject<AbstractExternalData>> externalData = new HashMap<String, TimeStampedObject<AbstractExternalData>>();
    private final Map<String, TimeStampedObject<Experiment>> experiments = new HashMap<String, TimeStampedObject<Experiment>>();
    private final ITimeProvider timeProvider;

    public Cache(ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    void putDataSet(DataSet dataSet) {
        this.dataSets.put(dataSet.getCode(), this.timestamp(dataSet));
    }

    DataSet getDataSet(String dataSetCode) {
        return (DataSet)this.getObject(this.dataSets, dataSetCode);
    }

    AbstractExternalData getExternalData(String code) {
        return (AbstractExternalData)this.getObject(this.externalData, code);
    }

    void putExternalData(AbstractExternalData dataSet) {
        this.externalData.put(dataSet.getCode(), this.timestamp(dataSet));
    }

    Experiment getExperiment(String experimentId) {
        return (Experiment)this.getObject(this.experiments, experimentId);
    }

    void putExperiment(Experiment experiment) {
        this.experiments.put(experiment.getIdentifier(), this.timestamp(experiment));
    }

    private <T> TimeStampedObject<T> timestamp(T object) {
        return new TimeStampedObject<T>(object, this.timeProvider.getTimeInMilliseconds());
    }

    private <T> T getObject(Map<String, TimeStampedObject<T>> map, String key) {
        TimeStampedObject<T> timeStampedObject = map.get(key);
        return (T)(timeStampedObject == null || this.timeProvider.getTimeInMilliseconds() - ((TimeStampedObject)timeStampedObject).timestamp > 1000L ? null : ((TimeStampedObject)timeStampedObject).object);
    }

    private static final class TimeStampedObject<T> {
        private final long timestamp;
        private final T object;

        public TimeStampedObject(T object, long timestamp) {
            this.object = object;
            this.timestamp = timestamp;
        }
    }
}

