/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.dynamix.IntensityRangeReductionFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.AbstractSpotImagesTransformerProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.ColorRangeCalculator;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageEnrichedDTO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DynamixWellBrightnessEqualizerProcessingPlugin
extends AbstractSpotImagesTransformerProcessingPlugin {
    private static final long serialVersionUID = 1L;
    private final int minRescaledColor;
    private final int maxRescaledColor;

    public DynamixWellBrightnessEqualizerProcessingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.minRescaledColor = PropertyUtils.getInt(properties, "min-color", 1);
        this.maxRescaledColor = PropertyUtils.getInt(properties, "max-color", 16383);
    }

    @Override
    protected AbstractSpotImagesTransformerProcessingPlugin.IImageTransformerFactoryProvider getTransformationProvider(List<ImgImageEnrichedDTO> spotImages, IHierarchicalContent hierarchicalContent) {
        if (spotImages.size() < 2) {
            return NO_TRANSFORMATION_PROVIDER;
        }
        HashMap<ImgImageEnrichedDTO, ColorRangeCalculator.ImagePixelsRange> rangeMap = new HashMap<ImgImageEnrichedDTO, ColorRangeCalculator.ImagePixelsRange>();
        for (ImgImageEnrichedDTO image : spotImages) {
            BufferedImage bufferedImage = DynamixWellBrightnessEqualizerProcessingPlugin.loadImage(hierarchicalContent, image);
            ColorRangeCalculator.ImagePixelsRange imageRange = ColorRangeCalculator.calculatePixelsRange(bufferedImage, this.minRescaledColor, this.maxRescaledColor);
            rangeMap.put(image, imageRange);
        }
        return DynamixWellBrightnessEqualizerProcessingPlugin.createImageTransformerFactoryProvider(rangeMap);
    }

    private static BufferedImage loadImage(IHierarchicalContent hierarchicalContent, ImgImageEnrichedDTO image) {
        IHierarchicalContentNode contentNode = hierarchicalContent.getNode(image.getFilePath());
        return ImageUtil.loadJavaAdvancedImagingTiff(contentNode.getFileContent(), ImageUtil.parseImageID(image.getImageID(), null));
    }

    private static AbstractSpotImagesTransformerProcessingPlugin.IImageTransformerFactoryProvider createImageTransformerFactoryProvider(final Map<ImgImageEnrichedDTO, ColorRangeCalculator.ImagePixelsRange> rangeMap) {
        final ColorRangeCalculator.ImagePixelsRange globalRange = ColorRangeCalculator.calculateOverlapRange(rangeMap.values());
        return new AbstractSpotImagesTransformerProcessingPlugin.IImageTransformerFactoryProvider(){

            @Override
            public IImageTransformerFactory tryGetTransformationFactory(ImgImageEnrichedDTO image) {
                ColorRangeCalculator.ImagePixelsRange imageRange = (ColorRangeCalculator.ImagePixelsRange)rangeMap.get(image);
                ColorRangeCalculator.ImagePixelsRange rescaledRange = ColorRangeCalculator.rescaleRange(imageRange, globalRange);
                operationLog.info((Object)(String.valueOf(image.getFilePath()) + " global: " + globalRange + ", local: " + imageRange + ", rescaled: " + rescaledRange));
                return new IntensityRangeReductionFactory(rescaledRange.getMin(), rescaledRange.getMax());
            }
        };
    }
}

