/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.AbstractSpotImagesTransformerProcessingPlugin;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ExampleImageTransformerFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageEnrichedDTO;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;

public class ExampleImageTransformationProcessingPlugin
extends AbstractSpotImagesTransformerProcessingPlugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String colorPattern;
    private final int brightnessDelta;
    private final ExampleImageTransformationFactoryProvider factoryProvider;

    public ExampleImageTransformationProcessingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.colorPattern = PropertyUtils.getProperty(properties, "color-pattern", "rgb");
        this.brightnessDelta = PropertyUtils.getInt(properties, "brightness-delta", 0);
        this.factoryProvider = new ExampleImageTransformationFactoryProvider();
    }

    @Override
    protected AbstractSpotImagesTransformerProcessingPlugin.IImageTransformerFactoryProvider getTransformationProvider(List<ImgImageEnrichedDTO> spotImages, IHierarchicalContent hierarchicalContent) {
        return this.factoryProvider;
    }

    private final class ExampleImageTransformationFactoryProvider
    implements AbstractSpotImagesTransformerProcessingPlugin.IImageTransformerFactoryProvider,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ExampleImageTransformationFactoryProvider() {
        }

        @Override
        public IImageTransformerFactory tryGetTransformationFactory(ImgImageEnrichedDTO image) {
            return new ExampleImageTransformerFactory(ExampleImageTransformationProcessingPlugin.this.colorPattern, ExampleImageTransformationProcessingPlugin.this.brightnessDelta);
        }
    }
}

