/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.IProfilingTable;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import java.util.HashMap;
import java.util.Map;

public class ComponentEventLogger {
    private final Map<Object, Integer> logIDs = new HashMap<Object, Integer>();
    private final IProfilingTable profilingTable;
    private final String viewId;

    public ComponentEventLogger(IProfilingTable profilingTable, String viewId) {
        this.profilingTable = profilingTable;
        this.viewId = viewId;
    }

    public void prepareLoggingBetweenEvents(final Component component, final EventPair eventPair) {
        final Object dummySource = new Object();
        component.addListener(eventPair.beforeEvent, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                Object key;
                int lastIndex;
                String id = component.getId();
                if (id.startsWith("x-") && (lastIndex = (id = component.getClass().getName()).lastIndexOf(46)) >= 0) {
                    id = id.substring(lastIndex + 1);
                }
                if ((key = be.getSource()) == null) {
                    key = dummySource;
                }
                ComponentEventLogger.this.logIDs.put(key, ComponentEventLogger.this.log("event: " + (Object)((Object)eventPair) + " (" + id + ")"));
            }
        });
        component.addListener(eventPair.afterEvent, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                Object key = be.getSource();
                if (key == null) {
                    key = dummySource;
                }
                ComponentEventLogger.this.profilingTable.logStop((Integer)ComponentEventLogger.this.logIDs.get(key));
            }
        });
    }

    private int log(String message) {
        return this.profilingTable.log(String.valueOf(message) + " [" + this.viewId + "]");
    }

    public static enum EventPair {
        RENDER(Events.BeforeRender, Events.Render),
        LAYOUT(Events.BeforeLayout, Events.AfterLayout);

        private final EventType beforeEvent;
        private final EventType afterEvent;

        private EventPair(EventType beforeEvent, EventType afterEvent) {
            this.beforeEvent = beforeEvent;
            this.afterEvent = afterEvent;
        }
    }
}

