/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IJythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IAtomicEvaluation;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IEvaluationRunner;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.ManagedPropertyFunctions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class JythonEvaluatorPool
implements IJythonEvaluatorPool {
    private static Logger log = LogFactory.getLogger(LogCategory.OPERATION, JythonEvaluatorPool.class);
    public static int DEFAULT_POOL_SIZE = 100;
    private Map<String, EvaluatorState> cache;
    private Lock cacheLock;

    public JythonEvaluatorPool(IDAOFactory daoFactory, String poolSize) {
        this(daoFactory, JythonEvaluatorPool.createCache(poolSize));
    }

    public JythonEvaluatorPool(IDAOFactory daoFactory, Map<String, EvaluatorState> cache) {
        this.cache = cache;
        this.cacheLock = new ReentrantLock();
        for (ScriptPE script : daoFactory.getScriptDAO().listEntities(ScriptType.MANAGED_PROPERTY, null)) {
            try {
                cache.put(script.getScript(), new EvaluatorState(this.createEvaluatorFor("", ManagedPropertyFunctions.class, script.getScript())));
            }
            catch (EvaluatorException e) {
                log.warn((Object)("Could not create evaluator for script " + script.getName()), (Throwable)e);
            }
        }
        log.info((Object)("Initialization successful with " + cache.size() + " evaluators"));
    }

    @Override
    public IEvaluationRunner getManagedPropertiesRunner(String script) {
        return this.getRunner("", ManagedPropertyFunctions.class, script);
    }

    @Override
    public IEvaluationRunner getRunner(final String expression, final Class<?> clazz, final String script) {
        return new IEvaluationRunner(){

            @Override
            public <T> T evaluate(IAtomicEvaluation<T> evaluation) {
                return (T)JythonEvaluatorPool.this.evaluate(expression, clazz, script, evaluation);
            }
        };
    }

    private <T> T evaluate(String expression, Class<?> clazz, String script, IAtomicEvaluation<T> evaluation) {
        String key = this.generateKey(expression, clazz, script);
        EvaluatorState state = this.cache.get(key);
        if (state == null) {
            this.cacheLock.lock();
            try {
                state = this.cache.get(key);
                if (state == null) {
                    state = new EvaluatorState(this.createEvaluatorFor(expression, clazz, script));
                    this.cache.put(key, state);
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        Lock lock = state.getLock();
        lock.lock();
        state.push();
        try {
            T t = evaluation.evaluate(state.getEvaluator());
            return t;
        }
        finally {
            state.pop();
            lock.unlock();
        }
    }

    String generateKey(String expression, Class<?> clazz, String script) {
        String key = String.valueOf(expression) + "#" + script + "#" + clazz.getCanonicalName();
        return key;
    }

    String generateKeyForManagedProperties(String script) {
        return this.generateKey("", ManagedPropertyFunctions.class, script);
    }

    private Evaluator createEvaluatorFor(String expression, Class<?> clazz, String script) {
        return new Evaluator(expression, clazz, script);
    }

    static Map<String, EvaluatorState> createCache(String poolSize) {
        int size = DEFAULT_POOL_SIZE;
        try {
            int number = Integer.parseInt(poolSize);
            if (number > 0) {
                size = number;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return JythonEvaluatorPool.createCache(size);
    }

    static Map<String, EvaluatorState> createCache(final int poolSize) {
        return new LinkedHashMap<String, EvaluatorState>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, EvaluatorState> eldest) {
                return this.size() > poolSize;
            }
        };
    }

    public static class EvaluatorState {
        private final Evaluator evaluator;
        private final Map<String, Object> initialGlobals;
        private Stack<Map<String, Object>> globalsStack;
        private final Lock lock;

        public EvaluatorState(Evaluator evaluator) {
            this.evaluator = evaluator;
            this.lock = new ReentrantLock();
            this.globalsStack = new Stack();
            this.initialGlobals = new HashMap<String, Object>();
            for (String globalName : evaluator.getGlobalVariables()) {
                this.initialGlobals.put(globalName, evaluator.get(globalName));
            }
        }

        public void push() {
            HashMap<String, Object> globalsValues = new HashMap<String, Object>();
            for (String globalName : this.evaluator.getGlobalVariables()) {
                Object globalValue = this.evaluator.get(globalName);
                globalsValues.put(globalName, globalValue);
            }
            this.globalsStack.push(globalsValues);
            for (String globalName : globalsValues.keySet()) {
                this.evaluator.delete(globalName);
            }
            for (String globalName : this.initialGlobals.keySet()) {
                this.evaluator.set(globalName, this.initialGlobals.get(globalName));
            }
        }

        public void pop() {
            Map<String, Object> globalsValues = this.globalsStack.pop();
            for (String globalName : this.evaluator.getGlobalVariables()) {
                this.evaluator.delete(globalName);
            }
            for (String globalName : globalsValues.keySet()) {
                this.evaluator.set(globalName, globalsValues.get(globalName));
            }
            if (this.globalsStack.isEmpty()) {
                this.evaluator.releaseResources();
            }
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        public Lock getLock() {
            return this.lock;
        }
    }
}

