/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.event;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteDataSetEventParser {
    private EventPE event;

    public DeleteDataSetEventParser(EventPE event) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        this.event = event;
    }

    public List<DeletedDataSet> getDeletedDatasets() {
        ArrayList<DeletedDataSet> deletedDatasets = new ArrayList<DeletedDataSet>();
        Iterator<DeletedDataSetLocation> locationIterator = this.getLocations().iterator();
        for (String identifier : this.event.getIdentifiers()) {
            DeletedDataSet deletedDataSet = new DeletedDataSet(this.event.getId(), identifier);
            if (locationIterator.hasNext()) {
                deletedDataSet.setLocationObjectOrNull(locationIterator.next());
            }
            deletedDatasets.add(deletedDataSet);
        }
        return deletedDatasets;
    }

    private List<DeletedDataSetLocation> getLocations() {
        return DeletedDataSetLocation.parse(this.event.getDescription());
    }
}

