/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AttachmentVersionsSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractDatabaseModificationObserverWithCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserverWithMainObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewerWithVerticalSplit;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.RevertDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.EntityHistoryGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ExternalHyperlink;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria2;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.PropertiesPanelUtils;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.ContainerSamplesSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.DerivedSamplesSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.ParentSamplesSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.ParentsPropertiesSectionBuilder;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.SampleDataSetsSection;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericSampleViewer
extends AbstractViewerWithVerticalSplit<Sample>
implements IDatabaseModificationObserver {
    private static final String GENERIC_SAMPLE_VIEWER = "generic-sample-viewer";
    private static final String PREFIX = "generic-sample-viewer_";
    public static final String ID_PREFIX = "openbis_generic-sample-viewer_";
    public static final String PROPERTIES_ID_PREFIX = "openbis_generic-sample-properties-viewer_";
    protected final TechId sampleId;
    private DisposableTabContent attachmentsSection;
    private DisposableTabContent containerSamplesSection;
    private DisposableTabContent derivedSamplesSection;
    private DisposableTabContent parentSamplesSection;
    private DisposableTabContent dataSetSection;
    private PropertyGrid propertyGrid;

    public static DatabaseModificationAwareComponent create(final IViewContext<IGenericClientServiceAsync> creationViewContext, final IIdAndCodeHolder identifiable) {
        GenericSampleViewer viewer = new GenericSampleViewer(creationViewContext, identifiable){

            @Override
            protected void loadSampleGenerationInfo(TechId sampleTechId, AsyncCallback<SampleParentWithDerived> callback) {
                TechId techId = TechId.create(identifiable);
                ((IGenericClientServiceAsync)creationViewContext.getService()).getSampleGenerationInfo(techId, callback);
            }
        };
        viewer.reloadAllData();
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    protected abstract void loadSampleGenerationInfo(TechId var1, AsyncCallback<SampleParentWithDerived> var2);

    protected GenericSampleViewer(IViewContext<?> viewContext, IIdAndCodeHolder identifiable) {
        super(viewContext, GenericSampleViewer.createId(identifiable));
        this.setLayout((Layout)new BorderLayout());
        this.sampleId = TechId.create(identifiable);
        this.extendToolBar();
    }

    @Override
    protected void fillBreadcrumbWidgets(List<Widget> widgets) {
        if (((Sample)this.originalData).getSpace() != null) {
            Widget spaceBreadcrumb = this.createSpaceLink(((Sample)this.originalData).getSpace());
            widgets.add(spaceBreadcrumb);
        }
        if (((Sample)this.originalData).getExperiment() != null) {
            Widget projectBreadcrumb = this.createProjectLink(((Sample)this.originalData).getExperiment().getProject());
            widgets.add(projectBreadcrumb);
            Widget experimentBreadcrumb = this.createEntityLink(((Sample)this.originalData).getExperiment());
            widgets.add(experimentBreadcrumb);
        }
        super.fillBreadcrumbWidgets(widgets);
    }

    private void extendToolBar() {
        if (this.getViewContext().isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addToolBarButton(this.createDeleteButton(new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractAsyncCallback callback = GenericSampleViewer.this.isTrashEnabled() ? GenericSampleViewer.this.createDeletionCallback() : GenericSampleViewer.this.createPermanentDeletionCallback();
                new SampleListDeletionConfirmationDialog<IEntityInformationHolder>(GenericSampleViewer.this.getViewContext().getCommonViewContext(), GenericSampleViewer.this.getOriginalDataAsSingleton(), (AsyncCallback<Void>)callback, GenericSampleViewer.this.getOriginalData()).show();
            }
        }));
        this.addToolBarButton(this.createRevertDeletionButton(new IDelegatedAction(){

            @Override
            public void execute() {
                new RevertDeletionConfirmationDialog(GenericSampleViewer.this.getViewContext().getCommonViewContext(), (IEntityWithDeletionInformation)GenericSampleViewer.this.getOriginalData(), (AsyncCallback<Void>)GenericSampleViewer.this.createRevertDeletionCallback()).show();
            }
        }));
    }

    @Override
    protected void reloadAllData() {
        this.reloadSampleGenerationData(new SampleGenerationInfoCallback(this.getViewContext(), this));
    }

    public static final String createId(IIdAndCodeHolder identifiable) {
        return GenericSampleViewer.createId(TechId.create(identifiable));
    }

    public static final String createId(TechId sampleId) {
        return ID_PREFIX + sampleId;
    }

    private final Component createRightPanel(SampleParentWithDerived sampleGeneration) {
        Sample generator = sampleGeneration.getParent();
        IViewContext<?> context = this.getViewContext();
        SectionsPanel container = new SectionsPanel(context.getCommonViewContext(), this.getId());
        container.setDisplayID(DisplayTypeIDGenerator.GENERIC_SAMPLE_VIEWER, this.displayIdSuffix);
        List<TabContent> additionalPanels = this.createAdditionalSectionPanels();
        for (TabContent panel : additionalPanels) {
            container.addSection(panel);
        }
        this.containerSamplesSection = new ContainerSamplesSection(context, generator);
        container.addSection(this.containerSamplesSection);
        this.derivedSamplesSection = new DerivedSamplesSection(context, generator);
        container.addSection(this.derivedSamplesSection);
        this.parentSamplesSection = new ParentSamplesSection(context, generator);
        container.addSection(this.parentSamplesSection);
        this.dataSetSection = new SampleDataSetsSection(context, this.sampleId, generator.getSampleType());
        container.addSection(this.dataSetSection);
        container.addSection(EntityHistoryGrid.createPropertiesHistorySection(this.viewContext, EntityKind.SAMPLE, this.sampleId));
        this.attachmentsSection = this.createAttachmentsSection(generator);
        container.addSection(this.attachmentsSection);
        container.layout();
        this.attachManagedPropertiesSections(container, generator);
        this.moduleSectionManager.initialize(container, generator);
        this.attachWebAppsSections(container, generator, WebAppContext.SAMPLE_DETAILS_VIEW);
        return container;
    }

    protected List<TabContent> createAdditionalSectionPanels() {
        return new ArrayList<TabContent>();
    }

    private AttachmentVersionsSection createAttachmentsSection(Sample sample) {
        return new AttachmentVersionsSection(this.getViewContext().getCommonViewContext(), sample);
    }

    private static final Map<String, Object> createProperties(IViewContext<?> viewContext, SampleParentWithDerived sampleGeneration) {
        Experiment experiment;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Sample sample = sampleGeneration.getParent();
        SampleType sampleType = sample.getSampleType();
        Sample[] generated = sampleGeneration.getDerived();
        properties.put(viewContext.getMessage("sample_properties_panel_sample_identifier", new Object[0]), sample.getIdentifier());
        properties.put(viewContext.getMessage("perm_id", new Object[0]), (Object)new ExternalHyperlink(sample.getPermId(), sample.getPermlink()));
        properties.put(viewContext.getMessage("sample_type", new Object[0]), sampleType);
        properties.put(viewContext.getMessage("registrator", new Object[0]), sample.getRegistrator());
        properties.put(viewContext.getMessage("registration_date", new Object[0]), sample.getRegistrationDate());
        Deletion deletion = sample.getDeletion();
        if (deletion != null) {
            properties.put(viewContext.getMessage("deletion", new Object[0]), deletion);
        }
        if ((experiment = sample.getExperiment()) != null) {
            properties.put(viewContext.getMessage("project", new Object[0]), experiment.getProject());
            properties.put(viewContext.getMessage("experiment", new Object[0]), experiment);
        }
        if (generated.length == 1) {
            properties.put(viewContext.getMessage("derived_sample", new Object[0]), generated);
        } else if (generated.length > 1) {
            properties.put(viewContext.getMessage("derived_samples", new Object[0]), generated.length);
        }
        Set<Sample> parents = sample.getParents();
        int parentsSize = parents.size();
        if (parentsSize == 1) {
            properties.put(viewContext.getMessage("parent", new Object[0]), parents.iterator().next());
        } else if (parentsSize > 1) {
            properties.put(viewContext.getMessage("parents", new Object[0]), parentsSize);
        }
        Sample partOf = sample.getContainer();
        if (partOf != null) {
            properties.put(viewContext.getMessage("part_of", new Object[0]), partOf);
        }
        PropertiesPanelUtils.addMetaprojects(viewContext, properties, sample.getMetaprojects());
        PropertiesPanelUtils.addEntityProperties(viewContext, properties, sample.getProperties());
        return properties;
    }

    private final Component createLeftPanel(SampleParentWithDerived sampleGeneration) {
        ContentPanel panel = new ContentPanel();
        panel.setScrollMode(Style.Scroll.AUTOY);
        panel.setHeading(this.getViewContext().getMessage("sample_properties_heading", new Object[0]));
        this.viewContext.log("create property section");
        this.propertyGrid = GenericSampleViewer.createPropertyGrid(this.getViewContext(), this.sampleId);
        this.propertyGrid.getElement().setId(PROPERTIES_ID_PREFIX + this.sampleId);
        this.updateProperties(sampleGeneration);
        panel.add((Widget)this.propertyGrid);
        return panel;
    }

    public static PropertyGrid createPropertyGrid(IViewContext<?> viewContext, TechId sampleId) {
        IViewContext<?> messageProvider = viewContext;
        PropertyGrid propertyGrid = new PropertyGrid(viewContext, 0);
        propertyGrid.registerPropertyValueRenderer(SampleType.class, PropertyValueRenderers.createSampleTypePropertyValueRenderer(messageProvider));
        return propertyGrid;
    }

    public final void updateProperties(SampleParentWithDerived sampleGeneration) {
        Set<Sample> parents;
        this.propertyGrid.resizeRows(0);
        Map<String, Object> properties = GenericSampleViewer.createProperties(this.viewContext, sampleGeneration);
        this.propertyGrid.setProperties(properties);
        Sample sample = sampleGeneration.getParent();
        SampleType sampleType = sample.getSampleType();
        if (sampleType.isShowParentMetadata() && !(parents = sample.getParents()).isEmpty()) {
            ListSampleCriteria listCriteria = ListSampleCriteria.createForChild(new TechId(sample.getId()));
            this.viewContext.getCommonService().listSamples2(new ListSampleDisplayCriteria2(listCriteria), (AsyncCallback<TypedTableResultSet<Sample>>)new AbstractAsyncCallback<TypedTableResultSet<Sample>>(this.viewContext){

                @Override
                protected void process(TypedTableResultSet<Sample> result) {
                    GridRowModels<TableModelRowWithObject<Sample>> list = result.getResultSet().getList();
                    ParentsPropertiesSectionBuilder builder = new ParentsPropertiesSectionBuilder();
                    for (GridRowModel gridRowModel : list) {
                        Sample parent = (Sample)((TableModelRowWithObject)gridRowModel.getOriginalObject()).getObjectOrNull();
                        builder.addParent(parent);
                    }
                    for (Map.Entry entry : builder.getSections().entrySet()) {
                        String title = (String)entry.getKey();
                        List parentProperties = (List)entry.getValue();
                        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
                        PropertiesPanelUtils.addEntityProperties(this.viewContext, props, parentProperties);
                        GenericSampleViewer.this.propertyGrid.addAdditionalProperties(title, props);
                    }
                }
            });
        }
    }

    protected void reloadSampleGenerationData(AbstractAsyncCallback<SampleParentWithDerived> callback) {
        this.loadSampleGenerationInfo(this.sampleId, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.createDatabaseModificationObserver().getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.createDatabaseModificationObserver().update(observedModifications);
    }

    private IDatabaseModificationObserver createDatabaseModificationObserver() {
        CompositeDatabaseModificationObserverWithMainObserver observer = new CompositeDatabaseModificationObserverWithMainObserver(new PropertyGridDatabaseModificationObserver());
        if (this.dataSetSection != null) {
            observer.addObserver(this.dataSetSection.tryGetDatabaseModificationObserver());
        }
        if (this.attachmentsSection != null) {
            observer.addObserver(this.attachmentsSection.tryGetDatabaseModificationObserver());
        }
        if (this.containerSamplesSection != null) {
            observer.addObserver(this.containerSamplesSection.tryGetDatabaseModificationObserver());
        }
        if (this.derivedSamplesSection != null) {
            observer.addObserver(this.derivedSamplesSection.tryGetDatabaseModificationObserver());
        }
        if (this.parentSamplesSection != null) {
            observer.addObserver(this.parentSamplesSection.tryGetDatabaseModificationObserver());
        }
        return observer;
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_sample", new Object[0]);
    }

    private class PropertyGridDatabaseModificationObserver
    extends AbstractDatabaseModificationObserverWithCallback {
        private PropertyGridDatabaseModificationObserver() {
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.METAPROJECT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.METAPROJECT)};
        }

        @Override
        public void update(Set<DatabaseModificationKind> observedModifications) {
            GenericSampleViewer.this.reloadSampleGenerationData(new ReloadPropertyGridCallback(GenericSampleViewer.this.getViewContext(), GenericSampleViewer.this));
        }

        private final class ReloadPropertyGridCallback
        extends AbstractAsyncCallback<SampleParentWithDerived> {
            private final GenericSampleViewer genericSampleViewer;

            private ReloadPropertyGridCallback(IViewContext<?> viewContext, GenericSampleViewer genericSampleViewer) {
                super(viewContext);
                this.genericSampleViewer = genericSampleViewer;
            }

            @Override
            protected final void process(SampleParentWithDerived result) {
                this.genericSampleViewer.updateOriginalData(result.getParent());
                this.genericSampleViewer.updateProperties(result);
                PropertyGridDatabaseModificationObserver.this.executeSuccessfulUpdateCallback();
            }

            @Override
            public void finishOnFailure(Throwable caught) {
                this.genericSampleViewer.setupRemovedEntityView();
            }
        }
    }

    private static final class SampleGenerationInfoCallback
    extends AbstractAsyncCallback<SampleParentWithDerived> {
        private final GenericSampleViewer genericSampleViewer;

        private SampleGenerationInfoCallback(IViewContext<?> viewContext, GenericSampleViewer genericSampleViewer) {
            super(viewContext);
            this.genericSampleViewer = genericSampleViewer;
        }

        @Override
        protected final void process(SampleParentWithDerived result) {
            this.genericSampleViewer.updateOriginalData(result.getParent());
            this.genericSampleViewer.removeAll();
            Component leftPanel = this.genericSampleViewer.createLeftPanel(result);
            this.genericSampleViewer.add((Widget)leftPanel, (LayoutData)this.genericSampleViewer.createLeftBorderLayoutData());
            this.genericSampleViewer.configureLeftPanel(leftPanel);
            Component rightPanel = this.genericSampleViewer.createRightPanel(result);
            this.genericSampleViewer.add((Widget)rightPanel, (LayoutData)GenericSampleViewer.createRightBorderLayoutData());
            this.genericSampleViewer.layout();
        }
    }
}

