/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListSampleAbundanceByProteinCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinRelatedSample;
import java.util.Arrays;
import java.util.List;

public class ProteinRelatedSampleGrid
extends TypedTableGrid<ProteinRelatedSample> {
    private static final String PREFIX = "openbis_protein_related_sample_grid";
    public static final String BROWSER_ID = "openbis_protein_related_sample_grid_main";
    public static final String GRID_ID = "openbis_protein_related_sample_grid-grid";
    public static final String EDIT_BUTTON_ID = "openbis_protein_related_sample_grid_main_edit-button";
    public static final String SHOW_DETAILS_BUTTON_ID = "openbis_protein_related_sample_grid_main_show-details-button";
    private final IViewContext<IPhosphoNetXClientServiceAsync> phosphoViewContext;
    private ListSampleAbundanceByProteinCriteria criteria;

    public static IDisposableComponent createGridForProteinSamples(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, TechId proteinReferenceID, Long experimentIDOrNull, String gridId) {
        ListSampleAbundanceByProteinCriteria criteria = new ListSampleAbundanceByProteinCriteria();
        criteria.setProteinReferenceID(proteinReferenceID);
        criteria.setExperimentID(experimentIDOrNull);
        ProteinRelatedSampleGrid browserGrid = new ProteinRelatedSampleGrid(viewContext, criteria, gridId);
        return browserGrid.asDisposableWithoutToolbar();
    }

    private ProteinRelatedSampleGrid(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, ListSampleAbundanceByProteinCriteria criteria, String gridId) {
        super(viewContext.getCommonViewContext(), gridId, true, DisplayTypeIDGenerator.SAMPLE_DETAILS_GRID);
        this.phosphoViewContext = viewContext;
        this.setId(BROWSER_ID);
        this.criteria = criteria;
        this.registerListenerAndLinkGenerator("SAMPLE_IDENTIFIER", new ICellListenerAndLinkGenerator<ProteinRelatedSample>(){

            @Override
            public void handle(TableModelRowWithObject<ProteinRelatedSample> rowItem, boolean specialKeyPressed) {
                ProteinRelatedSampleGrid.this.showEntityInformationHolderViewer(rowItem.getObjectOrNull(), false, specialKeyPressed);
            }

            @Override
            public String tryGetLink(ProteinRelatedSample entity, ISerializableComparable comparableValue) {
                return LinkExtractor.tryExtract(entity);
            }
        });
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<ProteinRelatedSample>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<ProteinRelatedSample>> callback) {
        this.criteria.copyPagingConfig(resultSetConfig);
        this.phosphoViewContext.getService().listProteinRelatedSamplesByProtein(this.criteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("SAMPLE_IDENTIFIER", "ABUNDANCE");
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<ProteinRelatedSample>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.phosphoViewContext.getService().prepareExportProteinRelatedSamples(exportCriteria, callback);
    }
}

